/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.api.callback;

import io.github.dsheirer.source.tuner.sdrplay.api.callback.IStreamCallbackListener;
import io.github.dsheirer.source.tuner.sdrplay.api.callback.IStreamListener;
import io.github.dsheirer.source.tuner.sdrplay.api.callback.StreamCallbackParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.util.Flag;
import io.github.dsheirer.source.tuner.sdrplay.api.v3_07.sdrplay_api_StreamCallback_t;
import io.github.dsheirer.source.tuner.sdrplay.api.v3_07.sdrplay_api_StreamCbParamsT;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SegmentScope;
import java.lang.foreign.ValueLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamCallbackAdapter
implements sdrplay_api_StreamCallback_t {
    private static final Logger mLog = LoggerFactory.getLogger(StreamCallbackAdapter.class);
    private IStreamListener mStreamListener;
    private IStreamCallbackListener mStreamCallbackListener;

    public StreamCallbackAdapter(IStreamListener streamListener, IStreamCallbackListener listener) {
        this.mStreamCallbackListener = listener;
        this.setListener(streamListener);
    }

    public void setListener(IStreamListener listener) {
        this.mStreamListener = listener;
    }

    @Override
    public void apply(MemorySegment iSamplesPointer, MemorySegment qSamplesPointer, MemorySegment parametersPointer, int sampleCount, int reset, MemorySegment deviceContext) {
        if (this.mStreamListener != null || this.mStreamCallbackListener != null) {
            try (Arena arena = Arena.openConfined();){
                StreamCallbackParameters parameters = new StreamCallbackParameters(sdrplay_api_StreamCbParamsT.ofAddress(parametersPointer, arena.scope()));
                if (this.mStreamCallbackListener != null) {
                    this.mStreamCallbackListener.process(this.mStreamListener.getTunerSelect(), parameters, reset);
                }
                if (this.mStreamListener != null) {
                    long arrayByteSize = ValueLayout.JAVA_SHORT.byteSize() * (long)sampleCount;
                    MemorySegment iSamples = MemorySegment.ofAddress((long)iSamplesPointer.address(), (long)arrayByteSize, (SegmentScope)arena.scope());
                    MemorySegment qSamples = MemorySegment.ofAddress((long)qSamplesPointer.address(), (long)arrayByteSize, (SegmentScope)arena.scope());
                    short[] i = iSamples.toArray(ValueLayout.JAVA_SHORT);
                    short[] q = qSamples.toArray(ValueLayout.JAVA_SHORT);
                    this.mStreamListener.processStream(i, q, parameters, Flag.evaluate(reset));
                }
            }
        }
    }
}

