/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.api.async;

import io.github.dsheirer.source.tuner.sdrplay.api.async.IAsyncCallback;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;

public class AsyncFuture<R>
implements Future<R> {
    private R mResult;
    private Throwable mError;
    private boolean mCancelled;
    private boolean mCompleted = false;
    private ReentrantLock mLock = new ReentrantLock();
    private IAsyncCallback mCallback;

    public synchronized void setResult(R result) {
        if (this.mCompleted) {
            throw new IllegalStateException("Future is already completed.");
        }
        this.mResult = result;
        this.finish();
    }

    public synchronized void setError(Throwable error) {
        if (this.mCompleted) {
            throw new IllegalStateException("Future is already completed.");
        }
        this.mError = error;
        this.finish();
    }

    public Throwable getError() {
        return this.mError;
    }

    public boolean hasError() {
        return this.mError != null;
    }

    private void finish() {
        this.mLock.lock();
        try {
            this.mCompleted = true;
            if (this.mCallback != null) {
                this.mCallback.complete(this);
                this.mCallback = null;
            }
        }
        finally {
            this.mLock.unlock();
        }
        this.notifyAll();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.mCancelled = true;
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.mCancelled;
    }

    @Override
    public boolean isDone() {
        return this.mCompleted;
    }

    @Override
    public synchronized R get() throws InterruptedException, ExecutionException {
        while (!this.mCompleted) {
            this.wait();
        }
        if (this.mError != null) {
            throw new ExecutionException(this.mError);
        }
        return this.mResult;
    }

    @Override
    public synchronized R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.mCompleted) {
            this.wait(unit.toMillis(timeout));
        }
        if (!this.mCompleted) {
            throw new TimeoutException("Get timeout [" + timeout + " " + String.valueOf((Object)unit) + "] exceeded without completion");
        }
        if (this.mError != null) {
            throw new ExecutionException(this.mError);
        }
        return this.mResult;
    }

    public synchronized void callback(IAsyncCallback callback) {
        if (this.mCallback != null) {
            throw new IllegalArgumentException("Callback has been registered - only one callback is supported.");
        }
        this.mLock.lock();
        try {
            if (this.mCompleted) {
                callback.complete(this);
            } else {
                this.mCallback = callback;
            }
        }
        finally {
            this.mLock.unlock();
        }
    }
}

