/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.api;

import io.github.dsheirer.source.tuner.sdrplay.api.device.RspDuoMode;
import io.github.dsheirer.source.tuner.sdrplay.api.device.TunerSelect;
import java.util.EnumSet;

public enum DeviceSelectionMode {
    SINGLE_TUNER_1("Single Tuner 1", RspDuoMode.SINGLE_TUNER, TunerSelect.TUNER_1),
    SINGLE_TUNER_2("Single Tuner 2", RspDuoMode.SINGLE_TUNER, TunerSelect.TUNER_2),
    MASTER_TUNER_1("Master - Tuner 1", RspDuoMode.MASTER, TunerSelect.TUNER_1),
    SLAVE_TUNER_2("Slave - Tuner 2", RspDuoMode.SLAVE, TunerSelect.TUNER_2);

    private String mDescription;
    private RspDuoMode mRspDuoMode;
    private TunerSelect mTunerSelect;
    public static final EnumSet<DeviceSelectionMode> MASTER_MODES;
    public static final EnumSet<DeviceSelectionMode> SLAVE_MODES;
    public static final EnumSet<DeviceSelectionMode> SINGLE_TUNER_MODES;

    private DeviceSelectionMode(String description, RspDuoMode rspDuoMode, TunerSelect tunerSelect) {
        this.mDescription = description;
        this.mRspDuoMode = rspDuoMode;
        this.mTunerSelect = tunerSelect;
    }

    public RspDuoMode getRspDuoMode() {
        return this.mRspDuoMode;
    }

    public boolean isMasterMode() {
        return MASTER_MODES.contains((Object)this);
    }

    public boolean isSlaveMode() {
        return SLAVE_MODES.contains((Object)this);
    }

    public boolean isSingleTunerMode() {
        return SINGLE_TUNER_MODES.contains((Object)this);
    }

    public TunerSelect getTunerSelect() {
        return this.mTunerSelect;
    }

    public String toString() {
        return this.mDescription;
    }

    static {
        MASTER_MODES = EnumSet.of(MASTER_TUNER_1);
        SLAVE_MODES = EnumSet.of(SLAVE_TUNER_2);
        SINGLE_TUNER_MODES = EnumSet.of(SINGLE_TUNER_1, SINGLE_TUNER_2);
    }
}

