/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay;

import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import io.github.dsheirer.source.tuner.sdrplay.DiscoveredRspTuner;
import io.github.dsheirer.source.tuner.sdrplay.IGainOverloadListener;
import io.github.dsheirer.source.tuner.sdrplay.RspTuner;
import io.github.dsheirer.source.tuner.sdrplay.RspTunerConfiguration;
import io.github.dsheirer.source.tuner.sdrplay.RspTunerController;
import io.github.dsheirer.source.tuner.sdrplay.api.SDRPlayException;
import io.github.dsheirer.source.tuner.sdrplay.api.device.TunerSelect;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.control.AgcMode;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.GainReduction;
import io.github.dsheirer.source.tuner.ui.TunerEditor;
import io.github.dsheirer.util.ThreadPool;
import java.awt.Color;
import java.awt.EventQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RspTunerEditor<C extends RspTunerConfiguration>
extends TunerEditor<RspTuner, C>
implements IGainOverloadListener {
    private Logger mLog = LoggerFactory.getLogger(RspTunerEditor.class);
    private JSlider mGainSlider;
    private JLabel mGainValueLabel;
    private JToggleButton mAgcButton;
    private JButton mGainOverloadButton;
    private AtomicBoolean mGainOverloadAlert = new AtomicBoolean();

    public RspTunerEditor(UserPreferences userPreferences, TunerManager tunerManager, DiscoveredRspTuner discoveredTuner) {
        super(userPreferences, tunerManager, discoveredTuner);
    }

    private RspTunerController getTunerController() {
        return (RspTunerController)((RspTuner)this.getTuner()).getTunerController();
    }

    protected JSlider getGainSlider() {
        if (this.mGainSlider == null) {
            this.mGainSlider = new JSlider(0, GainReduction.MIN_GAIN_INDEX, GainReduction.MAX_GAIN_INDEX, GainReduction.MIN_GAIN_INDEX);
            this.mGainSlider.setEnabled(false);
            this.mGainSlider.setMajorTickSpacing(1);
            this.mGainSlider.setPaintTicks(true);
            this.mGainSlider.addChangeListener(event -> {
                int gain = this.mGainSlider.getValue();
                if (this.hasTuner() && !this.isLoading()) {
                    try {
                        this.getTunerController().getControlRsp().setGain(gain);
                        this.save();
                    }
                    catch (Exception e) {
                        this.mLog.error("Couldn't set RSP gain to:" + gain, (Throwable)e);
                        JOptionPane.showMessageDialog(this.mGainSlider, "Couldn't set RSP gain value to " + gain);
                    }
                }
                this.getGainValueLabel().setText(String.valueOf(gain));
            });
        }
        return this.mGainSlider;
    }

    protected JLabel getGainValueLabel() {
        if (this.mGainValueLabel == null) {
            this.mGainValueLabel = new JLabel("0");
            this.mGainValueLabel.setEnabled(false);
        }
        return this.mGainValueLabel;
    }

    protected JToggleButton getAgcButton() {
        if (this.mAgcButton == null) {
            this.mAgcButton = new JToggleButton("IF AGC");
            this.mAgcButton.setEnabled(false);
            this.mAgcButton.addActionListener(e -> {
                if (this.hasTuner() && !this.isLoading()) {
                    try {
                        this.getTunerController().getControlRsp().setAgcMode(this.mAgcButton.isSelected() ? AgcMode.ENABLE : AgcMode.DISABLE);
                    }
                    catch (SDRPlayException se) {
                        this.mLog.error("Error setting AGC mode on RSP device");
                    }
                    this.save();
                }
            });
        }
        return this.mAgcButton;
    }

    protected JButton getGainOverloadButton() {
        if (this.mGainOverloadButton == null) {
            this.mGainOverloadButton = new JButton("Gain Overload");
            this.mGainOverloadButton.setToolTipText("Notification that manual gain is set too high and causing power overload.  Reduce manual gain when this flashes.");
            this.mGainOverloadButton.setEnabled(false);
        }
        return this.mGainOverloadButton;
    }

    @Override
    public void notifyGainOverload(TunerSelect tunerSelect) {
        if (this.hasTuner() && ((RspTuner)this.getTuner()).getRspTunerController().getTunerSelect() == tunerSelect) {
            EventQueue.invokeLater(() -> this.setGainOverloadAlert(true));
            ThreadPool.SCHEDULED.schedule(() -> this.setGainOverloadAlert(false), 600L, TimeUnit.MILLISECONDS);
        }
    }

    private void setGainOverloadAlert(boolean alert) {
        if (alert && this.mGainOverloadAlert.compareAndSet(false, true)) {
            this.getGainOverloadButton().setEnabled(true);
            this.getGainOverloadButton().setForeground(Color.YELLOW);
            this.getGainOverloadButton().setBackground(Color.RED);
        } else if (!alert && this.mGainOverloadAlert.compareAndSet(true, false)) {
            this.getGainOverloadButton().setEnabled(false);
            this.getGainOverloadButton().setForeground(this.getForeground());
            this.getGainOverloadButton().setBackground(this.getBackground());
        } else {
            this.mLog.info("Ignoring duplicate gain alerting - alert[" + alert + "] atomic [" + this.mGainOverloadAlert.get() + "]");
        }
    }
}

