/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay;

import io.github.dsheirer.buffer.INativeBuffer;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.ITunerErrorListener;
import io.github.dsheirer.source.tuner.TunerController;
import io.github.dsheirer.source.tuner.configuration.TunerConfiguration;
import io.github.dsheirer.source.tuner.sdrplay.IControlRsp;
import io.github.dsheirer.source.tuner.sdrplay.RspNativeBuffer;
import io.github.dsheirer.source.tuner.sdrplay.RspNativeBufferFactory;
import io.github.dsheirer.source.tuner.sdrplay.RspSampleRate;
import io.github.dsheirer.source.tuner.sdrplay.RspTunerConfiguration;
import io.github.dsheirer.source.tuner.sdrplay.api.SDRPlayException;
import io.github.dsheirer.source.tuner.sdrplay.api.callback.IDeviceEventListener;
import io.github.dsheirer.source.tuner.sdrplay.api.callback.IStreamListener;
import io.github.dsheirer.source.tuner.sdrplay.api.callback.StreamCallbackParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.device.TunerSelect;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.event.EventType;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.event.GainCallbackParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.event.PowerOverloadCallbackParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.event.RspDuoModeCallbackParameters;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RspTunerController<I extends IControlRsp>
extends TunerController
implements IDeviceEventListener,
IStreamListener {
    private static final Logger mLog = LoggerFactory.getLogger(RspTunerController.class);
    protected static final long MINIMUM_FREQUENCY = 100000L;
    protected static final long MAXIMUM_FREQUENCY = 2000000000L;
    protected static final int MIDDLE_UNUSABLE_BANDWIDTH = 0;
    private I mControlRsp;
    private RspNativeBufferFactory mNativeBufferFactory = new RspNativeBufferFactory(RspSampleRate.RATE_8_000);

    public RspTunerController(I controlRsp, ITunerErrorListener tunerErrorListener) {
        super(tunerErrorListener);
        this.mControlRsp = controlRsp;
        this.mControlRsp.resister(this, this);
        this.setMinimumFrequency(100000L);
        this.setMaximumFrequency(2000000000L);
        this.setMiddleUnusableHalfBandwidth(0);
        this.setUsableBandwidthPercentage(1.0);
    }

    @Override
    public void apply(TunerConfiguration config) throws SourceException {
        if (config instanceof RspTunerConfiguration) {
            RspTunerConfiguration rtc = (RspTunerConfiguration)config;
            super.apply(config);
            try {
                this.setSampleRate(rtc.getSampleRate());
            }
            catch (SDRPlayException se) {
                mLog.error("Error setting RSP sample rate to " + String.valueOf((Object)rtc.getSampleRate()), (Throwable)se);
            }
            try {
                this.getControlRsp().setGain(rtc.getGain());
            }
            catch (SDRPlayException se) {
                mLog.error("Error setting RSP gain index to " + rtc.getGain());
            }
        }
    }

    public I getControlRsp() {
        return this.mControlRsp;
    }

    @Override
    public TunerSelect getTunerSelect() {
        return this.mControlRsp.getTunerSelect();
    }

    @Override
    public void processStream(short[] inphase, short[] quadrature, StreamCallbackParameters parameters, boolean reset) {
        List<RspNativeBuffer> buffers = this.mNativeBufferFactory.get(inphase, quadrature, System.currentTimeMillis());
        for (RspNativeBuffer buffer : buffers) {
            this.mNativeBufferBroadcaster.broadcast(buffer);
        }
        if (reset) {
            // empty if block
        }
        if (parameters.isGainReductionChanged()) {
            // empty if block
        }
        if (parameters.isRfFrequencyChanged()) {
            // empty if block
        }
        if (parameters.isSampleRateChanged()) {
            // empty if block
        }
    }

    @Override
    public void start() throws SourceException {
        try {
            this.mControlRsp.start();
        }
        catch (SDRPlayException se) {
            throw new SourceException("Unable to select tuner - in use");
        }
    }

    @Override
    public void stop() {
        try {
            this.mControlRsp.stop();
        }
        catch (SDRPlayException se) {
            mLog.error("Error releasing RSP tuner device", (Throwable)se);
        }
    }

    @Override
    public void addBufferListener(Listener<INativeBuffer> listener) {
        this.mBufferListenerLock.lock();
        try {
            if (!this.hasBufferListeners()) {
                this.mControlRsp.startStream();
            }
            super.addBufferListener(listener);
        }
        finally {
            this.mBufferListenerLock.unlock();
        }
    }

    @Override
    public void removeBufferListener(Listener<INativeBuffer> listener) {
        this.mBufferListenerLock.lock();
        try {
            super.removeBufferListener(listener);
            if (!this.hasBufferListeners()) {
                this.mControlRsp.stopStream();
            }
        }
        finally {
            this.mBufferListenerLock.unlock();
        }
    }

    @Override
    public long getTunedFrequency() throws SourceException {
        try {
            return this.getControlRsp().getTunedFrequency();
        }
        catch (SDRPlayException se) {
            throw new SourceException("Error setting tuned frequency", se);
        }
    }

    @Override
    public void setTunedFrequency(long frequency) throws SourceException {
        try {
            this.getControlRsp().setTunedFrequency(frequency);
        }
        catch (SDRPlayException se) {
            throw new SourceException("Unable to set center frequency [" + frequency + "]", se);
        }
    }

    public void setSampleRate(RspSampleRate rspSampleRate) throws SDRPlayException {
        this.getControlRsp().setSampleRate(rspSampleRate);
        try {
            this.mFrequencyController.setSampleRate((int)rspSampleRate.getEffectiveSampleRate());
        }
        catch (SourceException se) {
            mLog.error("Error setting sample rate in frequency controller");
        }
        this.setUsableBandwidthPercentage(rspSampleRate.getUsableBandwidth());
        this.mNativeBufferFactory.setSampleRate(rspSampleRate);
    }

    @Override
    public double getCurrentSampleRate() throws SourceException {
        return this.getControlRsp().getCurrentSampleRate();
    }

    @Override
    public int getBufferSampleCount() {
        return 128;
    }

    @Override
    public void processEvent(EventType eventType, TunerSelect tunerSelect) {
    }

    @Override
    public void processGainChange(TunerSelect tunerSelect, GainCallbackParameters parameters) {
    }

    @Override
    public void processRspDuoModeChange(TunerSelect tunerSelect, RspDuoModeCallbackParameters parameters) {
    }

    @Override
    public void processPowerOverload(TunerSelect tunerSelect, PowerOverloadCallbackParameters parameters) {
        if (this.getControlRsp() != null) {
            try {
                this.getControlRsp().acknowledgePowerOverload(tunerSelect);
            }
            catch (SDRPlayException se) {
                mLog.error("Unable to acknowledge power overload for [" + String.valueOf((Object)tunerSelect) + "]", (Throwable)se);
            }
        }
    }

    @Override
    public void processDeviceRemoval(TunerSelect tunerSelect) {
        mLog.info("Processing device removal for tuner [" + String.valueOf((Object)tunerSelect) + "] controller class [" + this.getClass().getSimpleName() + "]");
        if (this.getControlRsp() != null) {
            this.getControlRsp().deviceRemoved();
        }
        this.tunerRemoved();
    }
}

