/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay;

import io.github.dsheirer.preference.source.ChannelizerType;
import io.github.dsheirer.source.tuner.ITunerErrorListener;
import io.github.dsheirer.source.tuner.Tuner;
import io.github.dsheirer.source.tuner.TunerClass;
import io.github.dsheirer.source.tuner.sdrplay.IControlRsp;
import io.github.dsheirer.source.tuner.sdrplay.RspTunerController;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.IControlRspDuoTuner1;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.IControlRspDuoTuner2;

public class RspTuner
extends Tuner {
    public RspTuner(RspTunerController tunerController, ITunerErrorListener tunerErrorListener, ChannelizerType channelizerType) {
        super(tunerController, tunerErrorListener, channelizerType);
    }

    @Override
    public int getMaximumUSBBitsPerSecond() {
        return 320000000;
    }

    @Override
    public String getUniqueID() {
        return this.getRspTunerController().getControlRsp().getDevice().getSerialNumber();
    }

    @Override
    public TunerClass getTunerClass() {
        return TunerClass.RSP;
    }

    public RspTunerController getRspTunerController() {
        return (RspTunerController)this.getTunerController();
    }

    @Override
    public String getPreferredName() {
        if (this.getRspTunerController().getControlRsp() instanceof IControlRspDuoTuner1 && this.getRspTunerController().getControlRsp().getDevice() != null) {
            return String.valueOf((Object)this.getRspTunerController().getControlRsp().getDevice().getDeviceType()) + " SER:" + this.getRspTunerController().getControlRsp().getDevice().getSerialNumber() + " Tuner 1";
        }
        if (this.getRspTunerController().getControlRsp() instanceof IControlRspDuoTuner2 && this.getRspTunerController().getControlRsp().getDevice() != null) {
            return String.valueOf((Object)this.getRspTunerController().getControlRsp().getDevice().getDeviceType()) + " SER:" + this.getRspTunerController().getControlRsp().getDevice().getSerialNumber() + " Tuner 2";
        }
        if (this.getRspTunerController().getControlRsp() instanceof IControlRsp && this.getRspTunerController().getControlRsp().getDevice() != null) {
            return String.valueOf((Object)this.getRspTunerController().getControlRsp().getDevice().getDeviceType()) + " SER:" + this.getRspTunerController().getControlRsp().getDevice().getSerialNumber();
        }
        return "RSP Tuner - Device Not Available";
    }

    @Override
    public double getSampleSize() {
        return this.getRspTunerController().getControlRsp().getSampleRateEnumeration().getSampleSize();
    }
}

