/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay;

import io.github.dsheirer.preference.source.ChannelizerType;
import io.github.dsheirer.source.tuner.TunerClass;
import io.github.dsheirer.source.tuner.TunerFactory;
import io.github.dsheirer.source.tuner.manager.DiscoveredTuner;
import io.github.dsheirer.source.tuner.sdrplay.IControlRsp;
import io.github.dsheirer.source.tuner.sdrplay.api.device.DeviceInfo;
import io.github.dsheirer.source.tuner.sdrplay.api.device.DeviceType;

public abstract class DiscoveredRspTuner<R extends IControlRsp>
extends DiscoveredTuner {
    private final DeviceInfo mDeviceInfo;
    private final ChannelizerType mChannelizerType;

    public DiscoveredRspTuner(DeviceInfo deviceInfo, ChannelizerType channelizerType) {
        this.mDeviceInfo = deviceInfo;
        this.mChannelizerType = channelizerType;
    }

    public DeviceInfo getDeviceInfo() {
        return this.mDeviceInfo;
    }

    protected ChannelizerType getChannelizerType() {
        return this.mChannelizerType;
    }

    @Override
    public TunerClass getTunerClass() {
        return TunerClass.RSP;
    }

    public DeviceType getDeviceType() {
        return this.mDeviceInfo.getDeviceType();
    }

    @Override
    public void start() {
        if (this.isAvailable() && !this.hasTuner()) {
            try {
                this.mTuner = TunerFactory.getRspTuner(this.getDeviceInfo(), this.getChannelizerType(), this);
            }
            catch (Exception se) {
                this.setErrorMessage("Tuner unavailable [" + this.getId() + "]");
                this.mTuner = null;
            }
            if (this.hasTuner()) {
                try {
                    this.mTuner.start();
                }
                catch (Exception se) {
                    this.setErrorMessage("Error starting tuner [" + this.getId() + "]");
                    this.mTuner = null;
                }
            }
        }
    }

    @Override
    public String getId() {
        return this.getDeviceType().name() + " SER#" + this.getDeviceInfo().getSerialNumber();
    }

    public String toString() {
        return this.getId();
    }
}

