/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay;

import io.github.dsheirer.source.tuner.sdrplay.IControlRsp;
import io.github.dsheirer.source.tuner.sdrplay.IGainOverloadListener;
import io.github.dsheirer.source.tuner.sdrplay.RspSampleRate;
import io.github.dsheirer.source.tuner.sdrplay.api.DeviceSelectionMode;
import io.github.dsheirer.source.tuner.sdrplay.api.SDRPlayException;
import io.github.dsheirer.source.tuner.sdrplay.api.Status;
import io.github.dsheirer.source.tuner.sdrplay.api.UpdateReason;
import io.github.dsheirer.source.tuner.sdrplay.api.callback.IDeviceEventListener;
import io.github.dsheirer.source.tuner.sdrplay.api.callback.IStreamListener;
import io.github.dsheirer.source.tuner.sdrplay.api.device.Device;
import io.github.dsheirer.source.tuner.sdrplay.api.device.RspTuner;
import io.github.dsheirer.source.tuner.sdrplay.api.device.TunerSelect;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.composite.CompositeParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.control.AgcMode;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.device.DeviceParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.GainReduction;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.IfMode;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.LoMode;
import io.github.dsheirer.util.ThreadPool;
import java.lang.ref.WeakReference;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ControlRsp<T extends Device>
implements IControlRsp {
    private static final Logger mLog = LoggerFactory.getLogger(ControlRsp.class);
    private T mDevice;
    protected RspSampleRate mSampleRate = RspSampleRate.RATE_8_000;
    protected int mGain;
    private IDeviceEventListener mDeviceEventListener;
    private IStreamListener mStreamListener;
    protected WeakReference<IGainOverloadListener> mGainOverloadReference;
    protected ReentrantLock mStreamingLock = new ReentrantLock();
    protected boolean mStreaming = false;

    public ControlRsp(T device) {
        this.mDevice = device;
    }

    @Override
    public TunerSelect getTunerSelect() {
        return TunerSelect.TUNER_1;
    }

    @Override
    public void start() throws SDRPlayException {
        if (!this.hasDevice()) {
            throw new SDRPlayException("Unable to start - device is null");
        }
        ((Device)this.getDevice()).select();
        ((CompositeParameters)((Device)this.getDevice()).getCompositeParameters()).getControlAParameters().getDcOffset().setDC(true);
        ((CompositeParameters)((Device)this.getDevice()).getCompositeParameters()).getControlAParameters().getDcOffset().setIQ(true);
        ((Device)this.getDevice()).setIfMode(IfMode.IF_ZERO);
        ((Device)this.getDevice()).setLoMode(LoMode.AUTO);
    }

    @Override
    public void stop() throws SDRPlayException {
        if (this.hasDevice()) {
            this.stopStream();
            ((Device)this.getDevice()).release();
            this.clearDevice();
        }
    }

    @Override
    public void startStream() {
        this.mStreamingLock.lock();
        try {
            if (this.hasDevice()) {
                if (!this.mStreaming) {
                    ((Device)this.getDevice()).initStreamA(this.getDeviceEventListener(), this.getStreamListener());
                    this.mStreaming = true;
                }
            } else {
                mLog.error("Unable to start RSP device sample stream - device not started");
            }
        }
        catch (SDRPlayException se) {
            if (se.getStatus() == Status.FAIL) {
                mLog.error("Unable to start RSP streaming - device may have been unplugged - removing.");
                if (this.mDeviceEventListener != null) {
                    this.mDeviceEventListener.processDeviceRemoval(this.getTunerSelect());
                }
            } else {
                mLog.error("Unable to initialize/start streaming for RSP device", (Throwable)se);
            }
        }
        finally {
            this.mStreamingLock.unlock();
        }
    }

    @Override
    public void stopStream() {
        this.mStreamingLock.lock();
        try {
            if (this.hasDevice() && this.mStreaming) {
                ((Device)this.getDevice()).uninitialize();
            }
        }
        catch (SDRPlayException se) {
            mLog.error("Unable to uninitialize/stop streaming for RSP device");
        }
        finally {
            this.mStreaming = false;
            this.mStreamingLock.unlock();
        }
    }

    @Override
    public DeviceSelectionMode getDeviceSelectionMode() {
        return DeviceSelectionMode.SINGLE_TUNER_1;
    }

    public T getDevice() {
        return this.mDevice;
    }

    @Override
    public void deviceRemoved() {
        this.clearDevice();
        this.mStreamingLock.lock();
        try {
            this.mStreaming = false;
        }
        finally {
            this.mStreamingLock.unlock();
        }
    }

    public void clearDevice() {
        this.mDevice = null;
    }

    public boolean hasDevice() {
        return this.getDevice() != null;
    }

    @Override
    public void setSampleRate(RspSampleRate sampleRate) throws SDRPlayException {
        if (!this.hasDevice()) {
            throw new SDRPlayException("RSP tuner has not been started - can't apply sample rate");
        }
        this.mSampleRate = sampleRate;
        ((RspTuner)((Device)this.getDevice()).getTuner()).setBandwidth(sampleRate.getBandwidth());
        ((DeviceParameters)((CompositeParameters)((Device)this.getDevice()).getCompositeParameters()).getDeviceParameters()).getSamplingFrequency().setSampleRate(sampleRate.getSampleRate());
        ((Device)this.getDevice()).update(this.getTunerSelect(), UpdateReason.DEVICE_SAMPLE_RATE);
        ((CompositeParameters)((Device)this.getDevice()).getCompositeParameters()).getControlAParameters().getDecimation().setWideBandSignal(true);
        ((Device)this.getDevice()).setDecimation(sampleRate.getDecimation());
    }

    @Override
    public void setGain(int gain) throws SDRPlayException {
        this.validateGain(gain);
        if (gain != this.mGain) {
            this.mGain = gain;
            ((RspTuner)((Device)this.getDevice()).getTuner()).setGain(this.mGain);
        }
    }

    @Override
    public void setGainOverloadListener(IGainOverloadListener listener) {
        if (this.mGainOverloadReference != null && this.mGainOverloadReference.get() != null) {
            this.mGainOverloadReference.clear();
        }
        this.mGainOverloadReference = new WeakReference<IGainOverloadListener>(listener);
    }

    @Override
    public void acknowledgePowerOverload(TunerSelect tunerSelect) throws SDRPlayException {
        IGainOverloadListener listener;
        if (!this.hasDevice()) {
            throw new SDRPlayException("Device is not initialized");
        }
        ((Device)this.getDevice()).acknowledgePowerOverload(tunerSelect);
        if (this.mGainOverloadReference != null && (listener = (IGainOverloadListener)this.mGainOverloadReference.get()) != null) {
            ThreadPool.CACHED.submit(() -> listener.notifyGainOverload(tunerSelect));
        }
    }

    @Override
    public long getTunedFrequency() throws SDRPlayException {
        if (this.hasDevice()) {
            return ((RspTuner)((Device)this.getDevice()).getTuner()).getFrequency();
        }
        throw new SDRPlayException("Device is not initialized");
    }

    @Override
    public void setTunedFrequency(long frequency) throws SDRPlayException {
        if (!this.hasDevice()) {
            throw new SDRPlayException("Device is not initialized");
        }
        ((RspTuner)((Device)this.getDevice()).getTuner()).setFrequency(frequency);
    }

    @Override
    public RspSampleRate getSampleRateEnumeration() {
        return this.mSampleRate;
    }

    @Override
    public double getCurrentSampleRate() {
        return this.getSampleRateEnumeration().getEffectiveSampleRate();
    }

    @Override
    public int getGain() {
        return this.mGain;
    }

    protected void validateGain(int gain) throws SDRPlayException {
        if (gain < GainReduction.MIN_GAIN_INDEX || gain > GainReduction.MAX_GAIN_INDEX) {
            throw new SDRPlayException("Invalid gain index value [" + gain + "].  Valid range is " + GainReduction.MIN_GAIN_INDEX + " - " + GainReduction.MAX_GAIN_INDEX);
        }
    }

    @Override
    public AgcMode getAgcMode() {
        return ((CompositeParameters)((Device)this.getDevice()).getCompositeParameters()).getControlAParameters().getAgc().getAgcMode();
    }

    @Override
    public void setAgcMode(AgcMode mode) throws SDRPlayException {
        ((CompositeParameters)((Device)this.getDevice()).getCompositeParameters()).getControlAParameters().getAgc().setAgcMode(mode);
        ((Device)this.getDevice()).update(this.getTunerSelect(), UpdateReason.CONTROL_AGC);
    }

    @Override
    public void resister(IDeviceEventListener deviceEventListener, IStreamListener streamListener) {
        this.mDeviceEventListener = deviceEventListener;
        this.mStreamListener = streamListener;
    }

    protected IDeviceEventListener getDeviceEventListener() {
        return this.mDeviceEventListener;
    }

    protected IStreamListener getStreamListener() {
        return this.mStreamListener;
    }
}

