/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.rtl.r8x.r828d;

import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.TunerType;
import io.github.dsheirer.source.tuner.rtl.RTL2832TunerController;
import io.github.dsheirer.source.tuner.rtl.r8x.R8xEmbeddedTuner;
import javax.usb.UsbException;

public class R828DEmbeddedTuner
extends R8xEmbeddedTuner {
    private static final byte I2C_WRITE_ADDRESS = 116;
    private static final byte I2C_READ_ADDRESS = 117;
    private static final int VCO_POWER_REF = 1;
    private final boolean mIsV4Dongle;

    public R828DEmbeddedTuner(RTL2832TunerController.ControllerAdapter adapter) {
        super(adapter, 1);
        this.mIsV4Dongle = adapter.isV4Dongle();
    }

    @Override
    public TunerType getTunerType() {
        return TunerType.RAFAELMICRO_R828D;
    }

    @Override
    public byte getI2CWriteAddress() {
        return 116;
    }

    @Override
    public byte getI2CReadAddress() {
        return 117;
    }

    @Override
    public synchronized void setTunedFrequency(long frequency) throws SourceException {
        this.getAdapter().getLock().lock();
        try {
            this.getAdapter().enableI2CRepeater();
            boolean controlI2C = false;
            long offsetFrequency = frequency + 3570000L;
            this.setMux(offsetFrequency, controlI2C);
            this.setPLL(offsetFrequency, controlI2C);
            if (this.mIsV4Dongle) {
                boolean isNotchFilterFrequency = frequency < 2200000L || 85000000L < frequency && frequency < 112000000L || 172000000L < frequency && frequency < 242000000L;
                this.writeRegister(R8xEmbeddedTuner.Register.DRAIN, isNotchFilterFrequency ? (byte)0 : 8, controlI2C);
                if (frequency <= 28800000L) {
                    this.writeRegister(R8xEmbeddedTuner.Register.INPUT_SELECTOR_AIR, (byte)32, controlI2C);
                    this.writeRegister(R8xEmbeddedTuner.Register.INPUT_SELECTOR_CABLE_1, (byte)0, controlI2C);
                    this.writeRegister(R8xEmbeddedTuner.Register.INPUT_SELECTOR_CABLE_2, (byte)8, controlI2C);
                } else if (frequency < 250000000L) {
                    this.writeRegister(R8xEmbeddedTuner.Register.INPUT_SELECTOR_AIR, (byte)32, controlI2C);
                    this.writeRegister(R8xEmbeddedTuner.Register.INPUT_SELECTOR_CABLE_1, (byte)64, controlI2C);
                    this.writeRegister(R8xEmbeddedTuner.Register.INPUT_SELECTOR_CABLE_2, (byte)0, controlI2C);
                } else {
                    this.writeRegister(R8xEmbeddedTuner.Register.INPUT_SELECTOR_AIR, (byte)0, controlI2C);
                    this.writeRegister(R8xEmbeddedTuner.Register.INPUT_SELECTOR_CABLE_1, (byte)0, controlI2C);
                    this.writeRegister(R8xEmbeddedTuner.Register.INPUT_SELECTOR_CABLE_2, (byte)0, controlI2C);
                }
            } else {
                byte air_cable_in = frequency > 345000000L ? (byte)0 : 96;
                this.writeRegister(R8xEmbeddedTuner.Register.INPUT_SELECTOR_AIR_AND_CABLE_1, air_cable_in, controlI2C);
            }
            this.getAdapter().disableI2CRepeater();
        }
        catch (UsbException e) {
            throw new SourceException("R828DTunerController - exception while setting frequency [" + frequency + "] - " + e.getLocalizedMessage());
        }
        finally {
            this.getAdapter().getLock().unlock();
        }
    }
}

