/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.recording;

import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.source.tuner.manager.DiscoveredTuner;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import io.github.dsheirer.source.tuner.recording.RecordingTuner;
import io.github.dsheirer.source.tuner.recording.RecordingTunerConfiguration;
import io.github.dsheirer.source.tuner.ui.TunerEditor;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordingTunerEditor
extends TunerEditor<RecordingTuner, RecordingTunerConfiguration> {
    private static final long serialVersionUID = 1L;
    private static final Logger mLog = LoggerFactory.getLogger(RecordingTunerEditor.class);
    private JLabel mRecordingPath;

    public RecordingTunerEditor(UserPreferences userPreferences, TunerManager tunerManager, DiscoveredTuner discoveredTuner) {
        super(userPreferences, tunerManager, discoveredTuner);
        this.init();
        this.tunerStatusUpdated();
    }

    @Override
    public void setTunerLockState(boolean locked) {
        this.getFrequencyPanel().updateControls();
    }

    @Override
    protected void tunerStatusUpdated() {
        this.setLoading(true);
        if (this.hasTuner()) {
            this.getTunerIdLabel().setText(((RecordingTuner)this.getTuner()).getPreferredName());
        } else {
            this.getTunerIdLabel().setText(null);
        }
        Object status = this.getDiscoveredTuner().getTunerStatus().toString();
        if (this.getDiscoveredTuner().hasErrorMessage()) {
            status = (String)status + " - " + this.getDiscoveredTuner().getErrorMessage();
        }
        this.getTunerStatusLabel().setText((String)status);
        this.getButtonPanel().updateControls();
        this.getFrequencyPanel().updateControls();
        if (this.hasConfiguration()) {
            this.getRecordingPath().setText(((RecordingTunerConfiguration)this.getConfiguration()).getPath());
        }
        this.setLoading(false);
    }

    private void init() {
        this.setLayout((LayoutManager)new MigLayout("fill,wrap 3", "[right][grow,fill]", "[][][][][][][][grow]"));
        this.add(new JLabel("Tuner:"));
        this.add((Component)this.getTunerIdLabel(), "wrap");
        this.add(new JLabel("Status:"));
        this.add((Component)this.getTunerStatusLabel(), "wrap");
        this.add(new JLabel("File:"));
        this.add((Component)this.getRecordingPath(), "wrap");
        this.add((Component)this.getButtonPanel(), "span,align left");
        this.add((Component)new JSeparator(), "span,growx,push");
        this.add(new JLabel("Frequency (MHz):"));
        this.add((Component)this.getFrequencyPanel(), "wrap");
    }

    private JLabel getRecordingPath() {
        if (this.mRecordingPath == null) {
            this.mRecordingPath = new JLabel();
        }
        return this.mRecordingPath;
    }

    @Override
    public void save() {
        if (this.hasConfiguration() && !this.isLoading()) {
            RecordingTunerConfiguration config = (RecordingTunerConfiguration)this.getConfiguration();
            config.setFrequency(this.getFrequencyControl().getFrequency());
            this.saveConfiguration();
        }
    }
}

