/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.recording;

import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.preference.source.ChannelizerType;
import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.ITunerErrorListener;
import io.github.dsheirer.source.tuner.Tuner;
import io.github.dsheirer.source.tuner.TunerClass;
import io.github.dsheirer.source.tuner.TunerType;
import io.github.dsheirer.source.tuner.manager.HeterodyneChannelSourceManager;
import io.github.dsheirer.source.tuner.manager.PassThroughSourceManager;
import io.github.dsheirer.source.tuner.manager.PolyphaseChannelSourceManager;
import io.github.dsheirer.source.tuner.recording.RecordingTunerConfiguration;
import io.github.dsheirer.source.tuner.recording.RecordingTunerController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordingTuner
extends Tuner {
    private static final Logger mLog = LoggerFactory.getLogger(RecordingTuner.class);
    private static int mInstanceCounter = 1;
    private final int mInstanceID = mInstanceCounter++;
    private UserPreferences mUserPreferences;

    public RecordingTuner(UserPreferences userPreferences, ITunerErrorListener tunerErrorListener, RecordingTunerConfiguration config) {
        super(new RecordingTunerController(tunerErrorListener, config.getPath(), config.getFrequency()), tunerErrorListener);
        this.mUserPreferences = userPreferences;
    }

    @Override
    public void start() throws SourceException {
        super.start();
        if (this.getTunerController().getCurrentSampleRate() < 100000.0) {
            this.setChannelSourceManager(new PassThroughSourceManager(this.getTunerController()));
        } else {
            ChannelizerType channelizerType = this.mUserPreferences.getTunerPreference().getChannelizerType();
            if (channelizerType == ChannelizerType.POLYPHASE) {
                this.setChannelSourceManager(new PolyphaseChannelSourceManager(this.getTunerController()));
            } else if (channelizerType == ChannelizerType.HETERODYNE) {
                this.setChannelSourceManager(new HeterodyneChannelSourceManager(this.getTunerController()));
            } else {
                throw new IllegalArgumentException("Unrecognized channelizer type: " + String.valueOf((Object)channelizerType));
            }
        }
    }

    @Override
    public String getPreferredName() {
        return "Recording Tuner #" + this.mInstanceID;
    }

    @Override
    public RecordingTunerController getTunerController() {
        return (RecordingTunerController)super.getTunerController();
    }

    @Override
    public String getUniqueID() {
        return this.getPreferredName();
    }

    @Override
    public TunerClass getTunerClass() {
        return TunerClass.RECORDING_TUNER;
    }

    @Override
    public TunerType getTunerType() {
        return TunerType.RECORDING;
    }

    @Override
    public double getSampleSize() {
        return 16.0;
    }

    @Override
    public int getMaximumUSBBitsPerSecond() {
        return 0;
    }
}

