/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.manager;

import io.github.dsheirer.preference.source.ChannelizerType;
import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.TunerClass;
import io.github.dsheirer.source.tuner.TunerFactory;
import io.github.dsheirer.source.tuner.manager.DiscoveredTuner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveredUSBTuner
extends DiscoveredTuner {
    private Logger mLog = LoggerFactory.getLogger(DiscoveredUSBTuner.class);
    private TunerClass mTunerClass;
    private int mBus;
    private String mPortAddress;
    private ChannelizerType mChannelizerType;

    public DiscoveredUSBTuner(TunerClass tunerClass, int bus, String portAddress, ChannelizerType channelizerType) {
        this.mTunerClass = tunerClass;
        this.mBus = bus;
        this.mPortAddress = portAddress;
        this.mChannelizerType = channelizerType;
    }

    public boolean isAt(int bus, String port) {
        return this.mBus == bus && port != null && port.equalsIgnoreCase(this.mPortAddress);
    }

    @Override
    public TunerClass getTunerClass() {
        return this.mTunerClass;
    }

    public int getBus() {
        return this.mBus;
    }

    public String getPortAddress() {
        return this.mPortAddress;
    }

    @Override
    public String getId() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getTunerClass());
        sb.append(" USB Bus:").append(this.getBus());
        sb.append(" Port:").append(this.getPortAddress());
        return sb.toString();
    }

    @Override
    public void start() {
        if (this.isAvailable() && !this.hasTuner()) {
            try {
                this.mTuner = TunerFactory.getUsbTuner(this.getTunerClass(), this.getPortAddress(), this.getBus(), this, this.mChannelizerType);
                this.mTuner.start();
            }
            catch (SourceException se) {
                this.setErrorMessage(se.getMessage());
                this.mLog.error("Unable to start tuner [" + String.valueOf((Object)this.getTunerClass()) + "] - error: " + this.getErrorMessage());
            }
        }
    }

    public String toString() {
        return "USB Tuner - " + this.getId();
    }
}

