/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.hackrf;

import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.hackrf.HackRFTuner;
import io.github.dsheirer.source.tuner.hackrf.HackRFTunerConfiguration;
import io.github.dsheirer.source.tuner.hackrf.HackRFTunerController;
import io.github.dsheirer.source.tuner.manager.DiscoveredTuner;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import io.github.dsheirer.source.tuner.ui.TunerEditor;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.usb.UsbException;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HackRFTunerEditor
extends TunerEditor<HackRFTuner, HackRFTunerConfiguration> {
    private static final long serialVersionUID = 1L;
    private static final Logger mLog = LoggerFactory.getLogger(HackRFTunerEditor.class);
    private JButton mTunerInfo;
    private JComboBox<HackRFTunerController.HackRFSampleRate> mSampleRateCombo;
    private JToggleButton mAmplifier;
    private JComboBox<HackRFTunerController.HackRFLNAGain> mLnaGainCombo;
    private JComboBox<HackRFTunerController.HackRFVGAGain> mVgaGainCombo;

    public HackRFTunerEditor(UserPreferences userPreferences, TunerManager tunerManager, DiscoveredTuner discoveredTuner) {
        super(userPreferences, tunerManager, discoveredTuner);
        this.init();
        this.tunerStatusUpdated();
    }

    private void init() {
        this.setLayout((LayoutManager)new MigLayout("fill,wrap 3", "[right][grow,fill][fill]", "[][][][][][][][][][][grow]"));
        this.add(new JLabel("Tuner:"));
        this.add(this.getTunerIdLabel());
        this.add(this.getTunerInfoButton());
        this.add(new JLabel("Status:"));
        this.add((Component)this.getTunerStatusLabel(), "wrap");
        this.add((Component)this.getButtonPanel(), "span,align left");
        this.add((Component)new JSeparator(), "span,growx,push");
        this.add(new JLabel("Frequency (MHz):"));
        this.add((Component)this.getFrequencyPanel(), "wrap");
        this.add(new JLabel("Sample Rate:"));
        this.add((Component)this.getSampleRateCombo(), "wrap");
        this.add((Component)new JSeparator(), "span,growx,push");
        this.add(new JLabel("Gain Control"));
        this.add((Component)this.getAmplifierToggle(), "wrap");
        this.add(new JLabel("LNA:"));
        this.add((Component)this.getLnaGainCombo(), "wrap");
        this.add(new JLabel("VGA:"));
        this.add((Component)this.getVgaGainCombo(), "wrap");
    }

    @Override
    protected void tunerStatusUpdated() {
        this.setLoading(true);
        if (this.hasTuner()) {
            this.getTunerIdLabel().setText(((HackRFTuner)this.getTuner()).getPreferredName());
        } else {
            this.getTunerIdLabel().setText(this.getDiscoveredTuner().getId());
        }
        Object status = this.getDiscoveredTuner().getTunerStatus().toString();
        if (this.getDiscoveredTuner().hasErrorMessage()) {
            status = (String)status + " - " + this.getDiscoveredTuner().getErrorMessage();
        }
        this.getTunerStatusLabel().setText((String)status);
        this.getButtonPanel().updateControls();
        this.getFrequencyPanel().updateControls();
        this.getSampleRateCombo().setEnabled(this.hasTuner() && !((HackRFTuner)this.getTuner()).getTunerController().isLockedSampleRate());
        this.updateSampleRateToolTip();
        this.getTunerInfoButton().setEnabled(this.hasTuner());
        this.getAmplifierToggle().setEnabled(this.hasTuner());
        this.getLnaGainCombo().setEnabled(this.hasTuner());
        this.getVgaGainCombo().setEnabled(this.hasTuner());
        if (this.hasConfiguration()) {
            this.getSampleRateCombo().setSelectedItem((Object)((HackRFTunerConfiguration)this.getConfiguration()).getSampleRate());
            this.getAmplifierToggle().setSelected(((HackRFTunerConfiguration)this.getConfiguration()).getAmplifierEnabled());
            this.getLnaGainCombo().setSelectedItem((Object)((HackRFTunerConfiguration)this.getConfiguration()).getLNAGain());
            this.getVgaGainCombo().setSelectedItem((Object)((HackRFTunerConfiguration)this.getConfiguration()).getVGAGain());
        }
        this.setLoading(false);
    }

    private JComboBox getVgaGainCombo() {
        if (this.mVgaGainCombo == null) {
            this.mVgaGainCombo = new JComboBox<HackRFTunerController.HackRFVGAGain>(HackRFTunerController.HackRFVGAGain.values());
            this.mVgaGainCombo.setToolTipText("<html>VGA Gain.  Adjust to set the baseband gain</html>");
            this.mVgaGainCombo.setEnabled(false);
            this.mVgaGainCombo.addActionListener(arg0 -> {
                if (!this.isLoading()) {
                    try {
                        HackRFTunerController.HackRFVGAGain vgaGain = (HackRFTunerController.HackRFVGAGain)((Object)((Object)this.mVgaGainCombo.getSelectedItem()));
                        if (vgaGain == null) {
                            vgaGain = HackRFTunerController.HackRFVGAGain.GAIN_16;
                        }
                        ((HackRFTuner)this.getTuner()).getController().setVGAGain(vgaGain);
                        this.save();
                    }
                    catch (UsbException e) {
                        JOptionPane.showMessageDialog(this, "HackRF Tuner Controller - couldn't apply the VGA gain setting - " + e.getLocalizedMessage());
                        mLog.error("HackRF Tuner Controller - couldn't apply VGA gain setting", (Throwable)e);
                    }
                }
            });
        }
        return this.mVgaGainCombo;
    }

    private JComboBox getLnaGainCombo() {
        if (this.mLnaGainCombo == null) {
            this.mLnaGainCombo = new JComboBox<HackRFTunerController.HackRFLNAGain>(HackRFTunerController.HackRFLNAGain.values());
            this.mLnaGainCombo.setToolTipText("<html>LNA Gain.  Adjust to set the IF gain</html>");
            this.mLnaGainCombo.setEnabled(false);
            this.mLnaGainCombo.addActionListener(arg0 -> {
                if (!this.isLoading()) {
                    try {
                        HackRFTunerController.HackRFLNAGain lnaGain = (HackRFTunerController.HackRFLNAGain)((Object)((Object)this.mLnaGainCombo.getSelectedItem()));
                        if (lnaGain == null) {
                            lnaGain = HackRFTunerController.HackRFLNAGain.GAIN_16;
                        }
                        ((HackRFTuner)this.getTuner()).getController().setLNAGain(lnaGain);
                        this.save();
                    }
                    catch (UsbException e) {
                        JOptionPane.showMessageDialog(this, "HackRF Tuner Controller - couldn't apply the LNA gain setting - " + e.getLocalizedMessage());
                        mLog.error("HackRF Tuner Controller - couldn't apply LNA gain setting - ", (Throwable)e);
                    }
                }
            });
        }
        return this.mLnaGainCombo;
    }

    private JToggleButton getAmplifierToggle() {
        if (this.mAmplifier == null) {
            this.mAmplifier = new JToggleButton("Amplifier");
            this.mAmplifier.setToolTipText("Enable or disable the gain amplifier");
            this.mAmplifier.setEnabled(false);
            this.mAmplifier.addActionListener(arg0 -> {
                if (!this.isLoading()) {
                    try {
                        ((HackRFTuner)this.getTuner()).getController().setAmplifierEnabled(this.mAmplifier.isSelected());
                        this.save();
                    }
                    catch (UsbException e) {
                        mLog.error("couldn't enable/disable amplifier", (Throwable)e);
                        JOptionPane.showMessageDialog(this, "Couldn't change amplifier setting", "Error changing amplifier setting", 0);
                    }
                }
            });
        }
        return this.mAmplifier;
    }

    private JComboBox getSampleRateCombo() {
        if (this.mSampleRateCombo == null) {
            HackRFTunerController.HackRFSampleRate[] validRates = HackRFTunerController.HackRFSampleRate.VALID_SAMPLE_RATES.toArray(new HackRFTunerController.HackRFSampleRate[0]);
            this.mSampleRateCombo = new JComboBox<HackRFTunerController.HackRFSampleRate>(validRates);
            this.mSampleRateCombo.setEnabled(false);
            this.mSampleRateCombo.addActionListener(e -> {
                if (!this.isLoading()) {
                    HackRFTunerController.HackRFSampleRate sampleRate = (HackRFTunerController.HackRFSampleRate)((Object)((Object)this.getSampleRateCombo().getSelectedItem()));
                    try {
                        ((HackRFTuner)this.getTuner()).getController().setSampleRate(sampleRate);
                        this.save();
                    }
                    catch (SourceException | UsbException e2) {
                        JOptionPane.showMessageDialog(this, "HackRF Tuner Controller - couldn't apply the sample rate setting [" + sampleRate.getLabel() + "] " + e2.getLocalizedMessage());
                        mLog.error("HackRF Tuner Controller - couldn't apply sample rate setting [" + sampleRate.getLabel() + "]", (Object)e);
                    }
                }
            });
        }
        return this.mSampleRateCombo;
    }

    private JButton getTunerInfoButton() {
        if (this.mTunerInfo == null) {
            this.mTunerInfo = new JButton("Tuner Info");
            this.mTunerInfo.setToolTipText("Provides details and information about the tuner");
            this.mTunerInfo.setEnabled(false);
            this.mTunerInfo.addActionListener(e -> JOptionPane.showMessageDialog(this, this.getTunerInfo(), "Tuner Info", 1));
        }
        return this.mTunerInfo;
    }

    private void updateSampleRateToolTip() {
        if (this.hasTuner() && ((HackRFTuner)this.getTuner()).getController().isLockedSampleRate()) {
            this.mSampleRateCombo.setToolTipText("Sample Rate is locked.  Disable decoding channels to unlock.");
        } else {
            this.mSampleRateCombo.setToolTipText("Select a sample rate for the tuner");
        }
    }

    @Override
    public void setTunerLockState(boolean locked) {
        this.getFrequencyPanel().updateControls();
        this.getSampleRateCombo().setEnabled(!locked);
        this.updateSampleRateToolTip();
    }

    private String getTunerInfo() {
        HackRFTunerController.BoardID board = HackRFTunerController.BoardID.INVALID;
        try {
            if (this.hasTuner()) {
                board = ((HackRFTuner)this.getTuner()).getController().getBoardID();
            }
        }
        catch (UsbException e) {
            mLog.error("couldn't read HackRF board identifier", (Throwable)e);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html><h3>HackRF Tuner</h3>");
        sb.append("<b>Board: </b>");
        sb.append(board.getLabel());
        sb.append("<br>");
        HackRFTunerController.Serial serial = null;
        try {
            if (this.hasTuner()) {
                serial = ((HackRFTuner)this.getTuner()).getController().getSerial();
            }
        }
        catch (Exception e) {
            mLog.error("couldn't read HackRF serial number", (Throwable)e);
        }
        if (serial != null) {
            sb.append("<b>Serial: </b>");
            sb.append(serial.getSerialNumber());
            sb.append("<br>");
            sb.append("<b>Part: </b>");
            sb.append(serial.getPartID());
            sb.append("<br>");
        } else {
            sb.append("<b>Serial: Unknown</b><br>");
            sb.append("<b>Part: Unknown</b><br>");
        }
        String firmware = null;
        try {
            if (this.hasTuner()) {
                firmware = ((HackRFTuner)this.getTuner()).getController().getFirmwareVersion();
            }
        }
        catch (Exception e) {
            mLog.error("couldn't read HackRF firmware version", (Throwable)e);
        }
        if (firmware != null) {
            sb.append("<b>Firmware: </b>");
            sb.append(firmware);
            sb.append("<br>");
        } else {
            sb.append("<b>Firmware: Unknown</b><br>");
        }
        return sb.toString();
    }

    @Override
    public void save() {
        if (this.hasConfiguration() && !this.isLoading()) {
            ((HackRFTunerConfiguration)this.getConfiguration()).setFrequency(this.getFrequencyControl().getFrequency());
            double value = ((SpinnerNumberModel)this.getFrequencyCorrectionSpinner().getModel()).getNumber().doubleValue();
            ((HackRFTunerConfiguration)this.getConfiguration()).setFrequencyCorrection(value);
            ((HackRFTunerConfiguration)this.getConfiguration()).setAutoPPMCorrectionEnabled(this.getAutoPPMCheckBox().isSelected());
            ((HackRFTunerConfiguration)this.getConfiguration()).setSampleRate((HackRFTunerController.HackRFSampleRate)((Object)this.getSampleRateCombo().getSelectedItem()));
            ((HackRFTunerConfiguration)this.getConfiguration()).setAmplifierEnabled(this.getAmplifierToggle().isSelected());
            ((HackRFTunerConfiguration)this.getConfiguration()).setLNAGain((HackRFTunerController.HackRFLNAGain)((Object)this.getLnaGainCombo().getSelectedItem()));
            ((HackRFTunerConfiguration)this.getConfiguration()).setVGAGain((HackRFTunerController.HackRFVGAGain)((Object)this.getVgaGainCombo().getSelectedItem()));
            this.saveConfiguration();
        }
    }
}

