/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.frequency;

import io.github.dsheirer.source.ISourceEventProcessor;
import io.github.dsheirer.source.InvalidFrequencyException;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.SourceException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrequencyController {
    private static final Logger mLog = LoggerFactory.getLogger(FrequencyController.class);
    private Tunable mTunable;
    private long mFrequency = 101100000L;
    private long mTunedFrequency = 101100000L;
    private long mMinimumFrequency = 0L;
    private long mMaximumFrequency = 0L;
    private double mFrequencyCorrection = 0.0;
    private double mSampleRate = 0.0;
    private boolean mSampleRateLocked = false;
    private List<ISourceEventProcessor> mProcessors = new ArrayList<ISourceEventProcessor>();
    private ReentrantLock mLock = new ReentrantLock();

    public FrequencyController(Tunable tunable) {
        this.mTunable = tunable;
    }

    public ReentrantLock getFrequencyControllerLock() {
        return this.mLock;
    }

    public void dispose() {
        this.mProcessors.clear();
        this.mTunable = null;
    }

    public boolean isSampleRateLocked() {
        return this.mSampleRateLocked;
    }

    public void setSampleRateLocked(boolean sampleRateLocked) throws SourceException {
        this.mSampleRateLocked = sampleRateLocked;
        if (this.mSampleRateLocked) {
            this.broadcast(SourceEvent.lockedSampleRateState());
        } else {
            this.broadcast(SourceEvent.unlockedSampleRateState());
        }
    }

    public int getBandwidth() {
        return (int)this.mSampleRate;
    }

    public void setSampleRate(int sampleRate) throws SourceException {
        if ((double)sampleRate != this.mSampleRate) {
            if (!this.mSampleRateLocked) {
                this.mSampleRate = sampleRate;
                this.broadcastSampleRateChange();
            } else {
                mLog.warn("Cannot change sample rate while tuner is is LOCKED state.");
            }
        }
    }

    public double getSampleRate() {
        return this.mSampleRate;
    }

    public boolean canTune(long frequency) {
        return this.getMinimumFrequency() <= frequency && frequency <= this.getMaximumFrequency();
    }

    public long getFrequency() {
        return this.mFrequency;
    }

    public void setFrequency(long frequency) throws SourceException {
        this.setFrequency(frequency, true);
    }

    private void setFrequency(long frequency, boolean broadcastChange) throws SourceException {
        long tunedFrequency = this.getTunedFrequency(frequency);
        if (tunedFrequency < this.mMinimumFrequency) {
            throw new InvalidFrequencyException("Requested frequency not valid", frequency, this.mMinimumFrequency);
        }
        if (tunedFrequency > this.mMaximumFrequency) {
            throw new InvalidFrequencyException("Requested frequency not valid", frequency, this.mMaximumFrequency);
        }
        this.mFrequency = frequency;
        this.mTunedFrequency = tunedFrequency;
        if (this.mTunable != null) {
            this.mTunable.setTunedFrequency(this.mTunedFrequency);
        }
        if (broadcastChange) {
            this.broadcastFrequencyChange();
        }
    }

    public long getTunedFrequency() {
        return this.mTunedFrequency;
    }

    public long getMinimumFrequency() {
        return this.mMinimumFrequency;
    }

    public void setMinimumFrequency(long minimum) {
        this.mMaximumFrequency = minimum;
    }

    public long getMaximumFrequency() {
        return this.mMaximumFrequency;
    }

    public void setMaximumFrequency(long maximum) {
        this.mMaximumFrequency = maximum;
    }

    private long getTunedFrequency(long correctedFrequency) {
        return (long)((double)correctedFrequency / (1.0 + this.mFrequencyCorrection / 1000000.0));
    }

    private long getCorrectedFrequency(long tunedFrequency) {
        return (long)((double)tunedFrequency / (1.0 - this.mFrequencyCorrection / 1000000.0));
    }

    public double getFrequencyCorrection() {
        return this.mFrequencyCorrection;
    }

    public void setFrequencyCorrection(double correction) throws SourceException {
        this.mFrequencyCorrection = correction;
        if (this.mFrequency > 0L) {
            this.setFrequency(this.mFrequency, true);
        }
        this.broadcastFrequencyCorrectionChange();
    }

    public void addSourceEventProcessor(ISourceEventProcessor processor) {
        this.mLock.lock();
        try {
            if (!this.mProcessors.contains(processor)) {
                this.mProcessors.add(processor);
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void removeSourceEventProcessor(ISourceEventProcessor processor) {
        this.mLock.lock();
        try {
            this.mProcessors.remove(processor);
        }
        finally {
            this.mLock.unlock();
        }
    }

    protected void broadcastFrequencyChange() throws SourceException {
        this.broadcast(SourceEvent.frequencyChange(null, this.mFrequency));
    }

    protected void broadcastFrequencyCorrectionChange() throws SourceException {
        this.broadcast(SourceEvent.frequencyCorrectionChange((int)this.mFrequencyCorrection));
    }

    protected void broadcastSampleRateChange() throws SourceException {
        this.broadcast(SourceEvent.sampleRateChange(this.mSampleRate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(SourceEvent event) throws SourceException {
        this.mLock.lock();
        try {
            for (ISourceEventProcessor processor : this.mProcessors) {
                processor.process(event);
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    public static interface Tunable {
        public long getTunedFrequency() throws SourceException;

        public void setTunedFrequency(long var1) throws SourceException;

        public double getCurrentSampleRate() throws SourceException;

        public boolean canTune(long var1);
    }
}

