/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.channel.rotation;

import com.google.common.eventbus.Subscribe;
import io.github.dsheirer.channel.state.DecoderStateEvent;
import io.github.dsheirer.channel.state.IDecoderStateEventListener;
import io.github.dsheirer.channel.state.State;
import io.github.dsheirer.module.Module;
import io.github.dsheirer.preference.PreferenceType;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.ISourceEventProvider;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.tuner.channel.rotation.AddChannelRotationActiveStateRequest;
import io.github.dsheirer.source.tuner.channel.rotation.DisableChannelRotationMonitorRequest;
import io.github.dsheirer.util.ThreadPool;
import java.util.Collection;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelRotationMonitor
extends Module
implements ISourceEventProvider,
IDecoderStateEventListener,
Listener<DecoderStateEvent> {
    public static final int CHANNEL_ROTATION_DELAY_MINIMUM = 200;
    public static final int CHANNEL_ROTATION_DELAY_DEFAULT = 500;
    public static final int CHANNEL_ROTATION_DELAY_MAXIMUM = 2000;
    private static final Logger mLog = LoggerFactory.getLogger(ChannelRotationMonitor.class);
    private UserPreferences mUserPreferences;
    private Collection<State> mActiveStates;
    private ScheduledFuture<?> mScheduledFuture;
    private Listener<SourceEvent> mSourceEventListener;
    private long mRotationDelay;
    private long mLastActiveTimestamp = System.currentTimeMillis();
    private boolean mEnabled = true;

    public ChannelRotationMonitor(Collection<State> activeStates, long rotationDelay) {
        this.mActiveStates = activeStates;
        this.mRotationDelay = rotationDelay;
        if (this.mRotationDelay == 0L) {
            this.mRotationDelay = 200L;
        }
    }

    @Override
    public void setSourceEventListener(Listener<SourceEvent> listener) {
        this.mSourceEventListener = listener;
    }

    @Override
    public void removeSourceEventListener() {
        this.mSourceEventListener = null;
    }

    @Override
    public Listener<DecoderStateEvent> getDecoderStateListener() {
        return this;
    }

    @Override
    public void receive(DecoderStateEvent event) {
        switch (event.getEvent()) {
            case NOTIFICATION_CHANNEL_STATE: {
                if (!this.mActiveStates.contains((Object)event.getState())) break;
                this.mLastActiveTimestamp = System.currentTimeMillis();
            }
        }
    }

    @Subscribe
    public void disable(DisableChannelRotationMonitorRequest request) {
        this.mEnabled = false;
        this.stop();
    }

    @Subscribe
    public void addActiveState(AddChannelRotationActiveStateRequest request) {
        if (!this.mActiveStates.contains((Object)request.getState())) {
            this.mActiveStates.add(request.getState());
        }
    }

    private void checkState() {
        if (this.mEnabled && this.mSourceEventListener != null && this.mLastActiveTimestamp + this.mRotationDelay < System.currentTimeMillis()) {
            this.mSourceEventListener.receive(SourceEvent.frequencyRotationRequest());
            this.mLastActiveTimestamp = System.currentTimeMillis();
        }
    }

    @Subscribe
    public void preferenceUpdated(PreferenceType preferenceType) {
        if (preferenceType == PreferenceType.MULTI_FREQUENCY) {
            this.mRotationDelay = this.mUserPreferences.getChannelMultiFrequencyPreference().getRotationDelay();
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public void start() {
        if (this.mScheduledFuture == null) {
            Runnable runnable = () -> {
                try {
                    this.checkState();
                }
                catch (Throwable t) {
                    mLog.warn("Error while checking state", t);
                }
            };
            this.mScheduledFuture = ThreadPool.SCHEDULED.scheduleAtFixedRate(runnable, this.mRotationDelay, this.mRotationDelay / 2L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void stop() {
        if (this.mScheduledFuture != null) {
            this.mScheduledFuture.cancel(true);
            this.mScheduledFuture = null;
        }
    }
}

