/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.channel;

import io.github.dsheirer.buffer.INativeBuffer;
import io.github.dsheirer.dsp.filter.decimate.DecimationFilterFactory;
import io.github.dsheirer.dsp.filter.decimate.IRealDecimationFilter;
import io.github.dsheirer.dsp.filter.design.FilterDesignException;
import io.github.dsheirer.dsp.mixer.ComplexMixer;
import io.github.dsheirer.dsp.mixer.ComplexMixerFactory;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.tuner.channel.ChannelSpecification;
import io.github.dsheirer.source.tuner.channel.TunerChannel;
import io.github.dsheirer.source.tuner.channel.TunerChannelSource;
import io.github.dsheirer.util.Dispatcher;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HalfBandTunerChannelSource<T extends INativeBuffer>
extends TunerChannelSource
implements Listener<T> {
    private static final Logger mLog = LoggerFactory.getLogger(HalfBandTunerChannelSource.class);
    private static final int BUFFER_MAX_CAPACITY = 600;
    private Dispatcher<T> mBufferDispatcher;
    private ComplexMixer mFrequencyCorrectionMixer;
    private IRealDecimationFilter mIDecimationFilter;
    private IRealDecimationFilter mQDecimationFilter;
    private Listener<ComplexSamples> mSamplesListener;
    private double mChannelSampleRate;
    private long mTunerFrequency;

    public HalfBandTunerChannelSource(Listener<SourceEvent> producerSourceEventListener, TunerChannel tunerChannel, double sampleRate, ChannelSpecification channelSpecification) throws FilterDesignException {
        super(producerSourceEventListener, tunerChannel);
        int desiredDecimation = (int)(sampleRate / channelSpecification.getMinimumSampleRate());
        int decimation = DecimationFilterFactory.getDecimationRate(desiredDecimation);
        this.mIDecimationFilter = DecimationFilterFactory.getRealDecimationFilter(decimation);
        this.mQDecimationFilter = DecimationFilterFactory.getRealDecimationFilter(decimation);
        this.mBufferDispatcher = new Dispatcher("sdrtrunk heterodyne channel " + tunerChannel.getFrequency(), 50L, this.getHeartbeatManager());
        this.mBufferDispatcher.setListener(new NativeBufferProcessor());
        this.mChannelSampleRate = sampleRate / (double)decimation;
        this.mTunerFrequency = tunerChannel.getFrequency();
        long frequencyOffset = this.mTunerFrequency - this.getTunerChannel().getFrequency();
        this.mFrequencyCorrectionMixer = ComplexMixerFactory.getMixer(frequencyOffset, sampleRate);
    }

    @Override
    public void start() {
        super.start();
        this.mBufferDispatcher.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.mBufferDispatcher.stop();
    }

    @Override
    public void dispose() {
    }

    @Override
    public void receive(T complexSamples) {
        this.mBufferDispatcher.receive(complexSamples);
    }

    @Override
    public void setFrequency(long frequency) {
        this.mTunerFrequency = frequency;
        this.updateMixerFrequencyOffset();
    }

    private void updateMixerFrequencyOffset() {
        long offset = this.mTunerFrequency - this.getTunerChannel().getFrequency();
        this.mFrequencyCorrectionMixer.setFrequency(offset);
    }

    public long getMixerFrequency() {
        return (long)this.mFrequencyCorrectionMixer.getFrequency();
    }

    @Override
    protected void setSampleRate(double sampleRate) {
    }

    @Override
    public void setListener(Listener<ComplexSamples> listener) {
        this.mSamplesListener = listener;
    }

    @Override
    public double getSampleRate() {
        return this.mChannelSampleRate;
    }

    public class NativeBufferProcessor
    implements Listener<T> {
        @Override
        public void receive(T nativeBuffer) {
            if (HalfBandTunerChannelSource.this.mSamplesListener != null) {
                Iterator<ComplexSamples> iterator = nativeBuffer.iterator();
                while (iterator.hasNext()) {
                    ComplexSamples basebanded = HalfBandTunerChannelSource.this.mFrequencyCorrectionMixer.mix(iterator.next());
                    float[] i = HalfBandTunerChannelSource.this.mIDecimationFilter.decimateReal(basebanded.i());
                    float[] q = HalfBandTunerChannelSource.this.mQDecimationFilter.decimateReal(basebanded.q());
                    try {
                        HalfBandTunerChannelSource.this.mSamplesListener.receive(new ComplexSamples(i, q, basebanded.timestamp()));
                    }
                    catch (Throwable t) {
                        if (HalfBandTunerChannelSource.this.mSamplesListener == null) continue;
                        mLog.error("Error dispatching complex samples to listener [" + String.valueOf(HalfBandTunerChannelSource.this.mSamplesListener) + "]");
                    }
                }
            }
        }
    }
}

