/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.airspy.hf;

import io.github.dsheirer.buffer.INativeBufferFactory;
import io.github.dsheirer.buffer.airspy.hf.AirspyHfNativeBufferFactory;
import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.ITunerErrorListener;
import io.github.dsheirer.source.tuner.TunerType;
import io.github.dsheirer.source.tuner.airspy.hf.AirspyHfSampleRate;
import io.github.dsheirer.source.tuner.airspy.hf.AirspyHfTunerConfiguration;
import io.github.dsheirer.source.tuner.airspy.hf.Attenuation;
import io.github.dsheirer.source.tuner.airspy.hf.BoardId;
import io.github.dsheirer.source.tuner.airspy.hf.Request;
import io.github.dsheirer.source.tuner.configuration.TunerConfiguration;
import io.github.dsheirer.source.tuner.usb.USBTunerController;
import io.github.dsheirer.util.ByteUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.usb4java.DeviceHandle;
import org.usb4java.LibUsb;

public class AirspyHfTunerController
extends USBTunerController {
    private static final Logger mLog = LoggerFactory.getLogger(AirspyHfTunerController.class);
    private static final AirspyHfSampleRate DEFAULT_SAMPLE_RATE = new AirspyHfSampleRate(0, 768000, false);
    private static final long IF_SHIFT_LIF = 0L;
    private static final long IF_SHIFT_ZIF = 5000L;
    private static final long MINIMUM_FREQUENCY_HZ = 500000L;
    private static final long MAXIMUM_FREQUENCY_HZ = 260000000L;
    private static final byte REQUEST_TYPE_IN = -64;
    private static final byte REQUEST_TYPE_OUT = 64;
    private static final int BUFFER_SAMPLE_COUNT = 1024;
    private static final int BUFFER_BYTE_SIZE = 4096;
    private AirspyHfNativeBufferFactory mNativeBufferFactory = new AirspyHfNativeBufferFactory();
    private List<AirspyHfSampleRate> mAvailableSampleRates;
    private AirspyHfSampleRate mCurrentSampleRate = DEFAULT_SAMPLE_RATE;
    private BoardId mBoardId;
    private String mSerialNumber;
    private Attenuation mAttenuation = Attenuation.A0;
    private boolean mAgcEnabled;
    private boolean mLnaEnabled;
    private long mTunedFrequency;
    private static final int CALIBRATION_MAGIC = -1513459280;
    private int mCalibrationRecordMagicNumber;
    private int mCalibrationRecordPPB;
    private int mCalibrationRecordVctcxo;

    public AirspyHfTunerController(int bus, String portAddress, ITunerErrorListener tunerErrorListener) {
        super(bus, portAddress, tunerErrorListener);
        this.setMinimumFrequency(500000L);
        this.setMaximumFrequency(260000000L);
        this.setUsableBandwidthPercentage(0.9);
        this.setMiddleUnusableHalfBandwidth(3000);
    }

    @Override
    public void apply(TunerConfiguration config) throws SourceException {
        super.apply(config);
        if (config instanceof AirspyHfTunerConfiguration) {
            AirspyHfTunerConfiguration airspyConfig = (AirspyHfTunerConfiguration)config;
            int sampleRate = airspyConfig.getSampleRate();
            boolean found = false;
            if (!found) {
                this.setSampleRate(this.getAvailableSampleRates().get(0));
            }
            try {
                this.setAgc(airspyConfig.isAgc());
            }
            catch (IOException ioe) {
                mLog.error("Error setting AGC enabled [" + airspyConfig.isAgc() + "]");
            }
            try {
                this.setLna(airspyConfig.isLna());
            }
            catch (IOException ioe) {
                mLog.error("Error setting LNA enabled [" + airspyConfig.isLna() + "]");
            }
            try {
                this.setAttenuation(airspyConfig.getAttenuation());
            }
            catch (IOException ioe) {
                mLog.error("Error setting attenuation [" + String.valueOf((Object)airspyConfig.getAttenuation()) + "]");
            }
        }
    }

    @Override
    public int getBufferSampleCount() {
        return 1024;
    }

    @Override
    public long getTunedFrequency() throws SourceException {
        return this.mTunedFrequency;
    }

    public String getSerialNumber() {
        return this.mSerialNumber;
    }

    public BoardId getBoardId() {
        return this.mBoardId;
    }

    @Override
    public void setTunedFrequency(long frequency) throws SourceException {
        double if_shift = this.mCurrentSampleRate.isLowIf() ? 5000.0 : 0.0;
        double adjusted_freq_hz = (double)frequency * (1.0E9 + (double)this.mCalibrationRecordPPB) * 1.0E-9;
        int freq_khz = (int)((adjusted_freq_hz + if_shift) * 0.001);
        ByteBuffer buffer = ByteBuffer.allocateDirect(4);
        buffer.putInt(freq_khz).flip();
        try {
            this.writeData(Request.SET_FREQUENCY, buffer);
            this.mTunedFrequency = frequency;
        }
        catch (IOException ioe) {
            mLog.info("Error setting tuned frequency to " + frequency, (Throwable)ioe);
            throw new SourceException("Error setting frequency", ioe);
        }
        try {
            byte[] deltaBytes = this.read(Request.GET_FREQUENCY_DELTA, 0, 4);
            int delta = ByteUtil.toInteger(deltaBytes, 0);
            if (delta != 0) {
                mLog.warn("Frequency delta after setting tuned frequency [" + frequency + "] is: " + delta);
            }
        }
        catch (IOException ioe) {
            mLog.error("Error reading frequency delta from Airspy HF+ tuner", (Throwable)ioe);
        }
    }

    @Override
    public double getCurrentSampleRate() throws SourceException {
        this.loadSampleRates();
        return this.mCurrentSampleRate.getSampleRate();
    }

    public AirspyHfSampleRate getCurrentAirspySampleRate() {
        return this.mCurrentSampleRate;
    }

    public void setSampleRate(AirspyHfSampleRate sampleRate) throws SourceException {
        if (sampleRate != null && this.isSupportedSampleRate(sampleRate.getSampleRate())) {
            this.getNativeBufferFactory().setSamplesPerMillisecond((float)sampleRate.getSampleRate() / 1000.0f);
            LibUsb.clearHalt((DeviceHandle)this.getDeviceHandle(), (byte)-127);
            int status = this.writeIndex(Request.SET_SAMPLE_RATE, sampleRate.getIndex());
            if (status != 0) {
                throw new SourceException("Unable to set Airspy HF sample rate to: " + String.valueOf(sampleRate));
            }
            this.mFrequencyController.setSampleRate(sampleRate.getSampleRate());
            this.getNativeBufferFactory().setSamplesPerMillisecond((float)sampleRate.getSampleRate() / 1000.0f);
            this.mCurrentSampleRate = sampleRate;
            this.setTunedFrequency(this.mTunedFrequency);
        }
    }

    public boolean isSupportedSampleRate(int sampleRate) {
        if (this.mAvailableSampleRates != null && !this.mAvailableSampleRates.isEmpty()) {
            for (AirspyHfSampleRate availableRate : this.mAvailableSampleRates) {
                if (availableRate.getSampleRate() != sampleRate) continue;
                return true;
            }
        }
        return false;
    }

    public List<AirspyHfSampleRate> getAvailableSampleRates() {
        if (this.mAvailableSampleRates == null || this.mAvailableSampleRates.isEmpty()) {
            throw new IllegalStateException("Device must be started before accessing available sample rates");
        }
        return this.mAvailableSampleRates;
    }

    @Override
    public TunerType getTunerType() {
        return TunerType.AIRSPY_HF_PLUS;
    }

    @Override
    protected INativeBufferFactory getNativeBufferFactory() {
        return this.mNativeBufferFactory;
    }

    @Override
    protected int getTransferBufferSize() {
        return 4096;
    }

    @Override
    protected void deviceStart() throws SourceException {
        int status = LibUsb.setInterfaceAltSetting((DeviceHandle)this.getDeviceHandle(), (int)0, (int)1);
        if (status != 0) {
            throw new SourceException("Can't set Airspy HF interface 0 alternate setting 1 - " + LibUsb.errorName((int)status));
        }
        this.loadBoardIdAndSerialNumber();
        this.loadSampleRates();
        try {
            this.loadDeviceConfig();
        }
        catch (IOException ioe) {
            mLog.info("Error getting device configuration and calibration info", (Throwable)ioe);
        }
    }

    @Override
    protected void deviceStop() {
        try {
            this.setReceiverMode(false);
        }
        catch (Exception e) {
            mLog.error("Error setting Airspy HF tuner receiver mode to false for device stop.");
        }
    }

    @Override
    protected void prepareStreaming() {
        try {
            this.setReceiverMode(false);
        }
        catch (SourceException ioe) {
            mLog.error("Error setting Airspy HF tuner receiver mode to false to reset before we start streaming.");
            this.setErrorMessage("Unable to set receiver mode off");
            return;
        }
        LibUsb.clearHalt((DeviceHandle)this.getDeviceHandle(), (byte)-127);
        try {
            this.setReceiverMode(true);
        }
        catch (SourceException ioe) {
            mLog.error("Error setting Airspy HF tuner receiver mode to true to start streaming.");
            this.setErrorMessage("Unable to set receiver mode on");
        }
    }

    @Override
    protected void streamingCleanup() {
        try {
            this.setReceiverMode(false);
        }
        catch (SourceException ioe) {
            mLog.error("Error setting Airspy HF tuner receiver mode to false to stop streaming.");
        }
    }

    private byte[] read(Request request, int count, int bufferLength) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(bufferLength);
        int status = LibUsb.controlTransfer((DeviceHandle)this.getDeviceHandle(), (byte)-64, (byte)request.getRequest(), (short)0, (short)((short)count), (ByteBuffer)buffer, (long)0L);
        if (status < 0) {
            throw new IOException("Unable to complete read request [" + request.name() + "] - libusb status [" + status + "] - " + LibUsb.errorName((int)status));
        }
        byte[] result = new byte[bufferLength];
        buffer.get(result);
        return result;
    }

    private void writeData(Request request, ByteBuffer dataBuffer) throws IOException {
        if (!dataBuffer.isDirect()) {
            throw new IllegalArgumentException("Cannot write - must use a direct/native byte buffer");
        }
        int status = LibUsb.controlTransfer((DeviceHandle)this.getDeviceHandle(), (byte)64, (byte)request.getRequest(), (short)0, (short)0, (ByteBuffer)dataBuffer, (long)0L);
        if (status < 0) {
            throw new IOException("Unable to complete write request [" + request.name() + "] - libusb status [" + status + "] - " + LibUsb.errorName((int)status));
        }
    }

    private int writeValue(Request request, short value) {
        return LibUsb.controlTransfer((DeviceHandle)this.getDeviceHandle(), (byte)64, (byte)request.getRequest(), (short)value, (short)0, (ByteBuffer)ByteBuffer.allocateDirect(0), (long)0L);
    }

    private int writeIndex(Request request, short index) {
        return LibUsb.controlTransfer((DeviceHandle)this.getDeviceHandle(), (byte)64, (byte)request.getRequest(), (short)0, (short)index, (ByteBuffer)ByteBuffer.allocateDirect(0), (long)0L);
    }

    private void setReceiverMode(boolean running) throws SourceException {
        int status = this.writeValue(Request.RECEIVER_MODE, running ? (short)1 : 0);
        if (status != 0) {
            throw new SourceException("Unable to set receiver mode started to " + running + " - status [" + status + "] " + LibUsb.errorName((int)status));
        }
    }

    private void loadBoardIdAndSerialNumber() {
        try {
            byte[] bytes = this.read(Request.GET_SERIAL_NUMBER_BOARD_ID, 0, 20);
            int boardId = ByteUtil.toInteger(bytes, 0);
            this.mBoardId = BoardId.fromValue(boardId);
            int serial1 = ByteUtil.toInteger(bytes, 4);
            int serial2 = ByteUtil.toInteger(bytes, 8);
            int serial3 = ByteUtil.toInteger(bytes, 12);
            int serial4 = ByteUtil.toInteger(bytes, 16);
            StringBuilder sb = new StringBuilder();
            sb.append(Integer.toHexString(serial1));
            sb.append(Integer.toHexString(serial2));
            sb.append(Integer.toHexString(serial3));
            sb.append(Integer.toHexString(serial4));
            this.mSerialNumber = sb.toString().toUpperCase();
        }
        catch (IOException ioe) {
            mLog.error("Error reading board ID and serial number from device", (Throwable)ioe);
            this.mBoardId = BoardId.UNKNOWN;
            this.mSerialNumber = "UNKNOWN";
        }
    }

    private void loadSampleRates() {
        if (this.mAvailableSampleRates == null) {
            this.mAvailableSampleRates = new ArrayList<AirspyHfSampleRate>();
            try {
                byte[] bytes = this.read(Request.GET_SAMPLE_RATES, 0, 4);
                int count = ByteUtil.toInteger(bytes, 0);
                if (count > 0) {
                    bytes = this.read(Request.GET_SAMPLE_RATES, count, count * 4);
                    byte[] architectures = this.read(Request.GET_SAMPLE_RATE_ARCHITECTURES, count, count);
                    for (int x = 0; x < count; ++x) {
                        int sampleRate = ByteUtil.toInteger(bytes, x * 4);
                        boolean lowIf = architectures[x] == 1;
                        this.mAvailableSampleRates.add(new AirspyHfSampleRate(x, sampleRate, lowIf));
                    }
                }
            }
            catch (Exception e) {
                mLog.error("Error reading sample rates from Airspy HF tuner", (Throwable)e);
            }
            if (this.mAvailableSampleRates.isEmpty()) {
                this.mAvailableSampleRates.add(DEFAULT_SAMPLE_RATE);
            }
        }
    }

    public boolean getAgc() {
        return this.mAgcEnabled;
    }

    public void setAgc(boolean enabled) throws IOException {
        int status = this.writeValue(Request.SET_HF_AGC, enabled ? (short)1 : 0);
        if (status != 0) {
            throw new IOException("Unable to set AGC enabled [" + enabled + "] - status code: " + status);
        }
        this.mAgcEnabled = enabled;
    }

    public boolean getLna() {
        return this.mLnaEnabled;
    }

    public void setLna(boolean enabled) throws IOException {
        int status = this.writeValue(Request.SET_HF_LNA, enabled ? (short)1 : 0);
        if (status != 0) {
            throw new IOException("Unable to set LNA enabled [" + enabled + "] - status code: " + status);
        }
        this.mLnaEnabled = enabled;
    }

    public Attenuation getAttenuation() {
        return this.mAttenuation;
    }

    public void setAttenuation(Attenuation attenuation) throws IOException {
        int status = this.writeValue(Request.SET_HF_ATT, attenuation.getValue());
        if (status != 0) {
            throw new IOException("Unable to set attenuation [" + String.valueOf((Object)attenuation) + "] - status code: " + status);
        }
        this.mAttenuation = attenuation;
    }

    private void loadDeviceConfig() throws IOException {
        byte[] bytes = this.read(Request.CONFIG_READ, 0, 256);
        IntBuffer buffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        this.mCalibrationRecordMagicNumber = buffer.get(0);
        this.mCalibrationRecordPPB = buffer.get(1);
        this.mCalibrationRecordVctcxo = buffer.get(2);
    }
}

