/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.airspy;

import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.source.tuner.airspy.AirspyDeviceInformation;
import io.github.dsheirer.source.tuner.airspy.AirspySampleRate;
import io.github.dsheirer.source.tuner.airspy.AirspyTuner;
import io.github.dsheirer.source.tuner.airspy.AirspyTunerConfiguration;
import io.github.dsheirer.source.tuner.airspy.AirspyTunerController;
import io.github.dsheirer.source.tuner.manager.DiscoveredTuner;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import io.github.dsheirer.source.tuner.manager.TunerStatus;
import io.github.dsheirer.source.tuner.ui.TunerEditor;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AirspyTunerEditor
extends TunerEditor<AirspyTuner, AirspyTunerConfiguration> {
    private static final long serialVersionUID = 1L;
    private static final Logger mLog = LoggerFactory.getLogger(AirspyTunerEditor.class);
    private JButton mTunerInfoButton;
    private JComboBox<AirspySampleRate> mSampleRateCombo;
    private JComboBox<AirspyTunerController.GainMode> mGainModeCombo;
    private JSlider mMasterGainSlider;
    private JLabel mMasterGainLabel;
    private JLabel mMasterGainValueLabel;
    private JSlider mIFGainSlider;
    private JLabel mIFGainLabel;
    private JLabel mIFGainValueLabel;
    private JSlider mLNAGainSlider;
    private JLabel mLNAGainValueLabel;
    private JSlider mMixerGainSlider;
    private JLabel mMixerGainValueLabel;
    private JCheckBox mLNAAGCCheckBox;
    private JCheckBox mMixerAGCCheckBox;

    public AirspyTunerEditor(UserPreferences userPreferences, TunerManager tunerManager, DiscoveredTuner discoveredTuner) {
        super(userPreferences, tunerManager, discoveredTuner);
        this.init();
        this.tunerStatusUpdated();
    }

    @Override
    protected void tunerStatusUpdated() {
        this.setLoading(true);
        if (this.hasTuner()) {
            this.getTunerIdLabel().setText(((AirspyTuner)this.getTuner()).getPreferredName());
        } else {
            this.getTunerIdLabel().setText(this.getDiscoveredTuner().getId());
        }
        Object status = this.getDiscoveredTuner().getTunerStatus().toString();
        if (this.getDiscoveredTuner().hasErrorMessage()) {
            status = (String)status + " - " + this.getDiscoveredTuner().getErrorMessage();
        }
        this.getTunerStatusLabel().setText((String)status);
        this.getButtonPanel().updateControls();
        this.getFrequencyPanel().updateControls();
        this.getSampleRateCombo().setEnabled(this.hasTuner() && !((AirspyTuner)this.getTuner()).getTunerController().isLockedSampleRate());
        this.getTunerInfoButton().setEnabled(this.hasTuner());
        this.updateGainComponents(this.hasTuner() && this.hasConfiguration() ? ((AirspyTunerConfiguration)this.getConfiguration()).getGain() : null);
        if (this.hasTuner()) {
            List<AirspySampleRate> rates = ((AirspyTuner)this.getTuner()).getController().getSampleRates();
            this.getSampleRateCombo().setModel(new DefaultComboBoxModel<AirspySampleRate>(rates.toArray(new AirspySampleRate[rates.size()])));
            if (this.hasConfiguration()) {
                AirspySampleRate sampleRate = this.getSampleRate(((AirspyTunerConfiguration)this.getConfiguration()).getSampleRate());
                this.getSampleRateCombo().setSelectedItem(sampleRate);
            }
        } else {
            this.getSampleRateCombo().setModel(new DefaultComboBoxModel());
        }
        this.setLoading(false);
    }

    private void init() {
        this.setLayout((LayoutManager)new MigLayout("fill,wrap 3", "[right][grow,fill][fill]", "[][][][][][][][][][][][][][][][grow]"));
        this.add(new JLabel("Tuner:"));
        this.add(this.getTunerIdLabel());
        this.add(this.getTunerInfoButton());
        this.add(new JLabel("Status:"));
        this.add((Component)this.getTunerStatusLabel(), "wrap");
        this.add((Component)this.getButtonPanel(), "span,align left");
        this.add((Component)new JSeparator(), "span,growx,push");
        this.add(new JLabel("Frequency (MHz):"));
        this.add((Component)this.getFrequencyPanel(), "wrap");
        this.add(new JLabel("Sample Rate:"));
        this.add(this.getSampleRateCombo(), "wrap");
        this.add((Component)new JSeparator(), "span,growx,push");
        this.add((Component)new JLabel("Gain Control"), "wrap");
        this.add(new JLabel("Mode:"));
        this.add(this.getGainModeCombo(), "wrap");
        this.add(this.getMasterGainLabel());
        this.add(this.getMasterGainSlider());
        this.add(this.getMasterGainValueLabel());
        this.add(this.getIFGainLabel());
        this.add(this.getIFGainSlider());
        this.add(this.getIFGainValueLabel());
        this.add(this.getMixerAGCCheckBox());
        this.add(this.getMixerGainSlider());
        this.add(this.getMixerGainValueLabel());
        this.add(this.getLNAAGCCheckBox());
        this.add(this.getLNAGainSlider());
        this.add(this.getLNAGainValueLabel());
    }

    private JCheckBox getLNAAGCCheckBox() {
        if (this.mLNAAGCCheckBox == null) {
            this.mLNAAGCCheckBox = new JCheckBox("AGC LNA:");
            this.mLNAAGCCheckBox.setEnabled(false);
            this.mLNAAGCCheckBox.addActionListener(e -> {
                if (this.hasTuner() && !this.isLoading()) {
                    try {
                        ((AirspyTuner)this.getTuner()).getController().setLNAAGC(this.getLNAAGCCheckBox().isSelected());
                        this.getLNAGainSlider().setEnabled(!this.getLNAAGCCheckBox().isSelected());
                        this.save();
                    }
                    catch (Exception e1) {
                        mLog.error("Error setting LNA AGC Enabled");
                    }
                }
            });
        }
        return this.mLNAAGCCheckBox;
    }

    private JCheckBox getMixerAGCCheckBox() {
        if (this.mMixerAGCCheckBox == null) {
            this.mMixerAGCCheckBox = new JCheckBox("AGC Mixer:");
            this.mMixerAGCCheckBox.setEnabled(false);
            this.mMixerAGCCheckBox.addActionListener(e -> {
                if (this.hasTuner() && !this.isLoading()) {
                    try {
                        ((AirspyTuner)this.getTuner()).getController().setMixerAGC(this.getMixerAGCCheckBox().isSelected());
                        this.getMixerGainSlider().setEnabled(!this.getMixerAGCCheckBox().isSelected());
                        this.save();
                    }
                    catch (Exception e1) {
                        mLog.error("Error setting Mixer AGC Enabled");
                    }
                }
            });
        }
        return this.mMixerAGCCheckBox;
    }

    private JLabel getLNAGainValueLabel() {
        if (this.mLNAGainValueLabel == null) {
            this.mLNAGainValueLabel = new JLabel("0");
            this.mLNAGainValueLabel.setEnabled(false);
        }
        return this.mLNAGainValueLabel;
    }

    private JSlider getLNAGainSlider() {
        if (this.mLNAGainSlider == null) {
            this.mLNAGainSlider = new JSlider(0, 0, 14, 0);
            this.mLNAGainSlider.setEnabled(false);
            this.mLNAGainSlider.setMajorTickSpacing(1);
            this.mLNAGainSlider.setPaintTicks(true);
            this.mLNAGainSlider.addChangeListener(event -> {
                int gain = this.mLNAGainSlider.getValue();
                if (this.hasTuner() && !this.isLoading()) {
                    try {
                        ((AirspyTuner)this.getTuner()).getController().setLNAGain(gain);
                        this.save();
                    }
                    catch (Exception e) {
                        mLog.error("Couldn't set airspy LNA gain to:" + gain, (Throwable)e);
                        JOptionPane.showMessageDialog(this.mLNAGainSlider, "Couldn't set LNA gain value to " + gain);
                    }
                }
                this.getLNAGainValueLabel().setText(String.valueOf(gain));
            });
        }
        return this.mLNAGainSlider;
    }

    private JLabel getMixerGainValueLabel() {
        if (this.mMixerGainValueLabel == null) {
            this.mMixerGainValueLabel = new JLabel("0");
            this.mMixerGainValueLabel.setEnabled(false);
        }
        return this.mMixerGainValueLabel;
    }

    private JSlider getMixerGainSlider() {
        if (this.mMixerGainSlider == null) {
            this.mMixerGainSlider = new JSlider(0, 0, 15, 0);
            this.mMixerGainSlider.setEnabled(false);
            this.mMixerGainSlider.setMajorTickSpacing(1);
            this.mMixerGainSlider.setPaintTicks(true);
            this.mMixerGainSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent event) {
                    int gain = AirspyTunerEditor.this.mMixerGainSlider.getValue();
                    if (AirspyTunerEditor.this.hasTuner() && !AirspyTunerEditor.this.isLoading()) {
                        try {
                            ((AirspyTuner)AirspyTunerEditor.this.getTuner()).getController().setMixerGain(gain);
                            AirspyTunerEditor.this.save();
                        }
                        catch (Exception e) {
                            mLog.error("Couldn't set airspy Mixer gain to:" + gain, (Throwable)e);
                            JOptionPane.showMessageDialog(AirspyTunerEditor.this.mMixerGainSlider, "Couldn't set Mixer gain value to " + gain);
                        }
                    }
                    AirspyTunerEditor.this.getMixerGainValueLabel().setText(String.valueOf(gain));
                }
            });
        }
        return this.mMixerGainSlider;
    }

    private JLabel getIFGainLabel() {
        if (this.mIFGainLabel == null) {
            this.mIFGainLabel = new JLabel("IF:");
        }
        return this.mIFGainLabel;
    }

    private JLabel getIFGainValueLabel() {
        if (this.mIFGainValueLabel == null) {
            this.mIFGainValueLabel = new JLabel("0");
            this.mIFGainValueLabel.setEnabled(false);
        }
        return this.mIFGainValueLabel;
    }

    private JSlider getIFGainSlider() {
        if (this.mIFGainSlider == null) {
            this.mIFGainSlider = new JSlider(0, 0, 15, 0);
            this.mIFGainSlider.setEnabled(false);
            this.mIFGainSlider.setMajorTickSpacing(1);
            this.mIFGainSlider.setPaintTicks(true);
            this.mIFGainSlider.addChangeListener(event -> {
                int gain = this.mIFGainSlider.getValue();
                if (this.hasTuner() && !this.isLoading()) {
                    try {
                        ((AirspyTuner)this.getTuner()).getController().setIFGain(gain);
                        this.save();
                    }
                    catch (Exception e) {
                        mLog.error("Couldn't set airspy IF gain to:" + gain, (Throwable)e);
                        JOptionPane.showMessageDialog(this.mIFGainSlider, "Couldn't set IF gain value to " + gain);
                    }
                }
                this.getIFGainValueLabel().setText(String.valueOf(gain));
            });
        }
        return this.mIFGainSlider;
    }

    private JLabel getMasterGainLabel() {
        if (this.mMasterGainLabel == null) {
            this.mMasterGainLabel = new JLabel("Master:");
        }
        return this.mMasterGainLabel;
    }

    private JLabel getMasterGainValueLabel() {
        if (this.mMasterGainValueLabel == null) {
            this.mMasterGainValueLabel = new JLabel("0");
            this.mMasterGainValueLabel.setEnabled(false);
        }
        return this.mMasterGainValueLabel;
    }

    private JSlider getMasterGainSlider() {
        if (this.mMasterGainSlider == null) {
            this.mMasterGainSlider = new JSlider(0, 1, 22, 1);
            this.mMasterGainSlider.setEnabled(false);
            this.mMasterGainSlider.setMajorTickSpacing(1);
            this.mMasterGainSlider.setPaintTicks(true);
            this.mMasterGainSlider.addChangeListener(event -> {
                AirspyTunerController.GainMode mode = (AirspyTunerController.GainMode)((Object)((Object)this.mGainModeCombo.getSelectedItem()));
                int value = this.mMasterGainSlider.getValue();
                AirspyTunerController.Gain gain = AirspyTunerController.Gain.getGain(mode, value);
                if (this.hasTuner() && !this.isLoading()) {
                    try {
                        ((AirspyTuner)this.getTuner()).getController().setGain(gain);
                        this.save();
                    }
                    catch (Exception e) {
                        mLog.error("Couldn't set airspy gain to:" + gain.name(), (Throwable)e);
                        JOptionPane.showMessageDialog(this.mMasterGainSlider, "Couldn't set gain value to " + gain.getValue());
                    }
                }
                this.getMasterGainValueLabel().setText(String.valueOf(value));
            });
        }
        return this.mMasterGainSlider;
    }

    private JComboBox<AirspyTunerController.GainMode> getGainModeCombo() {
        if (this.mGainModeCombo == null) {
            this.mGainModeCombo = new JComboBox<AirspyTunerController.GainMode>(AirspyTunerController.GainMode.values());
            this.mGainModeCombo.setEnabled(false);
            this.mGainModeCombo.addActionListener(e -> {
                if (this.hasTuner() && !this.isLoading()) {
                    AirspyTunerController.GainMode mode = (AirspyTunerController.GainMode)((Object)((Object)this.mGainModeCombo.getSelectedItem()));
                    int value = this.getMasterGainSlider().getValue();
                    AirspyTunerController.Gain gain = AirspyTunerController.Gain.getGain(mode, value);
                    this.updateGainComponents(gain);
                    this.save();
                }
            });
        }
        return this.mGainModeCombo;
    }

    private JComboBox<AirspySampleRate> getSampleRateCombo() {
        if (this.mSampleRateCombo == null) {
            this.mSampleRateCombo = new JComboBox();
            this.mSampleRateCombo.setEnabled(false);
            this.mSampleRateCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AirspyTunerEditor.this.hasTuner() && !AirspyTunerEditor.this.isLoading()) {
                        AirspySampleRate rate = (AirspySampleRate)AirspyTunerEditor.this.mSampleRateCombo.getSelectedItem();
                        try {
                            ((AirspyTuner)AirspyTunerEditor.this.getTuner()).getController().setSampleRate(rate);
                            AirspyTunerEditor.this.save();
                        }
                        catch (Exception e1) {
                            JOptionPane.showMessageDialog(AirspyTunerEditor.this, "Couldn't set sample rate to " + rate.getLabel());
                            mLog.error("Error setting airspy sample rate", (Throwable)e1);
                        }
                    }
                }
            });
        }
        return this.mSampleRateCombo;
    }

    private JButton getTunerInfoButton() {
        if (this.mTunerInfoButton == null) {
            this.mTunerInfoButton = new JButton("Info");
            this.mTunerInfoButton.setEnabled(false);
            this.mTunerInfoButton.addActionListener(e -> JOptionPane.showMessageDialog(this, this.getTunerInfo(), "Tuner Info", 1));
        }
        return this.mTunerInfoButton;
    }

    private void updateGainComponents(AirspyTunerController.Gain gain) {
        if (this.hasTuner() && gain != null) {
            boolean isCustom = gain.equals((Object)AirspyTunerController.Gain.CUSTOM);
            this.getGainModeCombo().setEnabled(true);
            this.getGainModeCombo().setSelectedItem((Object)gain.getGainMode());
            this.getMasterGainLabel().setEnabled(!isCustom);
            this.getMasterGainSlider().setEnabled(!isCustom);
            this.getMasterGainSlider().setValue(gain.getValue());
            this.getMasterGainValueLabel().setEnabled(!isCustom);
            this.getIFGainLabel().setEnabled(isCustom);
            this.getIFGainSlider().setEnabled(isCustom);
            this.getIFGainValueLabel().setEnabled(isCustom);
            this.getLNAAGCCheckBox().setEnabled(isCustom);
            this.getLNAGainSlider().setEnabled(isCustom && !((AirspyTunerConfiguration)this.getConfiguration()).isLNAAGC());
            this.getLNAGainValueLabel().setEnabled(isCustom);
            this.getMixerAGCCheckBox().setEnabled(isCustom);
            this.getMixerGainSlider().setEnabled(isCustom && !((AirspyTunerConfiguration)this.getConfiguration()).isMixerAGC());
            this.getMixerGainValueLabel().setEnabled(isCustom);
            if (isCustom) {
                this.getIFGainSlider().setValue(((AirspyTunerConfiguration)this.getConfiguration()).getIFGain());
                this.getLNAGainSlider().setValue(((AirspyTunerConfiguration)this.getConfiguration()).getLNAGain());
                this.getMixerGainSlider().setValue(((AirspyTunerConfiguration)this.getConfiguration()).getMixerGain());
                this.getMixerAGCCheckBox().setSelected(((AirspyTunerConfiguration)this.getConfiguration()).isMixerAGC());
                this.getLNAAGCCheckBox().setSelected(((AirspyTunerConfiguration)this.getConfiguration()).isLNAAGC());
            } else {
                this.getIFGainSlider().setValue(0);
                this.getLNAGainSlider().setValue(0);
                this.getMixerGainSlider().setValue(0);
                this.getMixerAGCCheckBox().setSelected(false);
                this.getLNAAGCCheckBox().setSelected(false);
            }
        } else {
            this.getGainModeCombo().setEnabled(false);
            this.getMasterGainLabel().setEnabled(false);
            this.getMasterGainSlider().setEnabled(false);
            this.getMasterGainSlider().setValue(0);
            this.getMasterGainValueLabel().setEnabled(false);
            this.getIFGainLabel().setEnabled(false);
            this.getIFGainSlider().setEnabled(false);
            this.getIFGainSlider().setValue(0);
            this.getIFGainValueLabel().setEnabled(false);
            this.getLNAAGCCheckBox().setEnabled(false);
            this.getLNAAGCCheckBox().setSelected(false);
            this.getLNAGainSlider().setEnabled(false);
            this.getLNAGainSlider().setValue(0);
            this.getLNAGainValueLabel().setEnabled(false);
            this.getMixerAGCCheckBox().setEnabled(false);
            this.getMixerAGCCheckBox().setSelected(false);
            this.getMixerGainSlider().setEnabled(false);
            this.getMixerGainSlider().setValue(0);
            this.getMixerGainValueLabel().setEnabled(false);
        }
    }

    @Override
    public void save() {
        if (this.hasConfiguration() && !this.isLoading()) {
            ((AirspyTunerConfiguration)this.getConfiguration()).setFrequency(this.getFrequencyControl().getFrequency());
            double value = ((SpinnerNumberModel)this.getFrequencyCorrectionSpinner().getModel()).getNumber().doubleValue();
            ((AirspyTunerConfiguration)this.getConfiguration()).setFrequencyCorrection(value);
            ((AirspyTunerConfiguration)this.getConfiguration()).setAutoPPMCorrectionEnabled(this.getAutoPPMCheckBox().isSelected());
            ((AirspyTunerConfiguration)this.getConfiguration()).setSampleRate(((AirspySampleRate)this.getSampleRateCombo().getSelectedItem()).getRate());
            AirspyTunerController.Gain gain = AirspyTunerController.Gain.getGain((AirspyTunerController.GainMode)((Object)this.mGainModeCombo.getSelectedItem()), this.getMasterGainSlider().getValue());
            ((AirspyTunerConfiguration)this.getConfiguration()).setGain(gain);
            ((AirspyTunerConfiguration)this.getConfiguration()).setIFGain(this.getIFGainSlider().getValue());
            ((AirspyTunerConfiguration)this.getConfiguration()).setMixerGain(this.getMixerGainSlider().getValue());
            ((AirspyTunerConfiguration)this.getConfiguration()).setLNAGain(this.getLNAGainSlider().getValue());
            ((AirspyTunerConfiguration)this.getConfiguration()).setMixerAGC(this.getMixerAGCCheckBox().isSelected());
            ((AirspyTunerConfiguration)this.getConfiguration()).setLNAAGC(this.getLNAAGCCheckBox().isSelected());
            this.saveConfiguration();
        }
    }

    private AirspySampleRate getSampleRate(int value) {
        if (this.hasTuner()) {
            List<AirspySampleRate> rates = ((AirspyTuner)this.getTuner()).getController().getSampleRates();
            for (AirspySampleRate rate : rates) {
                if (rate.getRate() != value) continue;
                return rate;
            }
            if (rates.size() > 0) {
                return rates.get(0);
            }
        }
        return null;
    }

    private void updateSampleRateToolTip() {
        if (this.hasTuner() && ((AirspyTuner)this.getTuner()).getController().isLockedSampleRate()) {
            this.getSampleRateCombo().setToolTipText("Sample Rate is locked.  Disable decoding channels to unlock.");
        } else {
            this.getSampleRateCombo().setToolTipText("Select a sample rate for the tuner");
        }
    }

    @Override
    public void setTunerLockState(boolean locked) {
        this.getFrequencyPanel().updateControls();
        this.getSampleRateCombo().setEnabled(!locked);
        this.updateSampleRateToolTip();
    }

    private String getTunerInfo() {
        if (this.getDiscoveredTuner().getTunerStatus() == TunerStatus.ERROR) {
            return this.getDiscoveredTuner().getErrorMessage();
        }
        if (this.hasTuner()) {
            StringBuilder sb = new StringBuilder();
            AirspyDeviceInformation info = ((AirspyTuner)this.getTuner()).getController().getDeviceInfo();
            sb.append("<html><h3>Airspy Tuner</h3>");
            sb.append("<b>Serial: </b>");
            sb.append(info.getSerialNumber());
            sb.append("<br>");
            sb.append("<b>Firmware: </b>");
            String[] firmware = info.getVersion().split(" ");
            sb.append(firmware.length > 1 ? firmware[0] : info.getVersion());
            sb.append("<br>");
            sb.append("<b>Part: </b>");
            sb.append(info.getPartNumber());
            sb.append("<br>");
            sb.append("<b>Board ID: </b>");
            sb.append(info.getBoardID().getLabel());
            sb.append("<br>");
            return sb.toString();
        }
        return null;
    }
}

