/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.airspy;

import io.github.dsheirer.buffer.INativeBufferFactory;
import io.github.dsheirer.buffer.airspy.AirspyNativeBufferFactory;
import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.ITunerErrorListener;
import io.github.dsheirer.source.tuner.TunerType;
import io.github.dsheirer.source.tuner.airspy.AirspyDeviceInformation;
import io.github.dsheirer.source.tuner.airspy.AirspySampleRate;
import io.github.dsheirer.source.tuner.airspy.AirspyTunerConfiguration;
import io.github.dsheirer.source.tuner.configuration.TunerConfiguration;
import io.github.dsheirer.source.tuner.usb.USBTunerController;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.usb.UsbException;
import org.apache.commons.io.EndianUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.usb4java.DeviceHandle;
import org.usb4java.LibUsb;
import org.usb4java.LibUsbException;

public class AirspyTunerController
extends USBTunerController {
    private static final Logger mLog = LoggerFactory.getLogger(AirspyTunerController.class);
    public static final Gain LINEARITY_GAIN_DEFAULT = Gain.LINEARITY_14;
    public static final Gain SENSITIVITY_GAIN_DEFAULT = Gain.SENSITIVITY_10;
    public static final int GAIN_MIN = 1;
    public static final int GAIN_MAX = 22;
    public static final int LNA_GAIN_MIN = 0;
    public static final int LNA_GAIN_MAX = 14;
    public static final int LNA_GAIN_DEFAULT = 7;
    public static final int MIXER_GAIN_MIN = 0;
    public static final int MIXER_GAIN_MAX = 15;
    public static final int MIXER_GAIN_DEFAULT = 9;
    public static final int IF_GAIN_MIN = 0;
    public static final int IF_GAIN_MAX = 15;
    public static final int IF_GAIN_DEFAULT = 9;
    public static final long FREQUENCY_MIN = 24000000L;
    public static final long FREQUENCY_MAX = 1800000000L;
    public static final long FREQUENCY_DEFAULT = 101100000L;
    public static final double USABLE_BANDWIDTH_PERCENT = 0.9;
    private static final long USB_TIMEOUT_MS = 2000L;
    private static final int USB_TRANSFER_BUFFER_SIZE = 262144;
    private static final byte USB_REQUEST_IN = -64;
    private static final byte USB_REQUEST_OUT = 64;
    public static final DecimalFormat MHZ_FORMATTER = new DecimalFormat("#.00 MHz");
    public static final AirspySampleRate DEFAULT_SAMPLE_RATE = new AirspySampleRate(0, 10000000, "10.00 MHz");
    private AirspyNativeBufferFactory mNativeBufferFactory = new AirspyNativeBufferFactory();
    private AirspyDeviceInformation mDeviceInfo;
    private List<AirspySampleRate> mSampleRates = new ArrayList<AirspySampleRate>();
    private int mSampleRate = 0;

    public AirspyTunerController(int bus, String portAddress, ITunerErrorListener tunerErrorListener) {
        super(bus, portAddress, 24000000L, 1800000000L, 0, 0.9, tunerErrorListener);
    }

    @Override
    public TunerType getTunerType() {
        return TunerType.AIRSPY_R820T;
    }

    @Override
    protected INativeBufferFactory getNativeBufferFactory() {
        return this.mNativeBufferFactory;
    }

    @Override
    protected int getTransferBufferSize() {
        return 262144;
    }

    @Override
    public int getBufferSampleCount() {
        return 65536;
    }

    @Override
    protected void deviceStart() throws SourceException {
        try {
            this.setSamplePacking(false);
        }
        catch (UnsupportedOperationException | UsbException | LibUsbException e) {
            mLog.info("Sample packing is not supported by airspy firmware");
        }
        try {
            this.setReceiverMode(true);
        }
        catch (Exception e) {
            mLog.error("Couldn't enable airspy receiver mode", (Throwable)e);
        }
        this.setFrequency(101100000L);
        try {
            this.determineAvailableSampleRates();
        }
        catch (UsbException | LibUsbException e) {
            mLog.error("Error identifying available samples rates", e);
        }
        try {
            this.setSampleRate(this.mSampleRates.get(0));
        }
        catch (IllegalArgumentException | UsbException | LibUsbException e) {
            mLog.error("Setting sample rate is not supported by firmware", e);
        }
    }

    @Override
    protected void deviceStop() {
        try {
            this.setReceiverMode(false);
        }
        catch (Exception e) {
            mLog.error("Couldn't enable airspy receiver mode", (Throwable)e);
        }
    }

    @Override
    public void apply(TunerConfiguration tunerConfiguration) throws SourceException {
        super.apply(tunerConfiguration);
        if (tunerConfiguration instanceof AirspyTunerConfiguration) {
            AirspyTunerConfiguration config = (AirspyTunerConfiguration)tunerConfiguration;
            int sampleRate = config.getSampleRate();
            AirspySampleRate rate = this.getSampleRate(sampleRate);
            if (rate == null) {
                rate = !this.mSampleRates.isEmpty() ? this.mSampleRates.get(0) : DEFAULT_SAMPLE_RATE;
            }
            try {
                this.setSampleRate(rate);
            }
            catch (UsbException e) {
                throw new SourceException("Couldn't set sample rate [" + rate.toString() + "]", e);
            }
            try {
                this.setFrequency(config.getFrequency());
                this.setFrequencyCorrection(config.getFrequencyCorrection());
                this.getFrequencyErrorCorrectionManager().setEnabled(config.getAutoPPMCorrectionEnabled());
                this.setIFGain(config.getIFGain());
                this.setMixerGain(config.getMixerGain());
                this.setLNAGain(config.getLNAGain());
                this.setMixerAGC(config.isMixerAGC());
                this.setLNAAGC(config.isLNAAGC());
                this.setGain(config.getGain());
            }
            catch (Exception e) {
                throw new SourceException("Couldn't apply gain settings from airspy config", e);
            }
        }
        throw new IllegalArgumentException("Invalid tuner config:" + String.valueOf(tunerConfiguration.getClass()));
    }

    @Override
    public long getTunedFrequency() throws SourceException {
        return this.mFrequencyController.getTunedFrequency();
    }

    @Override
    public synchronized void setTunedFrequency(long frequency) throws SourceException {
        if (24000000L <= frequency && frequency <= 1800000000L) {
            ByteBuffer buffer = ByteBuffer.allocateDirect(4);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt((int)frequency);
            buffer.rewind();
            try {
                this.write(Command.SET_FREQUENCY, 0, 0, buffer);
            }
            catch (UsbException e) {
                mLog.error("error setting frequency [" + frequency + "]", (Throwable)e);
                throw new SourceException("error setting frequency [" + frequency + "]", e);
            }
        } else {
            throw new SourceException("Frequency [" + frequency + "] outside of tunable range 24000000-1800000000");
        }
    }

    @Override
    public double getCurrentSampleRate() {
        return this.mSampleRate;
    }

    public void setSampleRate(AirspySampleRate rate) throws LibUsbException, UsbException, SourceException {
        this.getNativeBufferFactory().setSamplesPerMillisecond((float)rate.getRate() / 1000.0f);
        if (rate.getRate() != this.mSampleRate) {
            int result = this.readByte(Command.SET_SAMPLE_RATE, 0, rate.getIndex(), true);
            if (result != 1) {
                throw new UsbException("Error setting sample rate [" + String.valueOf(rate) + "] rate - return value [" + result + "]");
            }
            this.mSampleRate = rate.getRate();
            this.mFrequencyController.setSampleRate(this.mSampleRate);
            switch (this.mSampleRate) {
                default: {
                    super.setUsableBandwidthPercentage(0.9);
                    break;
                }
                case 6000000: {
                    super.setUsableBandwidthPercentage(0.83);
                    break;
                }
                case 3000000: {
                    super.setUsableBandwidthPercentage(0.66);
                    break;
                }
                case 2500000: {
                    super.setUsableBandwidthPercentage(0.6);
                }
            }
        }
    }

    public List<AirspySampleRate> getSampleRates() {
        return this.mSampleRates;
    }

    public AirspySampleRate getAirspySampleRate() {
        return this.getSampleRate(this.mSampleRate);
    }

    public AirspySampleRate getSampleRate(int rate) {
        for (AirspySampleRate sampleRate : this.mSampleRates) {
            if (sampleRate.getRate() != rate) continue;
            return sampleRate;
        }
        return null;
    }

    public void setSamplePacking(boolean enabled) throws LibUsbException, UsbException {
        int result = this.readByte(Command.SET_PACKING, 0, enabled ? 1 : 0, true);
        if (result != 1) {
            throw new UsbException("Couldnt set sample packing enabled: " + enabled);
        }
        this.mNativeBufferFactory.setSamplePacking(enabled);
    }

    public synchronized void setMixerAGC(boolean enabled) throws LibUsbException, UsbException {
        int result = this.readByte(Command.SET_MIXER_AGC, 0, enabled ? 1 : 0, true);
        if (result != 0) {
            throw new UsbException("Couldnt set mixer AGC enabled: " + enabled);
        }
    }

    public synchronized void setLNAAGC(boolean enabled) throws LibUsbException, UsbException {
        int result = this.readByte(Command.SET_LNA_AGC, 0, enabled ? 1 : 0, true);
        if (result != 0) {
            throw new UsbException("Couldn't set LNA AGC enabled: " + enabled);
        }
    }

    public void setGain(Gain gain) throws UsbException {
        if (gain != Gain.CUSTOM) {
            this.setMixerAGC(false);
            this.setLNAAGC(false);
            this.setLNAGain(gain.getLNA());
            this.setMixerGain(gain.getMixer());
            this.setIFGain(gain.getIF());
        }
    }

    public synchronized void setLNAGain(int gain) throws LibUsbException, UsbException, IllegalArgumentException {
        if (0 <= gain && gain <= 14) {
            int result = this.readByte(Command.SET_LNA_GAIN, 0, gain, true);
            if (result != 0) {
                throw new UsbException("Couldnt set LNA gain to: " + gain);
            }
        } else {
            throw new IllegalArgumentException("LNA gain value [" + gain + "] is outside value range: 0-14");
        }
    }

    public void setMixerGain(int gain) throws LibUsbException, UsbException, IllegalArgumentException {
        if (0 <= gain && gain <= 15) {
            int result = this.readByte(Command.SET_MIXER_GAIN, 0, gain, true);
            if (result != 0) {
                throw new UsbException("Couldnt set mixer gain to: " + gain);
            }
        } else {
            throw new IllegalArgumentException("Mixer gain value [" + gain + "] is outside value range: 0-15");
        }
    }

    public void setIFGain(int gain) throws LibUsbException, UsbException, IllegalArgumentException {
        if (0 <= gain && gain <= 15) {
            int result = this.readByte(Command.SET_VGA_GAIN, 0, gain, true);
            if (result != 0) {
                throw new UsbException("Couldnt set VGA gain to: " + gain);
            }
        } else {
            throw new IllegalArgumentException("VGA gain value [" + gain + "] is outside value range: 0-15");
        }
    }

    public void setReceiverMode(boolean enabled) throws LibUsbException, UsbException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(0);
        this.write(Command.RECEIVER_MODE, enabled ? 1 : 0, 0, buffer);
    }

    private void determineAvailableSampleRates() throws LibUsbException, UsbException {
        this.mSampleRates.clear();
        try {
            byte[] rawCount = this.readArray(Command.GET_SAMPLE_RATES, 0, 0, 4);
            if (rawCount != null) {
                int count = EndianUtils.readSwappedInteger((byte[])rawCount, (int)0);
                byte[] rawRates = this.readArray(Command.GET_SAMPLE_RATES, 0, count, count * 4);
                for (int x = 0; x < count; ++x) {
                    int rate = EndianUtils.readSwappedInteger((byte[])rawRates, (int)(x * 4));
                    this.mSampleRates.add(new AirspySampleRate(x, rate, AirspyTunerController.formatSampleRate(rate)));
                }
            }
        }
        catch (LibUsbException libUsbException) {
            // empty catch block
        }
        if (this.mSampleRates.isEmpty()) {
            this.mSampleRates.add(DEFAULT_SAMPLE_RATE);
        }
    }

    private static String formatSampleRate(int rate) {
        return MHZ_FORMATTER.format((double)rate / 1000000.0);
    }

    public AirspyDeviceInformation getDeviceInfo() {
        if (this.mDeviceInfo == null) {
            this.readDeviceInfo();
        }
        return this.mDeviceInfo;
    }

    private void readDeviceInfo() {
        if (this.mDeviceInfo == null) {
            this.mDeviceInfo = new AirspyDeviceInformation();
        }
        try {
            int boardID = this.readByte(Command.BOARD_ID_READ, 0, 0, true);
            this.mDeviceInfo.setBoardID(boardID);
        }
        catch (UsbException | LibUsbException e) {
            mLog.error("Error reading airspy board ID", e);
        }
        try {
            byte[] version = this.readArray(Command.VERSION_STRING_READ, 0, 0, 127);
            this.mDeviceInfo.setVersion(version);
        }
        catch (UsbException | LibUsbException e) {
            mLog.error("Error reading airspy version string", e);
        }
        try {
            byte[] serial = this.readArray(Command.BOARD_PART_ID_SERIAL_NUMBER_READ, 0, 0, 24);
            this.mDeviceInfo.setPartAndSerialNumber(serial);
        }
        catch (UsbException | LibUsbException e) {
            mLog.error("Error reading airspy version string", e);
        }
    }

    private int readByte(Command command, int value, int index, boolean signed) throws LibUsbException, UsbException {
        if (this.isRunning()) {
            ByteBuffer buffer = ByteBuffer.allocateDirect(1);
            int transferred = LibUsb.controlTransfer((DeviceHandle)this.getDeviceHandle(), (byte)-64, (byte)command.getValue(), (short)((short)value), (short)((short)index), (ByteBuffer)buffer, (long)2000L);
            if (transferred < 0) {
                throw new LibUsbException("read error", transferred);
            }
            byte result = buffer.get(0);
            if (signed) {
                return result & 0xFF;
            }
            return result;
        }
        return 0;
    }

    private byte[] readArray(Command command, int value, int index, int length) throws LibUsbException, UsbException {
        if (this.isRunning()) {
            ByteBuffer buffer = ByteBuffer.allocateDirect(length);
            int transferred = LibUsb.controlTransfer((DeviceHandle)this.getDeviceHandle(), (byte)-64, (byte)command.getValue(), (short)((short)value), (short)((short)index), (ByteBuffer)buffer, (long)2000L);
            if (transferred < 0) {
                throw new LibUsbException("read error", transferred);
            }
            byte[] results = new byte[transferred];
            buffer.get(results);
            return results;
        }
        return new byte[0];
    }

    public void write(Command command, int value, int index, ByteBuffer buffer) throws UsbException {
        if (this.isRunning()) {
            int transferred = LibUsb.controlTransfer((DeviceHandle)this.getDeviceHandle(), (byte)64, (byte)command.getValue(), (short)((short)value), (short)((short)index), (ByteBuffer)buffer, (long)2000L);
            if (transferred < 0) {
                throw new LibUsbException("error writing byte buffer", transferred);
            }
            if (transferred != buffer.capacity()) {
                throw new LibUsbException("transferred bytes [" + transferred + "] is not what was expected [" + buffer.capacity() + "]", transferred);
            }
        }
    }

    public static final class Gain
    extends Enum<Gain> {
        public static final /* enum */ Gain LINEARITY_1 = new Gain(1, 4, 0, 0);
        public static final /* enum */ Gain LINEARITY_2 = new Gain(2, 5, 0, 0);
        public static final /* enum */ Gain LINEARITY_3 = new Gain(3, 6, 1, 0);
        public static final /* enum */ Gain LINEARITY_4 = new Gain(4, 7, 1, 0);
        public static final /* enum */ Gain LINEARITY_5 = new Gain(5, 8, 1, 0);
        public static final /* enum */ Gain LINEARITY_6 = new Gain(6, 9, 1, 0);
        public static final /* enum */ Gain LINEARITY_7 = new Gain(7, 10, 2, 0);
        public static final /* enum */ Gain LINEARITY_8 = new Gain(8, 10, 2, 1);
        public static final /* enum */ Gain LINEARITY_9 = new Gain(9, 10, 0, 3);
        public static final /* enum */ Gain LINEARITY_10 = new Gain(10, 10, 0, 5);
        public static final /* enum */ Gain LINEARITY_11 = new Gain(11, 10, 1, 6);
        public static final /* enum */ Gain LINEARITY_12 = new Gain(12, 10, 0, 8);
        public static final /* enum */ Gain LINEARITY_13 = new Gain(13, 10, 0, 9);
        public static final /* enum */ Gain LINEARITY_14 = new Gain(14, 10, 5, 8);
        public static final /* enum */ Gain LINEARITY_15 = new Gain(15, 10, 6, 9);
        public static final /* enum */ Gain LINEARITY_16 = new Gain(16, 11, 6, 9);
        public static final /* enum */ Gain LINEARITY_17 = new Gain(17, 11, 7, 10);
        public static final /* enum */ Gain LINEARITY_18 = new Gain(18, 11, 8, 12);
        public static final /* enum */ Gain LINEARITY_19 = new Gain(19, 11, 9, 13);
        public static final /* enum */ Gain LINEARITY_20 = new Gain(20, 11, 11, 14);
        public static final /* enum */ Gain LINEARITY_21 = new Gain(21, 12, 12, 14);
        public static final /* enum */ Gain LINEARITY_22 = new Gain(22, 13, 12, 14);
        public static final /* enum */ Gain SENSITIVITY_1 = new Gain(1, 4, 0, 0);
        public static final /* enum */ Gain SENSITIVITY_2 = new Gain(2, 4, 0, 1);
        public static final /* enum */ Gain SENSITIVITY_3 = new Gain(3, 4, 0, 2);
        public static final /* enum */ Gain SENSITIVITY_4 = new Gain(4, 4, 0, 3);
        public static final /* enum */ Gain SENSITIVITY_5 = new Gain(5, 4, 1, 5);
        public static final /* enum */ Gain SENSITIVITY_6 = new Gain(6, 4, 2, 6);
        public static final /* enum */ Gain SENSITIVITY_7 = new Gain(7, 4, 2, 7);
        public static final /* enum */ Gain SENSITIVITY_8 = new Gain(8, 4, 3, 8);
        public static final /* enum */ Gain SENSITIVITY_9 = new Gain(9, 4, 4, 9);
        public static final /* enum */ Gain SENSITIVITY_10 = new Gain(10, 5, 4, 9);
        public static final /* enum */ Gain SENSITIVITY_11 = new Gain(11, 5, 4, 12);
        public static final /* enum */ Gain SENSITIVITY_12 = new Gain(12, 5, 7, 12);
        public static final /* enum */ Gain SENSITIVITY_13 = new Gain(13, 5, 8, 13);
        public static final /* enum */ Gain SENSITIVITY_14 = new Gain(14, 5, 9, 14);
        public static final /* enum */ Gain SENSITIVITY_15 = new Gain(15, 6, 9, 14);
        public static final /* enum */ Gain SENSITIVITY_16 = new Gain(16, 7, 10, 14);
        public static final /* enum */ Gain SENSITIVITY_17 = new Gain(17, 8, 10, 14);
        public static final /* enum */ Gain SENSITIVITY_18 = new Gain(18, 9, 11, 14);
        public static final /* enum */ Gain SENSITIVITY_19 = new Gain(19, 10, 12, 14);
        public static final /* enum */ Gain SENSITIVITY_20 = new Gain(20, 11, 12, 14);
        public static final /* enum */ Gain SENSITIVITY_21 = new Gain(21, 12, 12, 14);
        public static final /* enum */ Gain SENSITIVITY_22 = new Gain(22, 13, 12, 14);
        public static final /* enum */ Gain CUSTOM = new Gain(1, 0, 0, 0);
        private int mValue;
        private int mIF;
        private int mMixer;
        private int mLNA;
        private static final /* synthetic */ Gain[] $VALUES;

        public static Gain[] values() {
            return (Gain[])$VALUES.clone();
        }

        public static Gain valueOf(String name) {
            return Enum.valueOf(Gain.class, name);
        }

        private Gain(int value, int ifGain, int mixer, int lna) {
            this.mValue = value;
            this.mIF = ifGain;
            this.mMixer = mixer;
            this.mLNA = lna;
        }

        public int getValue() {
            return this.mValue;
        }

        public int getIF() {
            return this.mIF;
        }

        public int getMixer() {
            return this.mMixer;
        }

        public int getLNA() {
            return this.mLNA;
        }

        public static Gain getGain(GainMode mode, int value) {
            assert (1 <= value && value <= 22);
            switch (mode) {
                case LINEARITY: {
                    for (Gain gain : Gain.getLinearityGains()) {
                        if (gain.getValue() != value) continue;
                        return gain;
                    }
                    return LINEARITY_GAIN_DEFAULT;
                }
                case SENSITIVITY: {
                    for (Gain gain : Gain.getSensitivityGains()) {
                        if (gain.getValue() != value) continue;
                        return gain;
                    }
                    return SENSITIVITY_GAIN_DEFAULT;
                }
            }
            return CUSTOM;
        }

        public GainMode getGainMode() {
            if (Gain.getLinearityGains().contains((Object)this)) {
                return GainMode.LINEARITY;
            }
            if (Gain.getSensitivityGains().contains((Object)this)) {
                return GainMode.SENSITIVITY;
            }
            return GainMode.CUSTOM;
        }

        public static EnumSet<Gain> getLinearityGains() {
            return EnumSet.range(LINEARITY_1, LINEARITY_22);
        }

        public static EnumSet<Gain> getSensitivityGains() {
            return EnumSet.range(SENSITIVITY_1, SENSITIVITY_22);
        }

        private static /* synthetic */ Gain[] $values() {
            return new Gain[]{LINEARITY_1, LINEARITY_2, LINEARITY_3, LINEARITY_4, LINEARITY_5, LINEARITY_6, LINEARITY_7, LINEARITY_8, LINEARITY_9, LINEARITY_10, LINEARITY_11, LINEARITY_12, LINEARITY_13, LINEARITY_14, LINEARITY_15, LINEARITY_16, LINEARITY_17, LINEARITY_18, LINEARITY_19, LINEARITY_20, LINEARITY_21, LINEARITY_22, SENSITIVITY_1, SENSITIVITY_2, SENSITIVITY_3, SENSITIVITY_4, SENSITIVITY_5, SENSITIVITY_6, SENSITIVITY_7, SENSITIVITY_8, SENSITIVITY_9, SENSITIVITY_10, SENSITIVITY_11, SENSITIVITY_12, SENSITIVITY_13, SENSITIVITY_14, SENSITIVITY_15, SENSITIVITY_16, SENSITIVITY_17, SENSITIVITY_18, SENSITIVITY_19, SENSITIVITY_20, SENSITIVITY_21, SENSITIVITY_22, CUSTOM};
        }

        static {
            $VALUES = Gain.$values();
        }
    }

    public static enum Command {
        INVALID(0),
        RECEIVER_MODE(1),
        SI5351C_WRITE(2),
        SI5351C_READ(3),
        R820T_WRITE(4),
        R820T_READ(5),
        SPIFLASH_ERASE(6),
        SPIFLASH_WRITE(7),
        SPIFLASH_READ(8),
        BOARD_ID_READ(9),
        VERSION_STRING_READ(10),
        BOARD_PART_ID_SERIAL_NUMBER_READ(11),
        SET_SAMPLE_RATE(12),
        SET_FREQUENCY(13),
        SET_LNA_GAIN(14),
        SET_MIXER_GAIN(15),
        SET_VGA_GAIN(16),
        SET_LNA_AGC(17),
        SET_MIXER_AGC(18),
        MS_VENDOR_COMMAND(19),
        SET_RF_BIAS_COMMAND(20),
        GPIO_WRITE(21),
        GPIO_READ(22),
        GPIO_DIR__WRITE(23),
        GPIO_DIR_READ(24),
        GET_SAMPLE_RATES(25),
        SET_PACKING(26);

        private int mValue;

        private Command(int value) {
            this.mValue = value;
        }

        public byte getValue() {
            return (byte)this.mValue;
        }

        public static Command fromValue(int value) {
            if (0 <= value && value <= 25) {
                return Command.values()[value];
            }
            return INVALID;
        }
    }

    public static enum GPIOPin {
        PIN_0(0),
        PIN_1(1),
        PIN_2(2),
        PIN_3(3),
        PIN_4(4),
        PIN_5(5),
        PIN_6(6),
        PIN_7(7),
        PIN_8(8),
        PIN_9(9),
        PIN_10(10),
        PIN_11(11),
        PIN_12(12),
        PIN_13(13),
        PIN_14(14),
        PIN_15(15),
        PIN_16(16),
        PIN_17(17),
        PIN_18(18),
        PIN_19(19),
        PIN_20(20),
        PIN_21(21),
        PIN_22(22),
        PIN_23(23),
        PIN_24(24),
        PIN_25(25),
        PIN_26(26),
        PIN_27(27),
        PIN_28(28),
        PIN_29(29),
        PIN_30(30),
        PIN_31(31);

        private int mValue;

        private GPIOPin(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }
    }

    public static enum GPIOPort {
        PORT_0(0),
        PORT_1(1),
        PORT_2(2),
        PORT_3(3),
        PORT_4(4),
        PORT_5(5),
        PORT_6(6),
        PORT_7(7);

        private int mValue;

        private GPIOPort(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }
    }

    public static enum ReceiverMode {
        OFF(0),
        ON(1);

        private int mValue;

        private ReceiverMode(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }
    }

    public static enum BoardID {
        AIRSPY(0, "Airspy"),
        UNKNOWN(-1, "Unknown");

        private int mValue;
        private String mLabel;

        private BoardID(int value, String label) {
            this.mValue = value;
            this.mLabel = label;
        }

        public int getValue() {
            return this.mValue;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public static BoardID fromValue(int value) {
            if (value == 0) {
                return AIRSPY;
            }
            return UNKNOWN;
        }
    }

    public static enum GainMode {
        LINEARITY,
        SENSITIVITY,
        CUSTOM;

    }
}

