/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.airspy;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.source.tuner.TunerType;
import io.github.dsheirer.source.tuner.airspy.AirspyTunerController;
import io.github.dsheirer.source.tuner.configuration.TunerConfiguration;

public class AirspyTunerConfiguration
extends TunerConfiguration {
    private AirspyTunerController.Gain mGain = AirspyTunerController.LINEARITY_GAIN_DEFAULT;
    private int mSampleRate = AirspyTunerController.DEFAULT_SAMPLE_RATE.getRate();
    private int mIFGain = 9;
    private int mMixerGain = 9;
    private int mLNAGain = 7;
    private boolean mMixerAGC = false;
    private boolean mLNAAGC = false;

    public AirspyTunerConfiguration() {
    }

    @Override
    @JacksonXmlProperty(isAttribute=true, localName="type", namespace="http://www.w3.org/2001/XMLSchema-instance")
    public TunerType getTunerType() {
        return TunerType.AIRSPY_R820T;
    }

    public AirspyTunerConfiguration(String uniqueID) {
        super(uniqueID);
    }

    @JacksonXmlProperty(isAttribute=true, localName="sample_rate")
    public int getSampleRate() {
        return this.mSampleRate;
    }

    public void setSampleRate(int sampleRate) {
        this.mSampleRate = sampleRate;
    }

    @JacksonXmlProperty(isAttribute=true, localName="gain")
    public AirspyTunerController.Gain getGain() {
        return this.mGain;
    }

    public void setGain(AirspyTunerController.Gain gain) {
        this.mGain = gain;
    }

    @JacksonXmlProperty(isAttribute=true, localName="if_gain")
    public int getIFGain() {
        return this.mIFGain;
    }

    public void setIFGain(int gain) {
        this.mIFGain = gain;
    }

    @JacksonXmlProperty(isAttribute=true, localName="mixer_gain")
    public int getMixerGain() {
        return this.mMixerGain;
    }

    public void setMixerGain(int gain) {
        this.mMixerGain = gain;
    }

    @JacksonXmlProperty(isAttribute=true, localName="lna_gain")
    public int getLNAGain() {
        return this.mLNAGain;
    }

    public void setLNAGain(int gain) {
        this.mLNAGain = gain;
    }

    @JacksonXmlProperty(isAttribute=true, localName="mixer_agc")
    public boolean isMixerAGC() {
        return this.mMixerAGC;
    }

    public void setMixerAGC(boolean enabled) {
        this.mMixerAGC = enabled;
    }

    @JacksonXmlProperty(isAttribute=true, localName="lna_agc")
    public boolean isLNAAGC() {
        return this.mLNAAGC;
    }

    public void setLNAAGC(boolean enabled) {
        this.mLNAAGC = enabled;
    }
}

