/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner;

import io.github.dsheirer.buffer.INativeBuffer;
import io.github.dsheirer.buffer.INativeBufferProvider;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.record.RecorderFactory;
import io.github.dsheirer.record.wave.IRecordingStatusListener;
import io.github.dsheirer.record.wave.NativeBufferWaveRecorder;
import io.github.dsheirer.sample.Broadcaster;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.ISourceEventListener;
import io.github.dsheirer.source.ISourceEventProcessor;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.SourceEventListenerToProcessorAdapter;
import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.ITunerErrorListener;
import io.github.dsheirer.source.tuner.TunerType;
import io.github.dsheirer.source.tuner.channel.TunerChannel;
import io.github.dsheirer.source.tuner.configuration.TunerConfiguration;
import io.github.dsheirer.source.tuner.frequency.FrequencyController;
import io.github.dsheirer.source.tuner.manager.FrequencyErrorCorrectionManager;
import java.text.DecimalFormat;
import java.util.SortedSet;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TunerController
implements FrequencyController.Tunable,
ISourceEventProcessor,
ISourceEventListener,
INativeBufferProvider,
Listener<INativeBuffer>,
ITunerErrorListener {
    private static final Logger mLog = LoggerFactory.getLogger(TunerController.class);
    protected ReentrantLock mBufferListenerLock = new ReentrantLock();
    protected Broadcaster<INativeBuffer> mNativeBufferBroadcaster = new Broadcaster();
    protected FrequencyController mFrequencyController;
    private int mMiddleUnusableHalfBandwidth;
    private int mMeasuredFrequencyError;
    private double mUsableBandwidthPercentage;
    private SourceEventListenerToProcessorAdapter mSourceEventListener;
    private NativeBufferWaveRecorder mRecorder;
    private ITunerErrorListener mTunerErrorListener;
    private DecimalFormat mFrequencyErrorPPMFormat = new DecimalFormat("0.0");
    private FrequencyErrorCorrectionManager mFrequencyErrorCorrectionManager;

    public TunerController(ITunerErrorListener tunerErrorListener) {
        this.mTunerErrorListener = tunerErrorListener;
        this.mFrequencyController = new FrequencyController(this);
        this.mSourceEventListener = new SourceEventListenerToProcessorAdapter(this);
        this.mFrequencyErrorCorrectionManager = new FrequencyErrorCorrectionManager(this);
    }

    public ReentrantLock getFrequencyControllerLock() {
        return this.mFrequencyController.getFrequencyControllerLock();
    }

    public FrequencyErrorCorrectionManager getFrequencyErrorCorrectionManager() {
        return this.mFrequencyErrorCorrectionManager;
    }

    protected void dispose() {
        this.getFrequencyErrorCorrectionManager().dispose();
        this.mNativeBufferBroadcaster.clear();
        this.mFrequencyController.dispose();
        this.mSourceEventListener.dispose();
        this.mTunerErrorListener = null;
    }

    public abstract void start() throws SourceException;

    public abstract void stop();

    public abstract TunerType getTunerType();

    @Override
    public void setErrorMessage(String errorMessage) {
        if (this.mTunerErrorListener != null) {
            this.mTunerErrorListener.setErrorMessage(errorMessage);
        }
    }

    @Override
    public void tunerRemoved() {
        if (this.mTunerErrorListener != null) {
            this.mTunerErrorListener.tunerRemoved();
        }
    }

    public abstract int getBufferSampleCount();

    public long getBufferDuration() {
        return (long)(1000.0 / (this.getSampleRate() / (double)this.getBufferSampleCount()));
    }

    @Override
    public Listener<SourceEvent> getSourceEventListener() {
        return this.mSourceEventListener;
    }

    public void apply(TunerConfiguration config) throws SourceException {
        this.setFrequency(config.getFrequency());
        this.setFrequencyCorrection(config.getFrequencyCorrection());
        this.getFrequencyErrorCorrectionManager().setEnabled(config.getAutoPPMCorrectionEnabled());
    }

    @Override
    public void process(SourceEvent sourceEvent) throws SourceException {
        switch (sourceEvent.getEvent()) {
            case REQUEST_FREQUENCY_CHANGE: {
                this.setFrequency(sourceEvent.getValue().longValue());
                break;
            }
            case REQUEST_START_SAMPLE_STREAM: {
                if (!(sourceEvent.getSource() instanceof Listener)) break;
                this.addBufferListener((Listener)((Object)sourceEvent.getSource()));
                break;
            }
            case REQUEST_STOP_SAMPLE_STREAM: {
                if (!(sourceEvent.getSource() instanceof Listener)) break;
                this.removeBufferListener((Listener)((Object)sourceEvent.getSource()));
                break;
            }
            default: {
                mLog.error("Ignoring unrecognized source event: " + sourceEvent.getEvent().name() + " from [" + String.valueOf(sourceEvent.getSource().getClass()) + "]");
            }
        }
    }

    public boolean isLockedSampleRate() {
        return this.mFrequencyController.isSampleRateLocked();
    }

    public void setLockedSampleRate(boolean locked) {
        try {
            this.mFrequencyController.setSampleRateLocked(locked);
        }
        catch (SourceException se) {
            mLog.error("Couldn't set frequency controller locked state to: " + locked);
        }
    }

    public int getBandwidth() {
        return this.mFrequencyController.getBandwidth();
    }

    public void setFrequency(long frequency) throws SourceException {
        try {
            this.getFrequencyControllerLock().lock();
            this.mFrequencyController.setFrequency(frequency);
        }
        finally {
            this.getFrequencyControllerLock().unlock();
        }
    }

    public long getFrequency() {
        long frequency;
        try {
            this.getFrequencyControllerLock().lock();
            frequency = this.mFrequencyController.getFrequency();
        }
        finally {
            this.getFrequencyControllerLock().unlock();
        }
        return frequency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canTune(long frequency) {
        boolean canTune;
        try {
            this.getFrequencyControllerLock().lock();
            canTune = this.mFrequencyController.canTune(frequency);
        }
        finally {
            this.getFrequencyControllerLock().unlock();
        }
        return canTune;
    }

    public double getSampleRate() {
        return this.mFrequencyController.getSampleRate();
    }

    public double getFrequencyCorrection() {
        double correction;
        try {
            this.getFrequencyControllerLock().lock();
            correction = this.mFrequencyController.getFrequencyCorrection();
        }
        finally {
            this.getFrequencyControllerLock().unlock();
        }
        return correction;
    }

    public void setFrequencyCorrection(double correction) throws SourceException {
        try {
            this.getFrequencyControllerLock().lock();
            this.mFrequencyController.setFrequencyCorrection(correction);
        }
        finally {
            this.getFrequencyControllerLock().unlock();
        }
    }

    public long getMinimumFrequency() {
        long minimum;
        try {
            this.getFrequencyControllerLock().lock();
            minimum = this.mFrequencyController.getMinimumFrequency();
        }
        finally {
            this.getFrequencyControllerLock().unlock();
        }
        return minimum;
    }

    public void setMinimumFrequency(long minimum) {
        try {
            this.getFrequencyControllerLock().lock();
            this.mFrequencyController.setMinimumFrequency(minimum);
        }
        finally {
            this.getFrequencyControllerLock().unlock();
        }
    }

    public long getMaximumFrequency() {
        long maximum;
        try {
            this.getFrequencyControllerLock().lock();
            maximum = this.mFrequencyController.getMaximumFrequency();
        }
        finally {
            this.getFrequencyControllerLock().unlock();
        }
        return maximum;
    }

    public void setMaximumFrequency(long maximum) {
        try {
            this.getFrequencyControllerLock().lock();
            this.mFrequencyController.setMaximumFrequency(maximum);
        }
        finally {
            this.getFrequencyControllerLock().unlock();
        }
    }

    public long getMinTunedFrequency() throws SourceException {
        long minTuned;
        try {
            this.getFrequencyControllerLock().lock();
            minTuned = this.mFrequencyController.getFrequency() - (long)(this.getUsableBandwidth() / 2);
        }
        finally {
            this.getFrequencyControllerLock().unlock();
        }
        return minTuned;
    }

    public long getMaxTunedFrequency() throws SourceException {
        long maxTuned;
        try {
            this.getFrequencyControllerLock().lock();
            maxTuned = this.mFrequencyController.getFrequency() + (long)(this.getUsableBandwidth() / 2);
        }
        finally {
            this.getFrequencyControllerLock().unlock();
        }
        return maxTuned;
    }

    public int getMiddleUnusableHalfBandwidth() {
        return this.mMiddleUnusableHalfBandwidth;
    }

    public void setMiddleUnusableHalfBandwidth(int halfBandwidth) {
        this.mMiddleUnusableHalfBandwidth = halfBandwidth;
    }

    public boolean hasMiddleUnusableBandwidth() {
        return this.mMiddleUnusableHalfBandwidth != 0;
    }

    public int getUsableBandwidth() {
        return (int)((double)this.getBandwidth() * this.mUsableBandwidthPercentage);
    }

    public void setUsableBandwidthPercentage(double usableBandwidthPercentage) {
        this.mUsableBandwidthPercentage = usableBandwidthPercentage;
    }

    public int getUsableHalfBandwidth() {
        return this.getUsableBandwidth() / 2;
    }

    public int getMeasuredFrequencyError() {
        return this.mMeasuredFrequencyError;
    }

    public String getMeasuredErrorStatus() {
        if (this.hasMeasuredFrequencyError()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Measured Error: ");
            sb.append(this.getMeasuredFrequencyError());
            sb.append("Hz (");
            sb.append(this.mFrequencyErrorPPMFormat.format(this.getPPMFrequencyError()));
            sb.append("ppm)");
            return sb.toString();
        }
        return "";
    }

    public boolean hasMeasuredFrequencyError() {
        return this.mMeasuredFrequencyError != 0;
    }

    public double getPPMFrequencyError() {
        if (this.hasMeasuredFrequencyError()) {
            return (double)this.mMeasuredFrequencyError / ((double)this.getFrequency() / 1000000.0);
        }
        return 0.0;
    }

    public void setMeasuredFrequencyError(int measuredFrequencyError) {
        this.mMeasuredFrequencyError = measuredFrequencyError;
    }

    public void addListener(ISourceEventProcessor processor) {
        this.mFrequencyController.addSourceEventProcessor(processor);
    }

    public void removeListener(ISourceEventProcessor processor) {
        this.mFrequencyController.removeSourceEventProcessor(processor);
    }

    @Override
    public void addBufferListener(Listener<INativeBuffer> listener) {
        this.mBufferListenerLock.lock();
        try {
            this.mNativeBufferBroadcaster.addListener(listener);
        }
        finally {
            this.mBufferListenerLock.unlock();
        }
    }

    @Override
    public void removeBufferListener(Listener<INativeBuffer> listener) {
        this.mBufferListenerLock.lock();
        try {
            this.mNativeBufferBroadcaster.removeListener(listener);
        }
        finally {
            this.mBufferListenerLock.unlock();
        }
    }

    @Override
    public boolean hasBufferListeners() {
        boolean hasListeners;
        this.mBufferListenerLock.lock();
        try {
            hasListeners = this.mNativeBufferBroadcaster.hasListeners();
        }
        finally {
            this.mBufferListenerLock.unlock();
        }
        return hasListeners;
    }

    protected void broadcast(INativeBuffer complexSamples) {
        this.mNativeBufferBroadcaster.broadcast(complexSamples);
    }

    @Override
    public void receive(INativeBuffer nativeBuffer) {
        this.broadcast(nativeBuffer);
    }

    public boolean isTunedFor(TunerChannel tunerChannel) {
        try {
            long maxAvoid;
            long minAvoid;
            if (tunerChannel.getMinFrequency() < this.getMinTunedFrequency()) {
                return false;
            }
            if (tunerChannel.getMaxFrequency() > this.getMaxTunedFrequency()) {
                return false;
            }
            if (this.hasMiddleUnusableBandwidth() && tunerChannel.overlaps(minAvoid = this.getFrequency() - (long)this.getMiddleUnusableHalfBandwidth(), maxAvoid = this.getFrequency() + (long)this.getMiddleUnusableHalfBandwidth())) {
                return false;
            }
        }
        catch (SourceException se) {
            return false;
        }
        return true;
    }

    public boolean isTunedFor(SortedSet<TunerChannel> tunerChannels) {
        try {
            if (tunerChannels.first().getMinFrequency() < this.getMinTunedFrequency()) {
                return false;
            }
            if (tunerChannels.last().getMaxFrequency() > this.getMaxTunedFrequency()) {
                return false;
            }
            if (this.hasMiddleUnusableBandwidth()) {
                long minAvoid = this.getFrequency() - (long)this.getMiddleUnusableHalfBandwidth();
                long maxAvoid = this.getFrequency() + (long)this.getMiddleUnusableHalfBandwidth();
                for (TunerChannel tunerChannel : tunerChannels) {
                    if (!tunerChannel.overlaps(minAvoid, maxAvoid)) continue;
                    return false;
                }
            }
        }
        catch (SourceException se) {
            return false;
        }
        return true;
    }

    public void startRecorder(UserPreferences userPreferences, IRecordingStatusListener statusListener, String prefix) {
        if (!this.isRecording()) {
            this.mRecorder = RecorderFactory.getTunerRecorder(prefix + "_" + this.getFrequency(), userPreferences, statusListener);
            this.mRecorder.setSampleRate((float)this.getSampleRate());
            this.mRecorder.start();
            this.addBufferListener(this.mRecorder);
        }
    }

    public void stopRecorder() {
        if (this.isRecording()) {
            this.removeBufferListener(this.mRecorder);
            this.mRecorder.stop();
            this.mRecorder = null;
        }
    }

    public boolean isRecording() {
        return this.mRecorder != null;
    }
}

