/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner;

import java.util.EnumSet;

public enum TunerClass {
    AIRSPY("Airspy"),
    AIRSPY_HF("Airspy HF+"),
    FUNCUBE_DONGLE_PRO("Funcube Dongle Pro"),
    FUNCUBE_DONGLE_PRO_PLUS("Funcube Dongle Pro+"),
    HACKRF("HackRF"),
    RTL2832("RTL-2832"),
    RSP("RSP"),
    TEST_TUNER("Test"),
    RECORDING_TUNER("Recording"),
    UNKNOWN("Unknown");

    private String mDescription;
    public static final EnumSet<TunerClass> SUPPORTED_USB_TUNERS;
    public static final EnumSet<TunerClass> FUNCUBE_TUNERS;

    private TunerClass(String description) {
        this.mDescription = description;
    }

    public String toString() {
        return this.mDescription;
    }

    public boolean isSupportedUsbTuner() {
        return SUPPORTED_USB_TUNERS.contains((Object)this);
    }

    public boolean isFuncubeTuner() {
        return FUNCUBE_TUNERS.contains((Object)this);
    }

    public static TunerClass lookup(short vendor, short product) {
        int id = (vendor & 0xFFFF) << 16 | product & 0xFFFF;
        switch (id) {
            case 81328945: {
                return FUNCUBE_DONGLE_PRO_PLUS;
            }
            case 81328982: {
                return FUNCUBE_DONGLE_PRO;
            }
            case 198846514: 
            case 198846520: 
            case 214761641: 
            case 214761651: 
            case 214761652: 
            case 214761655: 
            case 214761670: 
            case 214761683: 
            case 214761687: 
            case 214761696: 
            case 408618528: 
            case 408618576: 
            case 408618624: 
            case 461427603: 
            case 461427605: 
            case 461427608: 
            case 461427613: 
            case 461427620: 
            case 488182017: 
            case 488182018: 
            case 488182019: 
            case 525187075: 
            case 525191171: 
            case 525193862: 
            case 525195267: {
                return RTL2832;
            }
            case 491806795: 
            case 491806857: 
            case 491834389: {
                return HACKRF;
            }
            case 491806881: {
                return AIRSPY;
            }
            case 65765388: {
                return AIRSPY_HF;
            }
        }
        return UNKNOWN;
    }

    static {
        SUPPORTED_USB_TUNERS = EnumSet.of(AIRSPY, new TunerClass[]{AIRSPY_HF, HACKRF, RTL2832, FUNCUBE_DONGLE_PRO, FUNCUBE_DONGLE_PRO_PLUS});
        FUNCUBE_TUNERS = EnumSet.of(FUNCUBE_DONGLE_PRO, FUNCUBE_DONGLE_PRO_PLUS);
    }
}

