/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.mixer;

import java.util.HashMap;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;

public class SystemMixerDevices {
    public static HashMap<String, TargetDataLine> getMixers(AudioFormat format) {
        HashMap<String, TargetDataLine> retVal = new HashMap<String, TargetDataLine>();
        DataLine.Info datalineInfo = new DataLine.Info(TargetDataLine.class, format);
        for (Mixer.Info mixerInfo : AudioSystem.getMixerInfo()) {
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            if (mixer == null) continue;
            try {
                TargetDataLine tdl = (TargetDataLine)mixer.getLine(datalineInfo);
                if (tdl == null) continue;
                retVal.put(mixerInfo.getName(), tdl);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (LineUnavailableException lineUnavailableException) {
                // empty catch block
            }
        }
        return retVal;
    }

    public static String getSoundDevices() {
        StringBuilder sb = new StringBuilder();
        for (Mixer.Info mixerInfo : AudioSystem.getMixerInfo()) {
            Line.Info[] targetLines;
            Line.Info[] sourceLines;
            sb.append("\n--------------------------------------------------");
            sb.append("\nMIXER name:").append(mixerInfo.getName()).append("\n      desc:").append(mixerInfo.getDescription()).append("\n      vendor:").append(mixerInfo.getVendor()).append("\n      version:").append(mixerInfo.getVersion()).append("\n");
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            for (Line.Info lineInfo : sourceLines = mixer.getSourceLineInfo()) {
                sb.append("      SOURCE LINE desc:").append(lineInfo).append("\n               class:").append(lineInfo.getClass()).append("\n               lineclass:").append(lineInfo.getLineClass()).append("\n");
            }
            for (Line.Info lineInfo : targetLines = mixer.getTargetLineInfo()) {
                sb.append("      TARGET LINE desc:").append(lineInfo).append("\n                class:").append(lineInfo.getClass()).append("\n                lineclass:").append(lineInfo.getLineClass()).append("\n");
            }
        }
        return sb.toString();
    }
}

