/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.mixer;

import io.github.dsheirer.audio.AudioFormats;
import io.github.dsheirer.sample.adapter.RealChannelShortAdapter;
import io.github.dsheirer.sample.adapter.RealShortAdapter;
import io.github.dsheirer.source.config.SourceConfigMixer;
import io.github.dsheirer.source.config.SourceConfiguration;
import io.github.dsheirer.source.mixer.MixerChannel;
import io.github.dsheirer.source.mixer.MixerChannelConfiguration;
import io.github.dsheirer.source.mixer.RealMixerSource;
import io.github.dsheirer.source.tuner.MixerTunerType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.Port;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixerManager {
    private static final Logger mLog = LoggerFactory.getLogger(MixerManager.class);

    public static RealMixerSource getSource(SourceConfiguration config) {
        MixerChannel channel;
        InputMixerConfiguration mixer;
        SourceConfigMixer mixerConfig;
        String mixerName;
        Object retVal = null;
        if (config instanceof SourceConfigMixer && (mixerName = (mixerConfig = (SourceConfigMixer)config).getMixer()) != null && (mixer = MixerManager.getInputMixer(mixerName)) != null && mixer.supportsChannel(channel = mixerConfig.getChannel())) {
            if (channel == MixerChannel.MONO) {
                DataLine.Info info = new DataLine.Info(TargetDataLine.class, AudioFormats.PCM_SIGNED_8000_HZ_16_BIT_MONO);
                try {
                    TargetDataLine dataLine = (TargetDataLine)mixer.getMixer().getLine(info);
                    if (dataLine != null) {
                        return new RealMixerSource(dataLine, AudioFormats.PCM_SIGNED_8000_HZ_16_BIT_MONO, new RealShortAdapter());
                    }
                }
                catch (LineUnavailableException e) {
                    mLog.error("couldn't get mixer data line for [" + mixerName + "] for channel [" + channel.name() + "]", (Throwable)e);
                }
            } else {
                DataLine.Info info = new DataLine.Info(TargetDataLine.class, AudioFormats.PCM_SIGNED_8000_HZ_16BITS_STEREO);
                try {
                    TargetDataLine dataLine = (TargetDataLine)mixer.getMixer().getLine(info);
                    if (dataLine != null) {
                        return new RealMixerSource(dataLine, AudioFormats.PCM_SIGNED_8000_HZ_16BITS_STEREO, new RealChannelShortAdapter(mixerConfig.getChannel()));
                    }
                }
                catch (LineUnavailableException e) {
                    mLog.error("couldn't get mixer data line for [" + mixerName + "] for channel [" + channel.name() + "]", (Throwable)e);
                }
            }
        }
        return null;
    }

    public static List<InputMixerConfiguration> getInputMixers() {
        ArrayList<InputMixerConfiguration> inputMixers = new ArrayList<InputMixerConfiguration>();
        for (Mixer.Info mixerInfo : AudioSystem.getMixerInfo()) {
            EnumSet<MixerChannel> inputChannels;
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            if (mixer == null || (inputChannels = MixerManager.getSupportedTargetChannels(mixer)) == null) continue;
            inputMixers.add(new InputMixerConfiguration(mixer, inputChannels));
        }
        return inputMixers;
    }

    public static InputMixerConfiguration getInputMixer(String name) {
        for (InputMixerConfiguration mixer : MixerManager.getInputMixers()) {
            if (!mixer.getMixerName().contentEquals(name)) continue;
            return mixer;
        }
        return null;
    }

    public static MixerChannelConfiguration getDefaultOutputMixer() {
        List<MixerChannelConfiguration> outputMixers = MixerManager.getOutputMixers();
        if (outputMixers.size() >= 1) {
            return outputMixers.get(0);
        }
        return null;
    }

    public static List<MixerChannelConfiguration> getOutputMixers() {
        ArrayList<MixerChannelConfiguration> outputMixers = new ArrayList<MixerChannelConfiguration>();
        for (Mixer.Info mixerInfo : AudioSystem.getMixerInfo()) {
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            if (mixer == null) continue;
            List<MixerChannel> outputChannels = MixerManager.getSupportedSourceChannels(mixer);
            for (MixerChannel channel : outputChannels) {
                outputMixers.add(new MixerChannelConfiguration(mixer, channel));
            }
        }
        return outputMixers;
    }

    public static TargetDataLine getTunerTargetDataLine(MixerTunerType mixerTunerType) {
        for (Mixer.Info mixerInfo : AudioSystem.getMixerInfo()) {
            Mixer mixer;
            MixerTunerType type = MixerTunerType.getMixerTunerType(mixerInfo);
            if (type == null || type != mixerTunerType || (mixer = AudioSystem.getMixer(mixerInfo)) == null) continue;
            for (Line.Info info : mixer.getTargetLineInfo()) {
                if (!(info instanceof DataLine.Info)) continue;
                try {
                    Line line = mixer.getLine(info);
                    if (!(line instanceof TargetDataLine)) continue;
                    return (TargetDataLine)line;
                }
                catch (LineUnavailableException lue) {
                    mLog.error("Line Unavailable. Unable to get TargetDataLine for Mixer Tuner: " + String.valueOf((Object)mixerTunerType));
                }
            }
        }
        return null;
    }

    public static AudioFormat getMatchingFormat(DataLine.Info info, AudioFormat audioFormat) {
        for (AudioFormat audioFormatToTest : info.getFormats()) {
            if (audioFormat.getSampleSizeInBits() != audioFormatToTest.getSampleSizeInBits() || audioFormat.getChannels() != audioFormatToTest.getChannels() || audioFormat.isBigEndian() ^ audioFormatToTest.isBigEndian()) continue;
            return audioFormatToTest;
        }
        return null;
    }

    private static TargetDataLine getTargetDataLine(Mixer.Info mixerInfo, AudioFormat format) {
        TargetDataLine retVal = null;
        Mixer mixer = AudioSystem.getMixer(mixerInfo);
        if (mixer != null) {
            try {
                for (Line line : mixer.getTargetLines()) {
                    mLog.debug("Line: " + line.getLineInfo().toString());
                }
                for (Line line : mixer.getSourceLines()) {
                    mLog.debug("Line: " + line.getLineInfo().toString());
                }
                Mixer.Info info = mixer.getMixerInfo();
                mLog.debug(info.toString());
                DataLine.Info datalineInfo = new DataLine.Info(TargetDataLine.class, format);
                retVal = (TargetDataLine)mixer.getLine(datalineInfo);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retVal;
    }

    private static EnumSet<MixerChannel> getSupportedTargetChannels(Mixer mixer) {
        DataLine.Info stereoInfo = new DataLine.Info(TargetDataLine.class, AudioFormats.PCM_SIGNED_8000_HZ_16BITS_STEREO);
        boolean stereoSupported = mixer.isLineSupported(stereoInfo);
        DataLine.Info monoInfo = new DataLine.Info(TargetDataLine.class, AudioFormats.PCM_SIGNED_8000_HZ_16_BIT_MONO);
        boolean monoSupported = mixer.isLineSupported(monoInfo);
        if (stereoSupported && monoSupported) {
            return EnumSet.of(MixerChannel.LEFT, MixerChannel.RIGHT, MixerChannel.MONO);
        }
        if (stereoSupported) {
            return EnumSet.of(MixerChannel.LEFT, MixerChannel.RIGHT, MixerChannel.MONO);
        }
        if (monoSupported) {
            return EnumSet.of(MixerChannel.MONO);
        }
        return null;
    }

    private static List<MixerChannel> getSupportedSourceChannels(Mixer mixer) {
        ArrayList<MixerChannel> channels = new ArrayList<MixerChannel>();
        DataLine.Info stereoInfo = new DataLine.Info(SourceDataLine.class, AudioFormats.PCM_SIGNED_8000_HZ_16BITS_STEREO);
        boolean stereoSupported = mixer.isLineSupported(stereoInfo);
        DataLine.Info monoInfo = new DataLine.Info(SourceDataLine.class, AudioFormats.PCM_SIGNED_8000_HZ_16_BIT_MONO);
        boolean monoSupported = mixer.isLineSupported(monoInfo);
        if (stereoSupported) {
            channels.add(MixerChannel.STEREO);
        }
        if (monoSupported) {
            channels.add(MixerChannel.MONO);
        }
        return channels;
    }

    public static String getMixerDevices() {
        StringBuilder sb = new StringBuilder();
        for (Mixer.Info mixerInfo : AudioSystem.getMixerInfo()) {
            Line.Info[] targetLines;
            Line.Info[] sourceLines;
            sb.append("\n--------------------------------------------------");
            sb.append("\nMIXER name:").append(mixerInfo.getName()).append("\n      desc:").append(mixerInfo.getDescription()).append("\n      vendor:").append(mixerInfo.getVendor()).append("\n      version:").append(mixerInfo.getVersion()).append("\n");
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            Line.Info lineInfo1 = mixer.getLineInfo();
            String a = lineInfo1.toString();
            Line.Info[] infos = mixer.getTargetLineInfo();
            for (Line.Info lineInfo : sourceLines = mixer.getSourceLineInfo()) {
                sb.append("      SOURCE LINE desc:").append(lineInfo).append("\n               class:").append(lineInfo.getClass()).append("\n               lineclass:").append(lineInfo.getLineClass()).append("\n");
            }
            for (Line.Info lineInfo : targetLines = mixer.getTargetLineInfo()) {
                sb.append("      TARGET LINE desc:").append(lineInfo).append("\n                class:").append(lineInfo.getClass()).append("\n                lineclass:").append(lineInfo.getLineClass()).append("\n");
                if (!(lineInfo instanceof DataLine.Info)) continue;
                DataLine.Info dli = (DataLine.Info)lineInfo;
                for (AudioFormat format : dli.getFormats()) {
                    sb.append(" FORMAT:").append(format.toString()).append("\n");
                    if (!mixerInfo.getName().startsWith("V")) continue;
                    sb.append("Iterating formats for " + mixerInfo.getName() + " " + mixerInfo.getDescription()).append("\n");
                    try {
                        Line line = mixer.getLine(lineInfo);
                        sb.append(line.getLineInfo().toString()).append("\n");
                        if (!(line instanceof TargetDataLine)) continue;
                        TargetDataLine tdl = (TargetDataLine)line;
                        tdl.open();
                        tdl.start();
                        byte[] bytes = new byte[1024];
                        int read = tdl.read(bytes, 0, bytes.length);
                        sb.append("READ:" + read).append("\n");
                        tdl.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            Line.Info portInfo = new Line.Info(Port.class);
            if (!mixer.isLineSupported(portInfo)) continue;
            sb.append("**PORT LINE IS SUPPORTED BY THIS MIXER***\n");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        MixerTunerType mixerTunerType = MixerTunerType.FUNCUBE_DONGLE_PRO_PLUS;
        TargetDataLine targetDataLine = MixerManager.getTunerTargetDataLine(mixerTunerType);
        if (targetDataLine != null) {
            try {
                targetDataLine.open(mixerTunerType.getAudioFormat());
                mLog.info(targetDataLine.getFormat().toString());
                targetDataLine.start();
                byte[] bytes = new byte[1024];
                int read = targetDataLine.read(bytes, 0, bytes.length);
                while (read > 0) {
                    mLog.debug("Read:" + read);
                    read = 0;
                }
                targetDataLine.close();
                mLog.debug("Done!");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class InputMixerConfiguration {
        private Mixer mMixer;
        private EnumSet<MixerChannel> mChannels;

        public InputMixerConfiguration(Mixer mixer, EnumSet<MixerChannel> channels) {
            this.mMixer = mixer;
            this.mChannels = channels;
        }

        public Mixer getMixer() {
            return this.mMixer;
        }

        public String getMixerName() {
            return this.mMixer.getMixerInfo().getName();
        }

        public EnumSet<MixerChannel> getChannels() {
            return this.mChannels;
        }

        public boolean supportsChannel(MixerChannel channel) {
            return this.mChannels.contains((Object)channel);
        }

        public String toString() {
            return this.mMixer.getMixerInfo().getName();
        }
    }
}

