/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.mixer;

import io.github.dsheirer.buffer.INativeBuffer;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.adapter.ISampleAdapter;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.mixer.MixerReader;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.TargetDataLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexMixer {
    private static final Logger mLog = LoggerFactory.getLogger(ComplexMixer.class);
    private MixerReader<INativeBuffer> mMixerReader;
    private String mName;

    public ComplexMixer(TargetDataLine targetDataLine, AudioFormat format, String name, ISampleAdapter sampleAdapter) {
        this.mMixerReader = new MixerReader(format, targetDataLine, sampleAdapter);
        this.mName = name;
    }

    public AudioFormat getAudioFormat() {
        return this.mMixerReader.getAudioFormat();
    }

    public void setBufferSampleCount(int bufferSize) {
        this.mMixerReader.setBufferSampleSize(bufferSize);
    }

    public void start() {
        this.mMixerReader.start();
    }

    public void stop() {
        this.mMixerReader.stop();
    }

    public void setBufferListener(Listener<INativeBuffer> listener) {
        this.mMixerReader.setBufferListener(listener);
    }

    public void removeBufferListener() {
        this.mMixerReader.removeBufferListener();
    }

    public void setSourceEventListener(Listener<SourceEvent> listener) {
        this.mMixerReader.setSourceEventListener(listener);
    }

    public void removeSourceEventListener() {
        this.mMixerReader.removeSourceEventListener();
    }

    public String toString() {
        return this.mName;
    }

    public void dispose() {
        this.mMixerReader.dispose();
    }
}

