/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source;

import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.ISourceEventProcessor;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.SourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceEventListenerToProcessorAdapter
implements Listener<SourceEvent> {
    private static final Logger mLog = LoggerFactory.getLogger(SourceEventListenerToProcessorAdapter.class);
    private ISourceEventProcessor mSourceEventProcessor;

    public SourceEventListenerToProcessorAdapter(ISourceEventProcessor sourceEventProcessor) {
        this.mSourceEventProcessor = sourceEventProcessor;
    }

    public void dispose() {
        this.mSourceEventProcessor = null;
    }

    @Override
    public void receive(SourceEvent sourceEvent) {
        if (this.mSourceEventProcessor != null) {
            try {
                this.mSourceEventProcessor.process(sourceEvent);
            }
            catch (SourceException e) {
                mLog.error("Error while transferring source event to source event processor [" + String.valueOf(this.mSourceEventProcessor.getClass()) + "]", (Throwable)e);
            }
        }
    }
}

