/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.settings;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import io.github.dsheirer.properties.SystemProperties;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.settings.ColorSetting;
import io.github.dsheirer.settings.FileSetting;
import io.github.dsheirer.settings.MapViewSetting;
import io.github.dsheirer.settings.Setting;
import io.github.dsheirer.settings.SettingChangeListener;
import io.github.dsheirer.settings.Settings;
import io.github.dsheirer.source.tuner.configuration.TunerConfigurationEvent;
import io.github.dsheirer.util.ThreadPool;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsManager
implements Listener<TunerConfigurationEvent> {
    private static final Logger mLog = LoggerFactory.getLogger(SettingsManager.class);
    private Settings mSettings = new Settings();
    private List<SettingChangeListener> mListeners = new ArrayList<SettingChangeListener>();
    private boolean mLoadingSettings = false;
    private AtomicBoolean mSettingsSavePending = new AtomicBoolean();

    public SettingsManager() {
        this.init();
    }

    private void init() {
        SystemProperties props = SystemProperties.getInstance();
        Path settingsFolder = props.getApplicationFolder("settings");
        String defaultSettingsFile = props.get("settings.defaultFilename", "settings.xml");
        String settingsFile = props.get("settings.currentFilename", defaultSettingsFile);
        this.load(settingsFolder.resolve(settingsFile));
    }

    @Override
    public void receive(TunerConfigurationEvent t) {
        if (!this.mLoadingSettings) {
            this.scheduleSettingsSave();
        }
    }

    public Settings getSettings() {
        return this.mSettings;
    }

    public void setSettings(Settings settings) {
        this.mSettings = settings;
    }

    public Setting getSetting(String name) {
        return this.mSettings.getSetting(name);
    }

    public ColorSetting getColorSetting(ColorSetting.ColorSettingName name) {
        ColorSetting setting = this.mSettings.getColorSetting(name);
        if (setting == null) {
            setting = new ColorSetting(name);
            this.addSetting(setting);
        }
        return setting;
    }

    public void setColorSetting(ColorSetting.ColorSettingName name, Color color) {
        ColorSetting setting = this.getColorSetting(name);
        setting.setColor(color);
        this.broadcastSettingChange(setting);
        this.scheduleSettingsSave();
    }

    public void resetColorSetting(ColorSetting.ColorSettingName name) {
        this.setColorSetting(name, name.getDefaultColor());
    }

    public void resetAllColorSettings() {
        for (ColorSetting color : this.mSettings.getColorSettings()) {
            this.resetColorSetting(color.getColorSettingName());
        }
    }

    public FileSetting getFileSetting(String name, String defaultPath) {
        FileSetting setting = this.mSettings.getFileSetting(name);
        if (setting == null) {
            setting = new FileSetting(name, defaultPath);
            this.addSetting(setting);
        }
        return setting;
    }

    public void setFileSetting(String name, String path) {
        FileSetting setting = this.getFileSetting(name, path);
        setting.setPath(path);
        this.broadcastSettingChange(setting);
        this.scheduleSettingsSave();
    }

    private void addSetting(Setting setting) {
        this.mSettings.addSetting(setting);
        this.scheduleSettingsSave();
        this.broadcastSettingChange(setting);
    }

    public MapViewSetting getMapViewSetting(String name, GeoPosition position, int zoom) {
        MapViewSetting loc = this.mSettings.getMapViewSetting(name);
        if (loc != null) {
            return loc;
        }
        MapViewSetting newLoc = new MapViewSetting(name, position, zoom);
        this.addSetting(newLoc);
        return newLoc;
    }

    public void setMapViewSetting(String name, GeoPosition position, int zoom) {
        MapViewSetting loc = this.getMapViewSetting(name, position, zoom);
        loc.setGeoPosition(position);
        loc.setZoom(zoom);
        this.scheduleSettingsSave();
    }

    private void save() {
        SystemProperties props = SystemProperties.getInstance();
        Path settingsFolder = props.getApplicationFolder("settings");
        String settingsDefault = props.get("settings.defaultFilename", "settings.xml");
        String settingsCurrent = props.get("settings.currentFilename", settingsDefault);
        Path settingsPath = settingsFolder.resolve(settingsCurrent);
        try (OutputStream out = Files.newOutputStream(settingsPath, new OpenOption[0]);){
            JacksonXmlModule xmlModule = new JacksonXmlModule();
            xmlModule.setDefaultUseWrapper(false);
            XmlMapper objectMapper = new XmlMapper(xmlModule);
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            objectMapper.writeValue(out, (Object)this.mSettings);
            out.flush();
        }
        catch (IOException ioe) {
            mLog.error("IO error while writing the settings to a file [" + String.valueOf(settingsPath) + "]", (Throwable)ioe);
        }
        catch (Exception e) {
            mLog.error("Error while saving settings file [" + String.valueOf(settingsPath) + "]", (Throwable)e);
        }
    }

    public void load(Path settingsPath) {
        this.mLoadingSettings = true;
        if (Files.exists(settingsPath, new LinkOption[0])) {
            mLog.info("SettingsManager - loading settings file [" + settingsPath.toString() + "]");
            JacksonXmlModule xmlModule = new JacksonXmlModule();
            xmlModule.setDefaultUseWrapper(false);
            ObjectMapper objectMapper = new XmlMapper(xmlModule).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            try (InputStream in = Files.newInputStream(settingsPath, new OpenOption[0]);){
                this.mSettings = (Settings)objectMapper.readValue(in, Settings.class);
            }
            catch (IOException ioe) {
                mLog.error("IO error while reading settings file", (Throwable)ioe);
            }
        } else {
            mLog.info("SettingsManager - settings does not exist [" + settingsPath.toString() + "]");
        }
        if (this.mSettings == null) {
            this.mSettings = new Settings();
        }
        this.mLoadingSettings = false;
    }

    public void broadcastSettingChange(Setting setting) {
        Iterator<SettingChangeListener> it = this.mListeners.iterator();
        while (it.hasNext()) {
            SettingChangeListener listener = it.next();
            if (listener == null) {
                it.remove();
                continue;
            }
            listener.settingChanged(setting);
        }
    }

    public void broadcastSettingDeleted(Setting setting) {
        Iterator<SettingChangeListener> it = this.mListeners.iterator();
        while (it.hasNext()) {
            SettingChangeListener listener = it.next();
            if (listener == null) {
                it.remove();
                continue;
            }
            listener.settingDeleted(setting);
        }
    }

    public void addListener(SettingChangeListener listener) {
        this.mListeners.add(listener);
    }

    public void removeListener(SettingChangeListener listener) {
        this.mListeners.remove(listener);
    }

    private void scheduleSettingsSave() {
        if (!this.mLoadingSettings && this.mSettingsSavePending.compareAndSet(false, true)) {
            ThreadPool.SCHEDULED.schedule(new SettingsSaveTask(), 2L, TimeUnit.SECONDS);
        }
    }

    public class SettingsSaveTask
    implements Runnable {
        @Override
        public void run() {
            SettingsManager.this.mSettingsSavePending.set(false);
            SettingsManager.this.save();
        }
    }
}

