/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.settings;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.settings.Setting;
import io.github.dsheirer.settings.SettingType;
import java.awt.Color;

public class ColorSetting
extends Setting {
    private static final int NO_TRANSLUCENCY = 255;
    private static final int SPECTRUM_TRANSLUCENCY = 128;
    private static final int CONFIG_TRANSLUCENCY = 60;
    private String mRGB;
    private int mAlpha;
    private ColorSettingName mColorSettingName = ColorSettingName.UNKNOWN;

    public ColorSetting() {
        this.setColor(this.mColorSettingName.getDefaultColor());
    }

    public ColorSetting(ColorSettingName name) {
        this.setColor(name.getDefaultColor());
        this.setColorSettingName(name);
    }

    @Override
    @JacksonXmlProperty(isAttribute=true, localName="type", namespace="http://www.w3.org/2001/XMLSchema-instance")
    public SettingType getType() {
        return SettingType.COLOR_SETTING;
    }

    @JacksonXmlProperty(isAttribute=true, localName="colorSettingName")
    public ColorSettingName getColorSettingName() {
        return this.mColorSettingName;
    }

    public void setColorSettingName(ColorSettingName name) {
        this.mColorSettingName = name;
    }

    @JacksonXmlProperty(isAttribute=true, localName="rgb")
    public String getRgb() {
        return this.mRGB;
    }

    public void setRgb(String value) {
        this.mRGB = value;
    }

    @JacksonXmlProperty(isAttribute=true, localName="alpha")
    public int getAlpha() {
        return this.mAlpha;
    }

    public void setAlpha(int value) {
        this.mAlpha = value;
    }

    @JsonIgnore
    public Color getColor() {
        Color temp = Color.decode(this.mRGB);
        return new Color(temp.getRed(), temp.getGreen(), temp.getBlue(), this.getColorSettingName().getTranslucency());
    }

    public void setColor(Color color) {
        this.mRGB = Integer.toHexString(color.getRGB());
        this.mRGB = "#" + this.mRGB.substring(2, this.mRGB.length());
        this.mAlpha = color.getAlpha();
    }

    public static Color getTranslucent(Color color, int translucency) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), translucency);
    }

    public static enum ColorSettingName {
        CHANNEL_CONFIG(Color.LIGHT_GRAY, 60, "Channel", "Channel Color"),
        CHANNEL_CONFIG_PROCESSING(Color.GREEN, 60, "Channel Processing", "Processing Channel Color"),
        CHANNEL_CONFIG_SELECTED(Color.BLUE, 60, "Channel Selected", "Selected Channel Color"),
        CHANNEL_STATE_BACKGROUND(Color.BLACK, 255, "Background", "Channel State Background"),
        CHANNEL_STATE_GRADIENT_TOP_CALL(Color.BLACK, 255, "Call Gradient Top", "Channel Call State Gradient Top"),
        CHANNEL_STATE_GRADIENT_MIDDLE_CALL(Color.BLUE, 255, "Call Gradient Middle", "Channel Call State Gradient Middle"),
        CHANNEL_STATE_GRADIENT_TOP_CONTROL(Color.BLACK, 255, "Control Gradient Top", "Channel Control State Gradient Top"),
        CHANNEL_STATE_GRADIENT_MIDDLE_CONTROL(new Color(12996352), 255, "Control Gradient Middle", "Channel Control State Gradient Middle"),
        CHANNEL_STATE_GRADIENT_TOP_DATA(Color.BLACK, 255, "Data Gradient Top", "Channel Data State Gradient Top"),
        CHANNEL_STATE_GRADIENT_MIDDLE_DATA(new Color(0xCC00CC), 255, "Data Gradient Middle", "Channel Data State Gradient Middle"),
        CHANNEL_STATE_GRADIENT_TOP_FADE(Color.BLACK, 255, "Fade Gradient Top", "Channel Fade State Gradient Top"),
        CHANNEL_STATE_GRADIENT_MIDDLE_FADE(Color.DARK_GRAY, 255, "Fade Gradient Middle", "Channel Fade State Gradient Middle"),
        CHANNEL_STATE_GRADIENT_TOP_IDLE(Color.BLACK, 255, "Idle Gradient Top", "Channel Idle State Gradient Top"),
        CHANNEL_STATE_GRADIENT_MIDDLE_IDLE(Color.DARK_GRAY, 255, "Idle Gradient Middle", "Channel Idle State Gradient Middle"),
        CHANNEL_STATE_GRADIENT_TOP_NO_TUNER(Color.RED, 255, "No Tuner Gradient Top", "Channel No Tuner State Gradient Top"),
        CHANNEL_STATE_GRADIENT_MIDDLE_NO_TUNER(new Color(0x990000), 255, "No Tuner Gradient Middle", "Channel No Tuner State Gradient Middle"),
        CHANNEL_STATE_LABEL_DETAILS(Color.LIGHT_GRAY, 255, "Details", "Details Label Color"),
        CHANNEL_STATE_LABEL_DECODER(Color.GREEN, 255, "Decoder", "Decoder Label Color"),
        CHANNEL_STATE_LABEL_AUX_DECODER(Color.YELLOW, 255, "Aux Decoder", "Aux Decoder Label Color"),
        CHANNEL_STATE_SELECTED_CHANNEL(Color.YELLOW, 255, "Selected Channel Indicator", "Selected Channel Indicator Color"),
        SPECTRUM_BACKGROUND(Color.BLACK, 255, "Background", "Spectrum Background Color"),
        SPECTRUM_CURSOR(Color.ORANGE, 255, "Cursor", "Spectrum Cursor Color"),
        SPECTRUM_GRADIENT_BOTTOM(Color.GREEN, 128, "Gradient Bottom", "Spectrum Gradient Bottom Color"),
        SPECTRUM_GRADIENT_TOP(Color.WHITE, 128, "Gradient Top", "Spectrum Gradient Top Color"),
        SPECTRUM_LINE(Color.LIGHT_GRAY, 128, "Line", "Spectrum Lines and Text Color"),
        UNKNOWN(Color.RED, 255, "Unknown", "Unknown Setting Color");

        private Color mDefaultColor;
        private int mTranslucency;
        private String mLabel;
        private String mDialogTitle;

        private ColorSettingName(Color defaultColor, int translucency, String label, String dialogTitle) {
            this.mDefaultColor = defaultColor;
            this.mTranslucency = translucency;
            this.mLabel = label;
            this.mDialogTitle = dialogTitle;
        }

        public Color getDefaultColor() {
            return this.mDefaultColor;
        }

        public int getTranslucency() {
            return this.mTranslucency;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String getDialogTitle() {
            return this.mDialogTitle;
        }
    }
}

