/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.service.radioreference;

import com.google.common.annotations.VisibleForTesting;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.rrapi.RadioReferenceException;
import io.github.dsheirer.rrapi.RadioReferenceService;
import io.github.dsheirer.rrapi.response.Fault;
import io.github.dsheirer.rrapi.type.AuthorizationInformation;
import io.github.dsheirer.rrapi.type.UserInfo;
import io.github.dsheirer.service.radioreference.CachingRadioReferenceService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Scanner;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadioReference {
    private static final Logger mLog = LoggerFactory.getLogger(RadioReference.class);
    public static final String SDRTRUNK_APP_KEY = "88969092";
    private RadioReferenceService mRadioReferenceService;
    private UserPreferences mUserPreferences;
    private AuthorizationInformation mAuthorizationInformation;
    private StringProperty mUserName = new SimpleStringProperty();
    private StringProperty mPassword = new SimpleStringProperty();
    private StringProperty mAccountExpiresProperty = new SimpleStringProperty();
    private BooleanProperty mAvailable = new SimpleBooleanProperty();
    private BooleanProperty mPremiumAccount = new SimpleBooleanProperty();
    private LoginStatus mLoginStatus = LoginStatus.UNKNOWN;

    public RadioReference(UserPreferences userPreferences) {
        this.mUserPreferences = userPreferences;
    }

    public BooleanProperty availableProperty() {
        return this.mAvailable;
    }

    public BooleanProperty premiumAccountProperty() {
        return this.mPremiumAccount;
    }

    public LoginStatus getLoginStatus() {
        return this.mLoginStatus;
    }

    public StringProperty userNameProperty() {
        return this.mUserName;
    }

    public StringProperty passwordProperty() {
        return this.mPassword;
    }

    public StringProperty accountExpiresProperty() {
        return this.mAccountExpiresProperty;
    }

    public RadioReferenceService getService() throws RadioReferenceException {
        AuthorizationInformation authorizationInformation;
        if (this.mRadioReferenceService == null && (authorizationInformation = this.getAuthorizationInformation()) != null) {
            this.mRadioReferenceService = new CachingRadioReferenceService(authorizationInformation);
        }
        if (this.mRadioReferenceService == null) {
            throw new RadioReferenceException("Please set username or password to non-null value");
        }
        return this.mRadioReferenceService;
    }

    public static boolean testConnection(String userName, String password) throws RadioReferenceException {
        AuthorizationInformation credentials = new AuthorizationInformation(SDRTRUNK_APP_KEY, userName, password);
        RadioReferenceService service = new RadioReferenceService(credentials);
        service.getUserInfo();
        return true;
    }

    public static LoginStatus testConnectionWithExp(String userName, String password) throws RadioReferenceException {
        AuthorizationInformation credentials = new AuthorizationInformation(SDRTRUNK_APP_KEY, userName, password);
        try {
            RadioReferenceService service = new RadioReferenceService(credentials);
            UserInfo ui = service.getUserInfo();
            return RadioReference.CheckExpDate(ui.getExpirationDate());
        }
        catch (RadioReferenceException rre) {
            if (rre.hasFault()) {
                Fault fault = rre.getFault();
                if (fault.getFaultCode() != null && fault.getFaultCode().contentEquals("AUTH")) {
                    return LoginStatus.INVALID_LOGIN;
                }
                throw rre;
            }
            throw rre;
        }
    }

    @VisibleForTesting
    protected static LoginStatus CheckExpDate(String RRExpirationString) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("MM-dd-yyyy", Locale.ENGLISH);
            Date RRExpDate = formatter.parse(RRExpirationString);
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            c.add(5, -2);
            if (RRExpDate.after(c.getTime())) {
                return LoginStatus.VALID_PREMIUM;
            }
            return LoginStatus.EXPIRED_PREMIUM;
        }
        catch (ParseException e) {
            return LoginStatus.VALID_PREMIUM;
        }
    }

    private void login() {
        try {
            UserInfo userInfo = this.getService().getUserInfo();
            this.accountExpiresProperty().setValue(userInfo.getExpirationDate());
            this.mLoginStatus = RadioReference.CheckExpDate(userInfo.getExpirationDate());
            if (this.mLoginStatus == LoginStatus.VALID_PREMIUM) {
                this.availableProperty().set(true);
                this.premiumAccountProperty().set(true);
            } else if (this.mLoginStatus == LoginStatus.EXPIRED_PREMIUM) {
                this.availableProperty().set(true);
                this.premiumAccountProperty().set(false);
            } else {
                this.availableProperty().set(false);
                this.premiumAccountProperty().set(false);
            }
        }
        catch (RadioReferenceException rre) {
            this.accountExpiresProperty().setValue(null);
            this.mLoginStatus = LoginStatus.UNKNOWN;
            this.availableProperty().set(false);
            this.premiumAccountProperty().set(false);
        }
    }

    public static AuthorizationInformation getAuthorizatonInformation(String userName, String password) {
        return new AuthorizationInformation(SDRTRUNK_APP_KEY, userName, password);
    }

    private AuthorizationInformation getAuthorizationInformation() {
        return this.mAuthorizationInformation;
    }

    public void setAuthorizationInformation(AuthorizationInformation authorizationInformation) {
        this.mAuthorizationInformation = authorizationInformation;
        this.mUserName.setValue(authorizationInformation.getUserName());
        this.mPassword.setValue(authorizationInformation.getPassword());
        if (this.mRadioReferenceService != null) {
            this.mRadioReferenceService = null;
        }
        this.login();
    }

    public static void main(String[] args) {
        UserPreferences userPreferences = new UserPreferences();
        RadioReference radioReference = new RadioReference(userPreferences);
        AuthorizationInformation credentials = userPreferences.getRadioReferencePreference().getAuthorizationInformation();
        if (credentials == null) {
            Scanner scanner = new Scanner(System.in);
            System.out.print("Username: ");
            String username = scanner.next();
            System.out.print("Password: ");
            String password = scanner.next();
            credentials = RadioReference.getAuthorizatonInformation(username, password);
        }
        radioReference.setAuthorizationInformation(credentials);
        if (radioReference.availableProperty().get()) {
            try {
                UserInfo userInfo = radioReference.getService().getUserInfo();
                System.out.println("User Name: " + userInfo.getUserName() + " Account Expires:" + userInfo.getExpirationDate());
            }
            catch (RadioReferenceException rre) {
                mLog.error("Error", (Throwable)rre);
            }
        }
    }

    public static enum LoginStatus {
        UNKNOWN,
        INVALID_LOGIN,
        EXPIRED_PREMIUM,
        VALID_PREMIUM;

    }
}

