/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.sample.complex;

import io.github.dsheirer.buffer.INativeBuffer;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.sample.complex.InterleavedComplexSamples;
import java.util.Iterator;

public class ComplexSamplesNativeBufferAdapter
implements INativeBuffer {
    private ComplexSamples mComplexSamples;

    public ComplexSamplesNativeBufferAdapter(ComplexSamples complexSamples) {
        this.mComplexSamples = complexSamples;
    }

    @Override
    public Iterator<ComplexSamples> iterator() {
        return new ComplexSamplesIterator();
    }

    @Override
    public Iterator<InterleavedComplexSamples> iteratorInterleaved() {
        return new InterleavedComplexSamplesIterator();
    }

    @Override
    public int sampleCount() {
        return this.mComplexSamples.i().length;
    }

    @Override
    public long getTimestamp() {
        return this.mComplexSamples.timestamp();
    }

    public class ComplexSamplesIterator
    implements Iterator<ComplexSamples> {
        public boolean mHasNext = true;

        @Override
        public boolean hasNext() {
            return this.mHasNext;
        }

        @Override
        public ComplexSamples next() {
            this.mHasNext = false;
            return ComplexSamplesNativeBufferAdapter.this.mComplexSamples;
        }
    }

    public class InterleavedComplexSamplesIterator
    implements Iterator<InterleavedComplexSamples> {
        public boolean mHasNext = true;

        @Override
        public boolean hasNext() {
            return this.mHasNext;
        }

        @Override
        public InterleavedComplexSamples next() {
            this.mHasNext = false;
            return ComplexSamplesNativeBufferAdapter.this.mComplexSamples.toInterleaved();
        }
    }
}

