/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.sample.adapter;

import io.github.dsheirer.buffer.FloatNativeBuffer;
import io.github.dsheirer.buffer.INativeBuffer;
import io.github.dsheirer.sample.adapter.ISampleAdapter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexShortAdapter
implements ISampleAdapter<INativeBuffer> {
    private static final Logger mLog = LoggerFactory.getLogger(ComplexShortAdapter.class);
    private ByteOrder mByteOrder = ByteOrder.LITTLE_ENDIAN;
    private ByteBuffer mByteBuffer;

    @Override
    public INativeBuffer convert(byte[] samples) {
        float[] convertedSamples = new float[samples.length / 2];
        int pointer = 0;
        this.mByteBuffer = ByteBuffer.wrap(samples);
        this.mByteBuffer.order(this.mByteOrder);
        while (this.mByteBuffer.hasRemaining()) {
            convertedSamples[pointer] = (float)this.mByteBuffer.getShort() / 32768.0f;
            ++pointer;
        }
        long now = System.currentTimeMillis();
        return new FloatNativeBuffer(convertedSamples, now, 192.0f);
    }

    public void setByteOrder(ByteOrder order) {
        this.mByteOrder = order;
    }
}

