/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.sample;

import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.sample.complex.InterleavedComplexSamples;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

public class ConversionUtils {
    public static float[] convertFromSigned16BitSamples(byte[] bytes) {
        return ConversionUtils.convertFromSigned16BitSamples(ByteBuffer.wrap(bytes));
    }

    public static float[] convertFromSigned16BitSamples(ByteBuffer buffer) {
        ShortBuffer byteBuffer = buffer.order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
        float[] samples = new float[buffer.limit() / 2];
        for (int x = 0; x < samples.length; ++x) {
            samples[x] = (float)byteBuffer.get() / 32767.0f;
        }
        return samples;
    }

    public static ByteBuffer convertToSigned16BitSamples(float[] samples) {
        ByteBuffer converted = ByteBuffer.allocate(samples.length * 2);
        converted.order(ByteOrder.LITTLE_ENDIAN);
        for (float sample : samples) {
            if (sample > 1.0f) {
                converted.putShort((short)Short.MAX_VALUE);
                continue;
            }
            if (sample < -1.0f) {
                converted.putShort((short)-32767);
                continue;
            }
            converted.putShort((short)(sample * 32767.0f));
        }
        return converted;
    }

    public static ByteBuffer convertToSigned32BitSamples(float[] samples) {
        ByteBuffer converted = ByteBuffer.allocate(samples.length * 4);
        converted.order(ByteOrder.LITTLE_ENDIAN);
        for (float sample : samples) {
            if (sample > 1.0f) {
                converted.putInt(Integer.MAX_VALUE);
                continue;
            }
            if (sample < -1.0f) {
                converted.putInt(-2147483647);
                continue;
            }
            converted.putInt((int)(sample * 2.1474836E9f));
        }
        return converted;
    }

    public static ByteBuffer convertToSigned16BitSamples(ComplexSamples samples) {
        ByteBuffer converted = ByteBuffer.allocate(samples.i().length * 4);
        converted.order(ByteOrder.LITTLE_ENDIAN);
        for (int x = 0; x < samples.i().length; ++x) {
            converted.putShort((short)(samples.i()[x] * 32767.0f));
            converted.putShort((short)(samples.q()[x] * 32767.0f));
        }
        return converted;
    }

    public static ByteBuffer convertToSigned16BitSamples(InterleavedComplexSamples complexSamples) {
        return ConversionUtils.convertToSigned16BitSamples(complexSamples.samples());
    }
}

