/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.sample;

import io.github.dsheirer.log.LoggingSuppressor;
import io.github.dsheirer.sample.Listener;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.LoggerFactory;

public class Broadcaster<T>
implements Listener<T> {
    private static LoggingSuppressor sLoggingSuppressor;
    private List<Listener<T>> mListeners = new CopyOnWriteArrayList<Listener<T>>();

    public Broadcaster() {
        sLoggingSuppressor = new LoggingSuppressor(LoggerFactory.getLogger(Broadcaster.class));
    }

    @Override
    public void receive(T t) {
        this.broadcast(t);
    }

    public void dispose() {
        this.clear();
    }

    public boolean hasListeners() {
        return !this.mListeners.isEmpty();
    }

    public int getListenerCount() {
        return this.mListeners.size();
    }

    public List<Listener<T>> getListeners() {
        return Collections.unmodifiableList(this.mListeners);
    }

    public void addListener(Listener<T> listener) {
        if (listener != null && !this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    public void removeListener(Listener<T> listener) {
        if (listener != null) {
            this.mListeners.remove(listener);
        }
    }

    public void clear() {
        this.mListeners.clear();
    }

    public void broadcast(T t) {
        for (Listener<T> listener : this.mListeners) {
            try {
                listener.receive(t);
            }
            catch (Exception e) {
                if (t != null) {
                    sLoggingSuppressor.error(t.getClass().toGenericString(), 5, "Error while broadcasting [" + String.valueOf(t.getClass()) + "] to listeners", e);
                    continue;
                }
                sLoggingSuppressor.error("null broadcast object", 5, "Can't broadcast null object to listener [" + String.valueOf(listener.getClass()) + "]", e);
            }
        }
    }
}

