/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.record.wave;

import io.github.dsheirer.module.Module;
import io.github.dsheirer.record.wave.WaveWriter;
import io.github.dsheirer.sample.ConversionUtils;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.sample.complex.IComplexSamplesListener;
import io.github.dsheirer.source.ISourceEventListener;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.util.Dispatcher;
import io.github.dsheirer.util.ThreadPool;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sound.sampled.AudioFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexSamplesWaveRecorder
extends Module
implements IComplexSamplesListener,
Listener<ComplexSamples>,
ISourceEventListener {
    private static final Logger mLog = LoggerFactory.getLogger(ComplexSamplesWaveRecorder.class);
    private Dispatcher<ComplexSamples> mBufferProcessor = new Dispatcher("sdrtrunk complex wave recorder", 250L);
    private AtomicBoolean mRunning = new AtomicBoolean();
    private BufferWaveWriter mWriter;
    private String mFilePrefix;
    private Path mFile;
    private AudioFormat mAudioFormat;

    public ComplexSamplesWaveRecorder(float sampleRate, String filePrefix) {
        this.mFilePrefix = filePrefix;
        this.setSampleRate(sampleRate);
    }

    public void setSampleRate(float sampleRate) {
        if (this.mAudioFormat == null || this.mAudioFormat.getSampleRate() != sampleRate) {
            this.mAudioFormat = new AudioFormat(sampleRate, 16, 2, true, false);
            if (this.mRunning.get()) {
                this.stop();
                this.start();
            }
        }
    }

    public Path getFile() {
        return this.mFile;
    }

    @Override
    public void start() {
        if (this.mRunning.compareAndSet(false, true)) {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append(this.mFilePrefix);
                sb.append(".wav");
                this.mFile = Paths.get(sb.toString(), new String[0]);
                this.mWriter = new BufferWaveWriter(this.mAudioFormat, this.mFile);
                this.mBufferProcessor.setListener(this.mWriter);
                this.mBufferProcessor.start();
            }
            catch (IOException io) {
                mLog.error("Error starting complex baseband recorder", (Throwable)io);
            }
        }
    }

    @Override
    public void stop() {
        if (this.mRunning.compareAndSet(true, false)) {
            if (this.mBufferProcessor != null) {
                this.mBufferProcessor.stop();
                this.mBufferProcessor.setListener(null);
            }
            if (this.mWriter != null) {
                ThreadPool.CACHED.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ComplexSamplesWaveRecorder.this.mWriter.close();
                        }
                        catch (IOException ioe) {
                            mLog.error("Error closing baseband I/Q recorder", (Throwable)ioe);
                        }
                    }
                });
            }
        }
    }

    @Override
    public void receive(ComplexSamples buffer) {
        this.mBufferProcessor.receive(buffer);
    }

    @Override
    public Listener<ComplexSamples> getComplexSamplesListener() {
        return this;
    }

    @Override
    public void reset() {
    }

    @Override
    public Listener<SourceEvent> getSourceEventListener() {
        return new Listener<SourceEvent>(){

            @Override
            public void receive(SourceEvent sourceEvent) {
                switch (sourceEvent.getEvent()) {
                    case NOTIFICATION_SAMPLE_RATE_CHANGE: {
                        ComplexSamplesWaveRecorder.this.setSampleRate(sourceEvent.getValue().floatValue());
                    }
                }
            }
        };
    }

    public class BufferWaveWriter
    extends WaveWriter
    implements Listener<ComplexSamples> {
        public BufferWaveWriter(AudioFormat format, Path file) throws IOException {
            super(format, file);
        }

        @Override
        public void receive(ComplexSamples complexSamples) {
            boolean error = false;
            if (!error) {
                try {
                    ComplexSamplesWaveRecorder.this.mWriter.writeData(ConversionUtils.convertToSigned16BitSamples(complexSamples));
                }
                catch (IOException ioe) {
                    mLog.error("IOException while writing I/Q buffers to wave recorder - stopping recorder", (Throwable)ioe);
                    error = true;
                    ComplexSamplesWaveRecorder.this.stop();
                }
            }
        }
    }
}

