/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.record.binary;

import io.github.dsheirer.module.Module;
import io.github.dsheirer.protocol.Protocol;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.buffer.IByteBufferListener;
import io.github.dsheirer.util.Dispatcher;
import io.github.dsheirer.util.StringUtils;
import io.github.dsheirer.util.TimeStamp;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryRecorder
extends Module
implements IByteBufferListener {
    private static final Logger mLog = LoggerFactory.getLogger(BinaryRecorder.class);
    private static final int MAX_RECORDING_BYTE_SIZE = 524288;
    private Dispatcher<ByteBuffer> mBufferProcessor = new Dispatcher("sdrtrunk binary recorder", 250L);
    private AtomicBoolean mRunning = new AtomicBoolean();
    private Path mBaseRecordingPath;
    private String mRecordingIdentifier;
    private BinaryWriter mBinaryWriter = new BinaryWriter();
    private int mBytesRecordedCounter;
    private Protocol mProtocol;
    private long mFrequency;

    public BinaryRecorder(Path baseRecordingPath, String recordingIdentifier, Protocol protocol, long frequency) {
        this.mBaseRecordingPath = baseRecordingPath;
        this.mRecordingIdentifier = recordingIdentifier;
        this.mBufferProcessor.setListener(this.mBinaryWriter);
        this.mProtocol = protocol;
        this.mFrequency = frequency;
    }

    @Override
    public void start() {
        if (this.mRunning.compareAndSet(false, true)) {
            try {
                this.mBinaryWriter.start(this.getRecordingPath());
                this.mBufferProcessor.start();
            }
            catch (IOException io) {
                mLog.error("Error starting binary baseband recorder", (Throwable)io);
            }
        }
    }

    @Override
    public void stop() {
        if (this.mRunning.compareAndSet(true, false) && this.mBufferProcessor != null) {
            this.mBufferProcessor.stop();
            this.mBufferProcessor.setListener(null);
            try {
                this.mBinaryWriter.stop();
            }
            catch (IOException ioe) {
                mLog.error("Error stopping binary recorder", (Throwable)ioe);
            }
        }
    }

    private Path getRecordingPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(TimeStamp.getTimeStamp("_"));
        sb.append("_");
        sb.append(this.mFrequency);
        sb.append("_");
        sb.append(this.mProtocol.getBitRate()).append("BPS_");
        sb.append(this.mProtocol.getFileNameLabel()).append("_");
        sb.append(this.mRecordingIdentifier.trim());
        sb.append(".bits");
        String cleaned = StringUtils.replaceIllegalCharacters(sb.toString());
        return this.mBaseRecordingPath.resolve(cleaned);
    }

    @Override
    public Listener<ByteBuffer> getByteBufferListener() {
        return this.mBufferProcessor;
    }

    @Override
    public void reset() {
    }

    public class BinaryWriter
    implements Listener<ByteBuffer> {
        private Path mCurrentPath;
        private WritableByteChannel mWritableByteChannel;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(Path path) throws IOException {
            BinaryWriter binaryWriter = this;
            synchronized (binaryWriter) {
                this.mCurrentPath = path;
                this.mWritableByteChannel = Files.newByteChannel(path, EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE), new FileAttribute[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() throws IOException {
            BinaryWriter binaryWriter = this;
            synchronized (binaryWriter) {
                if (this.mWritableByteChannel != null) {
                    this.mWritableByteChannel.close();
                }
                this.mWritableByteChannel = null;
                this.mCurrentPath = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cycleRecording() {
            BinaryWriter binaryWriter = this;
            synchronized (binaryWriter) {
                try {
                    if (this.mWritableByteChannel != null) {
                        this.mWritableByteChannel.close();
                    }
                    this.mCurrentPath = BinaryRecorder.this.getRecordingPath();
                    this.mWritableByteChannel = Files.newByteChannel(this.mCurrentPath, EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE), new FileAttribute[0]);
                    mLog.info("Binary (bitstream) recording started: " + this.mCurrentPath.toString());
                }
                catch (IOException ioe) {
                    mLog.error("Error while cycling a max-size bit stream recorder", (Throwable)ioe);
                }
                BinaryRecorder.this.mBytesRecordedCounter = 0;
            }
        }

        @Override
        public void receive(ByteBuffer byteBuffer) {
            if (this.mWritableByteChannel != null) {
                try {
                    BinaryRecorder.this.mBytesRecordedCounter += this.mWritableByteChannel.write(byteBuffer);
                    if (BinaryRecorder.this.mBytesRecordedCounter > 524288) {
                        this.cycleRecording();
                    }
                }
                catch (IOException ioe) {
                    mLog.error("Error recording demodulated bits to file [" + (this.mCurrentPath != null ? this.mCurrentPath.toString() : "no file") + "] - stopping recorder");
                    try {
                        this.stop();
                    }
                    catch (IOException ioe2) {
                        mLog.error("Error stopping recorder after write error", (Object)ioe2.getLocalizedMessage());
                    }
                }
            }
        }
    }
}

