/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.record;

import io.github.dsheirer.audio.AudioFormats;
import io.github.dsheirer.audio.AudioSegment;
import io.github.dsheirer.audio.convert.InputAudioFormat;
import io.github.dsheirer.audio.convert.MP3AudioConverter;
import io.github.dsheirer.audio.convert.MP3Setting;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.record.RecordFormat;
import io.github.dsheirer.record.wave.AudioMetadata;
import io.github.dsheirer.record.wave.AudioMetadataUtils;
import io.github.dsheirer.record.wave.WaveWriter;
import io.github.dsheirer.sample.ConversionUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioSegmentRecorder {
    private static final Logger mLog = LoggerFactory.getLogger(AudioSegmentRecorder.class);
    public static final int MP3_BIT_RATE = 16;
    public static final boolean CONSTANT_BIT_RATE = false;

    public static void record(AudioSegment audioSegment, Path path, RecordFormat recordFormat, UserPreferences userPreferences) throws IOException {
        switch (recordFormat) {
            case MP3: {
                AudioSegmentRecorder.recordMP3(audioSegment, path, userPreferences);
                break;
            }
            case WAVE: {
                AudioSegmentRecorder.recordWAVE(audioSegment, path);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized recording format [" + recordFormat.name() + "]");
            }
        }
    }

    public static void recordMP3(AudioSegment audioSegment, Path path, UserPreferences userPreferences) throws IOException {
        if (audioSegment.hasAudio()) {
            FileOutputStream outputStream = new FileOutputStream(path.toFile());
            Map<AudioMetadata, String> metadataMap = AudioMetadataUtils.getMetadataMap(audioSegment.getIdentifierCollection(), audioSegment.getAliasList());
            byte[] id3Bytes = AudioMetadataUtils.getMP3ID3(metadataMap);
            ((OutputStream)outputStream).write(id3Bytes);
            InputAudioFormat inputAudioFormat = userPreferences.getMP3Preference().getAudioSampleRate();
            MP3Setting mp3Setting = userPreferences.getMP3Preference().getMP3Setting();
            boolean normalizeAudio = userPreferences.getMP3Preference().isNormalizeAudioBeforeEncode();
            MP3AudioConverter converter = new MP3AudioConverter(inputAudioFormat, mp3Setting, normalizeAudio);
            List<byte[]> mp3Frames = converter.convert(audioSegment.getAudioBuffers());
            for (byte[] mp3Frame : mp3Frames) {
                ((OutputStream)outputStream).write(mp3Frame);
            }
            List<byte[]> lastFrames = converter.flush();
            if (!lastFrames.isEmpty()) {
                for (byte[] lastFrame : lastFrames) {
                    ((OutputStream)outputStream).write(lastFrame);
                }
            }
            outputStream.flush();
            ((OutputStream)outputStream).close();
        }
    }

    public static void recordWAVE(AudioSegment audioSegment, Path path) throws IOException {
        if (audioSegment.hasAudio()) {
            WaveWriter writer = new WaveWriter(AudioFormats.PCM_SIGNED_8000_HZ_16_BIT_MONO, path);
            for (float[] audioBuffer : audioSegment.getAudioBuffers()) {
                writer.writeData(ConversionUtils.convertToSigned16BitSamples(audioBuffer));
            }
            Map<AudioMetadata, String> metadataMap = AudioMetadataUtils.getMetadataMap(audioSegment.getIdentifierCollection(), audioSegment.getAliasList());
            ByteBuffer listChunk = AudioMetadataUtils.getLISTChunk(metadataMap);
            byte[] id3Bytes = AudioMetadataUtils.getMP3ID3(metadataMap);
            ByteBuffer id3Chunk = AudioMetadataUtils.getID3Chunk(id3Bytes);
            writer.writeMetadata(listChunk, id3Chunk);
            writer.close();
        }
    }
}

