/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.record;

import io.github.dsheirer.audio.AudioSegment;
import io.github.dsheirer.identifier.Form;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.identifier.integer.IntegerIdentifier;
import io.github.dsheirer.identifier.string.StringIdentifier;
import io.github.dsheirer.identifier.tone.Tone;
import io.github.dsheirer.identifier.tone.ToneIdentifier;
import io.github.dsheirer.identifier.tone.ToneSequence;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.record.AudioSegmentRecorder;
import io.github.dsheirer.record.RecordFormat;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.util.StringUtils;
import io.github.dsheirer.util.ThreadPool;
import io.github.dsheirer.util.TimeStamp;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioRecordingManager
implements Listener<AudioSegment> {
    private static final Logger mLog = LoggerFactory.getLogger(AudioRecordingManager.class);
    private LinkedTransferQueue<AudioSegment> mCompletedAudioSegmentQueue = new LinkedTransferQueue();
    private ScheduledFuture<?> mQueueProcessorHandle;
    private UserPreferences mUserPreferences;
    private int mUnknownAudioRecordingIndex = 1;
    private int mDuplicateAudioRecordingSuffix = 1;
    private String mPreviousRecordingPath = null;

    public AudioRecordingManager(UserPreferences userPreferences) {
        this.mUserPreferences = userPreferences;
    }

    public void start() {
        if (this.mQueueProcessorHandle == null) {
            this.mQueueProcessorHandle = ThreadPool.SCHEDULED.scheduleAtFixedRate(new QueueProcessor(), 0L, 1L, TimeUnit.SECONDS);
        }
    }

    public void stop() {
        if (this.mQueueProcessorHandle != null) {
            this.mQueueProcessorHandle.cancel(true);
            this.processAudioSegments();
            this.mQueueProcessorHandle = null;
        }
    }

    @Override
    public void receive(AudioSegment audioSegment) {
        audioSegment.completeProperty().addListener((ChangeListener)new AudioSegmentCompletionMonitor(audioSegment));
    }

    public void processCompletedAudioSegment(AudioSegment audioSegment) {
        List<Identifier> toIdentifiers;
        if (audioSegment.getAudioBufferCount() == 0) {
            mLog.debug("Audio Segment detected with 0 audio buffers");
        }
        if ((toIdentifiers = audioSegment.getIdentifierCollection().getIdentifiers(Role.TO)).isEmpty()) {
            mLog.debug("Audio Segment detected with NO TO identifiers");
        }
        if (audioSegment.recordAudioProperty().get()) {
            this.mCompletedAudioSegmentQueue.add(audioSegment);
        } else {
            audioSegment.decrementConsumerCount();
        }
    }

    private void processAudioSegments() {
        RecordFormat recordFormat = this.mUserPreferences.getRecordPreference().getAudioRecordFormat();
        AudioSegment audioSegment = this.mCompletedAudioSegmentQueue.poll();
        while (audioSegment != null) {
            if (audioSegment.isDuplicate() && this.mUserPreferences.getDuplicateCallDetectionPreference().isDuplicateRecordingSuppressionEnabled()) {
                audioSegment.decrementConsumerCount();
            } else {
                Path path = this.getAudioRecordingPath(audioSegment.getIdentifierCollection(), recordFormat);
                try {
                    AudioSegmentRecorder.record(audioSegment, path, recordFormat, this.mUserPreferences);
                }
                catch (IOException ioe) {
                    mLog.error("Error recording audio segment to [" + path.toString() + "]");
                }
                audioSegment.decrementConsumerCount();
            }
            audioSegment = this.mCompletedAudioSegmentQueue.poll();
        }
    }

    public Path getRecordingBasePath() {
        return this.mUserPreferences.getDirectoryPreference().getDirectoryRecording();
    }

    /*
     * Unable to fully structure code
     */
    private Path getAudioRecordingPath(IdentifierCollection identifierCollection, RecordFormat recordFormat) {
        sb = new StringBuilder();
        if (identifierCollection != null) {
            system = identifierCollection.getIdentifier(IdentifierClass.CONFIGURATION, Form.SYSTEM, Role.ANY);
            if (system != null) {
                sb.append((String)((StringIdentifier)system).getValue()).append("_");
            }
            if ((site = identifierCollection.getIdentifier(IdentifierClass.CONFIGURATION, Form.SITE, Role.ANY)) != null) {
                sb.append((String)((StringIdentifier)site).getValue()).append("_");
            }
            if ((channel = identifierCollection.getIdentifier(IdentifierClass.CONFIGURATION, Form.CHANNEL, Role.ANY)) != null) {
                sb.append((String)((StringIdentifier)channel).getValue()).append("_");
            }
            if ((to = identifierCollection.getIdentifier(IdentifierClass.USER, Form.TALKGROUP, Role.TO)) != null) {
                toValue = ((Integer)((IntegerIdentifier)to).getValue()).toString().replace(":", "");
                sb.append("_TO_").append(toValue);
            } else {
                toIdentifiers = identifierCollection.getIdentifiers(Role.TO);
                if (!toIdentifiers.isEmpty()) {
                    sb.append("_TO_").append(toIdentifiers.get(0));
                }
            }
            from = identifierCollection.getIdentifier(IdentifierClass.USER, Form.RADIO, Role.FROM);
            if (from != null) {
                fromValue = ((Integer)((IntegerIdentifier)from).getValue()).toString().replace(":", "");
                sb.append("_FROM_").append(fromValue);
            } else {
                fromIdentifiers = identifierCollection.getIdentifiers(Role.FROM);
                if (!fromIdentifiers.isEmpty()) {
                    for (Identifier identifier : fromIdentifiers) {
                        if (identifier.getForm() == Form.TONE) continue;
                        sb.append("_FROM_").append(identifier);
                        break;
                    }
                }
            }
            toneIdentifiers = identifierCollection.getIdentifiers(IdentifierClass.USER, Form.TONE);
            if (!toneIdentifiers.isEmpty()) {
                try {
                    identifier = toneIdentifiers.get(0);
                    if (!(identifier instanceof ToneIdentifier) || !(toneSequence = (ToneSequence)(toneIdentifier = (ToneIdentifier)identifier).getValue()).hasTones()) ** GOTO lbl57
                    sb.append("_TONES");
                    for (Tone tone : ((ToneSequence)toneIdentifier.getValue()).getTones()) {
                        label = tone.getAmbeTone().toString();
                        label = label.replace("TONE", "").trim();
                        label = label.replace(" ", "_");
                        sb.append("_").append(label);
                    }
                }
                catch (Exception e) {
                    AudioRecordingManager.mLog.error("Error appending tones to audio recording filename");
                }
            }
        } else {
            sb.append("audio_recording_no_metadata_").append(this.mUnknownAudioRecordingIndex++);
            if (this.mUnknownAudioRecordingIndex < 0) {
                this.mUnknownAudioRecordingIndex = 1;
            }
        }
lbl57:
        // 6 sources

        sbFinal = new StringBuilder();
        sbFinal.append(TimeStamp.getTimeStamp("_"));
        cleaned = StringUtils.replaceIllegalCharacters(sb.toString());
        maxLength = 255 - sbFinal.length() - ("_V" + this.mDuplicateAudioRecordingSuffix).length() - recordFormat.getExtension().length();
        if (cleaned.length() > maxLength) {
            cleaned = cleaned.substring(0, maxLength);
        }
        sbFinal.append(cleaned);
        if (this.mPreviousRecordingPath != null && this.mPreviousRecordingPath.contentEquals(sbFinal.toString())) {
            sbFinal.append("_V").append(this.mDuplicateAudioRecordingSuffix++);
        } else {
            this.mDuplicateAudioRecordingSuffix = 2;
            this.mPreviousRecordingPath = sbFinal.toString();
        }
        sbFinal.append(recordFormat.getExtension());
        return this.getRecordingBasePath().resolve(sbFinal.toString());
    }

    public class QueueProcessor
    implements Runnable {
        @Override
        public void run() {
            try {
                AudioRecordingManager.this.processAudioSegments();
            }
            catch (Throwable t) {
                mLog.error("Error while processing queued audio segments to recordings", t);
            }
        }
    }

    public class AudioSegmentCompletionMonitor
    implements ChangeListener<Boolean> {
        private AudioSegment mAudioSegment;

        public AudioSegmentCompletionMonitor(AudioSegment audioSegment) {
            this.mAudioSegment = audioSegment;
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            this.mAudioSegment.completeProperty().removeListener((ChangeListener)this);
            AudioRecordingManager.this.processCompletedAudioSegment(this.mAudioSegment);
        }
    }
}

