/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.properties;

import io.github.dsheirer.gui.SDRTrunk;
import io.github.dsheirer.util.ThreadPool;
import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemProperties {
    private static final Logger mLog = LoggerFactory.getLogger(SystemProperties.class);
    private static String DEFAULT_APP_ROOT = "SDRTrunk";
    private static String PROPERTIES_FILENAME = "SDRTrunk.properties";
    private static String MANIFEST_VERSION = "Implementation-Version";
    private static String BUILD_TIMESTAMP = "Build-Timestamp";
    private static SystemProperties INSTANCE;
    private static Properties mProperties;
    private Path mPropertiesPath;
    private String mApplicationName;
    private AtomicBoolean mSavePending = new AtomicBoolean();

    private SystemProperties() {
        mProperties = new Properties();
    }

    public static SystemProperties getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SystemProperties();
        }
        return INSTANCE;
    }

    private void save() {
        if (this.mSavePending.compareAndSet(false, true)) {
            ThreadPool.SCHEDULED.schedule(new SavePropertiesTask(), 2L, TimeUnit.SECONDS);
        }
    }

    public static Manifest getManifest(Class<?> clz) {
        Manifest manifest;
        block9: {
            String resource = "/" + clz.getName().replace(".", "/") + ".class";
            String fullPath = clz.getResource(resource).toString();
            String archivePath = fullPath.substring(0, fullPath.length() - resource.length());
            if (archivePath.endsWith("\\WEB-INF\\classes") || archivePath.endsWith("/WEB-INF/classes")) {
                archivePath = archivePath.substring(0, archivePath.length() - "/WEB-INF/classes".length());
            }
            InputStream input = new URL(archivePath + "/META-INF/MANIFEST.MF").openStream();
            try {
                manifest = new Manifest(input);
                if (input == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    mLog.error("Unable to load jar manifest - we're probably not running from a release jar");
                    return null;
                }
            }
            input.close();
        }
        return manifest;
    }

    public Path getApplicationRootPath() {
        Path retVal = null;
        String root2 = this.get("root.directory", DEFAULT_APP_ROOT);
        retVal = root2.equalsIgnoreCase(DEFAULT_APP_ROOT) ? Paths.get(System.getProperty("user.home"), DEFAULT_APP_ROOT) : Paths.get(root2, new String[0]);
        return retVal;
    }

    public Path getApplicationFolder(String folder) {
        Path retVal = this.getApplicationRootPath().resolve(folder);
        if (!Files.exists(retVal, new LinkOption[0])) {
            try {
                Files.createDirectory(retVal, new FileAttribute[0]);
            }
            catch (IOException e) {
                mLog.error("SystemProperties - exception while creating app folder [" + folder + "]", (Throwable)e);
            }
        }
        return retVal;
    }

    public void logCurrentSettings() {
        if (this.mPropertiesPath == null) {
            mLog.info("SystemProperties - no properties file loaded - using defaults");
        }
    }

    public void load(Path propertiesPath) {
        if (propertiesPath != null) {
            this.mPropertiesPath = propertiesPath;
            if (Files.exists(this.mPropertiesPath, new LinkOption[0])) {
                try (FileInputStream in = new FileInputStream(propertiesPath.toString());){
                    mProperties.load(in);
                }
                catch (IOException ioe) {
                    mLog.error("Error loading system properties file", (Object)ioe.getMessage());
                }
            }
        }
        mLog.info("SystemProperties - loaded [" + propertiesPath.toString() + "]");
    }

    public String getApplicationName() {
        if (this.mApplicationName == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("sdrtrunk");
            Manifest manifest = SystemProperties.getManifest(SDRTrunk.class);
            if (manifest != null) {
                String version = manifest.getMainAttributes().getValue(MANIFEST_VERSION);
                String timestamp = manifest.getMainAttributes().getValue(BUILD_TIMESTAMP);
                if (version != null) {
                    if (version.contains("nightly") && timestamp != null) {
                        sb.append(" nightly - ").append(timestamp);
                    } else {
                        sb.append(" v");
                        sb.append(version);
                    }
                }
            }
            this.mApplicationName = sb.toString();
        }
        return this.mApplicationName;
    }

    private String get(String key) {
        return mProperties.getProperty(key);
    }

    public String get(String key, String defaultValue) {
        String value = this.get(key);
        if (value != null) {
            return value;
        }
        this.set(key, defaultValue);
        return defaultValue;
    }

    public boolean get(String key, boolean defaultValue) {
        String value = this.get(key);
        if (value != null) {
            try {
                boolean stored = Boolean.parseBoolean(value);
                return stored;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.set(key, String.valueOf(defaultValue));
        return defaultValue;
    }

    public int get(String key, int defaultValue) {
        String value = this.get(key);
        if (value != null) {
            try {
                int stored = Integer.parseInt(value);
                return stored;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.set(key, String.valueOf(defaultValue));
        return defaultValue;
    }

    public void set(String key, String value) {
        mProperties.setProperty(key, value);
        this.save();
    }

    public void set(String key, boolean value) {
        this.set(key, String.valueOf(value));
    }

    public void set(String key, int value) {
        this.set(key, String.valueOf(value));
    }

    public Color get(String key, Color defaultColor) {
        return new Color(this.get(key, defaultColor.getRGB()), true);
    }

    public static Color getTranslucent(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public class SavePropertiesTask
    implements Runnable {
        @Override
        public void run() {
            if (SystemProperties.this.mSavePending.compareAndSet(true, false)) {
                Path propsPath = SystemProperties.this.getApplicationRootPath().resolve(PROPERTIES_FILENAME);
                try (FileOutputStream out = new FileOutputStream(propsPath.toString());){
                    String comments = "SDRTrunk - SDR Trunking Decoder Application Settings";
                    mProperties.store(out, comments);
                }
                catch (IOException ioe) {
                    mLog.error("Error saving system properties file [" + propsPath.toString() + "]", (Throwable)ioe);
                }
            }
        }
    }
}

