/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.preference.mp3;

import io.github.dsheirer.audio.convert.InputAudioFormat;
import io.github.dsheirer.audio.convert.MP3Setting;
import io.github.dsheirer.preference.Preference;
import io.github.dsheirer.preference.PreferenceType;
import io.github.dsheirer.sample.Listener;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MP3Preference
extends Preference {
    private static final String PREFERENCE_KEY_AUDIO_MP3_SETTING = "audio.mp3.setting";
    private static final String PREFERENCE_KEY_AUDIO_MP3_SAMPLE_RATE = "audio.mp3.sample.rate";
    private static final String PREFERENCE_KEY_AUDIO_MP3_NORMALIZE_BEFORE_ENCODE = "audio.mp3.normalize.before.encode";
    private static final Logger mLog = LoggerFactory.getLogger(MP3Preference.class);
    private Preferences mPreferences = Preferences.userNodeForPackage(MP3Preference.class);
    private InputAudioFormat mInputAudioFormat;
    private MP3Setting mMP3Setting;
    private Boolean mNormalizeAudio;

    public MP3Preference(Listener<PreferenceType> updateListener) {
        super(updateListener);
    }

    @Override
    public PreferenceType getPreferenceType() {
        return PreferenceType.MP3;
    }

    public MP3Setting getMP3Setting() {
        if (this.mMP3Setting == null) {
            try {
                String setting = this.mPreferences.get(PREFERENCE_KEY_AUDIO_MP3_SETTING, MP3Setting.getDefault().name());
                this.mMP3Setting = MP3Setting.valueOf(setting);
            }
            catch (Exception e) {
                mLog.error("Error parsing mp3 setting preference", (Throwable)e);
            }
            if (this.mMP3Setting == null) {
                this.mMP3Setting = MP3Setting.getDefault();
            }
        }
        return this.mMP3Setting;
    }

    public void setMP3Setting(MP3Setting mp3Setting) {
        this.mMP3Setting = mp3Setting;
        this.mPreferences.put(PREFERENCE_KEY_AUDIO_MP3_SETTING, mp3Setting.name());
        this.notifyPreferenceUpdated();
    }

    public InputAudioFormat getAudioSampleRate() {
        if (this.mInputAudioFormat == null) {
            MP3Setting setting;
            try {
                String rate = this.mPreferences.get(PREFERENCE_KEY_AUDIO_MP3_SAMPLE_RATE, InputAudioFormat.getDefault().name());
                this.mInputAudioFormat = InputAudioFormat.valueOf(rate);
            }
            catch (Exception e) {
                mLog.error("Error parsing mp3 setting preference", (Throwable)e);
            }
            if (this.mInputAudioFormat == null) {
                this.mInputAudioFormat = InputAudioFormat.getDefault();
            }
            if (!(setting = this.getMP3Setting()).getSupportedSampleRates().contains((Object)this.mInputAudioFormat)) {
                InputAudioFormat supportedAudioFormat = InputAudioFormat.getDefault();
                if (!setting.getSupportedSampleRates().contains((Object)supportedAudioFormat)) {
                    supportedAudioFormat = setting.getSupportedSampleRates().get(0);
                }
                mLog.warn("MP3 Setting [" + String.valueOf((Object)setting) + "] does not support input sample rate [" + this.getAudioSampleRate().name() + "] - updating to supported sample rate [" + supportedAudioFormat.name() + "]");
                this.setAudioSampleRate(supportedAudioFormat);
            }
        }
        return this.mInputAudioFormat;
    }

    public void setAudioSampleRate(InputAudioFormat inputAudioFormat) {
        this.mInputAudioFormat = inputAudioFormat;
        this.mPreferences.put(PREFERENCE_KEY_AUDIO_MP3_SAMPLE_RATE, this.mInputAudioFormat.name());
        this.notifyPreferenceUpdated();
    }

    public boolean isNormalizeAudioBeforeEncode() {
        if (this.mNormalizeAudio == null) {
            this.mNormalizeAudio = this.mPreferences.getBoolean(PREFERENCE_KEY_AUDIO_MP3_NORMALIZE_BEFORE_ENCODE, false);
        }
        return this.mNormalizeAudio;
    }

    public void setNormalizeAudioBeforeEncode(boolean normalizeAudio) {
        this.mNormalizeAudio = normalizeAudio;
        this.mPreferences.putBoolean(PREFERENCE_KEY_AUDIO_MP3_NORMALIZE_BEFORE_ENCODE, normalizeAudio);
        this.notifyPreferenceUpdated();
    }
}

