/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.preference.identifier.talkgroup;

import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import io.github.dsheirer.preference.identifier.IntegerFormat;
import io.github.dsheirer.preference.identifier.talkgroup.AbstractIntegerFormatter;

public class MDC1200TalkgroupFormatter
extends AbstractIntegerFormatter {
    public static final int DECIMAL_WIDTH = 5;
    public static final int HEXADECIMAL_WIDTH = 4;

    public static String format(TalkgroupIdentifier identifier, IntegerFormat format, boolean fixedWidth) {
        if (fixedWidth) {
            switch (format) {
                case DECIMAL: 
                case FORMATTED: {
                    return MDC1200TalkgroupFormatter.toDecimal((Integer)identifier.getValue(), 5);
                }
                case HEXADECIMAL: {
                    return MDC1200TalkgroupFormatter.toHex((Integer)identifier.getValue(), 4);
                }
            }
            throw new IllegalArgumentException("Unrecognized integer format: " + String.valueOf((Object)format));
        }
        switch (format) {
            case DECIMAL: 
            case FORMATTED: {
                return ((Integer)identifier.getValue()).toString();
            }
            case HEXADECIMAL: {
                return MDC1200TalkgroupFormatter.toHex((Integer)identifier.getValue());
            }
        }
        throw new IllegalArgumentException("Unrecognized integer format: " + String.valueOf((Object)format));
    }

    @Override
    public String format(int value, IntegerFormat integerFormat) {
        switch (integerFormat) {
            case DECIMAL: 
            case FORMATTED: {
                return this.format(value);
            }
            case HEXADECIMAL: {
                return MDC1200TalkgroupFormatter.toHex(value);
            }
        }
        throw new IllegalArgumentException("Unrecognized integer format: " + String.valueOf((Object)integerFormat));
    }
}

