/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.preference.identifier.talkgroup;

import io.github.dsheirer.identifier.talkgroup.LTRTalkgroup;
import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import io.github.dsheirer.preference.identifier.IntegerFormat;
import io.github.dsheirer.preference.identifier.talkgroup.AbstractIntegerFormatter;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LTRTalkgroupFormatter
extends AbstractIntegerFormatter {
    private static final Logger mLog = LoggerFactory.getLogger(LTRTalkgroupFormatter.class);
    private static final int IDENTIFIER_DECIMAL_WIDTH = 4;
    private static final int IDENTIFIER_HEXADECIMAL_WIDTH = 4;
    private static final int HOME_REPEATER_DECIMAL_WIDTH = 2;
    private static final int TALKGROUP_DECIMAL_WIDTH = 3;
    private static final String SEPARATOR = "-";
    private static final Pattern LTR_PATTERN = Pattern.compile("([01])-(\\d{1,2})-(\\d{1,3})");

    public static String format(TalkgroupIdentifier identifier, IntegerFormat format, boolean fixedWidth) {
        if (identifier instanceof LTRTalkgroup) {
            LTRTalkgroup ltr = (LTRTalkgroup)identifier;
            if (fixedWidth) {
                switch (format) {
                    case DECIMAL: {
                        return LTRTalkgroupFormatter.toDecimal((Integer)ltr.getValue(), 4);
                    }
                    case FORMATTED: {
                        return ltr.getArea() + SEPARATOR + LTRTalkgroupFormatter.toDecimal(ltr.getHomeChannel(), 2) + SEPARATOR + LTRTalkgroupFormatter.toDecimal(ltr.getTalkgroup(), 3);
                    }
                    case HEXADECIMAL: {
                        return LTRTalkgroupFormatter.toHex((Integer)ltr.getValue(), 4);
                    }
                }
                throw new IllegalArgumentException("Unrecognized integer format: " + String.valueOf((Object)format));
            }
            switch (format) {
                case DECIMAL: {
                    return ltr.toString();
                }
                case FORMATTED: {
                    return ltr.getArea() + SEPARATOR + ltr.getHomeChannel() + SEPARATOR + ltr.getTalkgroup();
                }
                case HEXADECIMAL: {
                    return LTRTalkgroupFormatter.toHex((Integer)identifier.getValue());
                }
            }
            throw new IllegalArgumentException("Unrecognized integer format: " + String.valueOf((Object)format));
        }
        return identifier.toString();
    }

    @Override
    public int parse(String formattedTalkgroup) throws ParseException {
        Matcher m;
        if (formattedTalkgroup != null && (m = LTR_PATTERN.matcher(formattedTalkgroup)).matches()) {
            String rawArea = m.group(1);
            String rawLcn = m.group(2);
            String rawGroup = m.group(3);
            try {
                int area = Integer.parseInt(rawArea);
                if (area < 0 || area > 1) {
                    throw new ParseException("LTR area must be in range 0-1.  Error parsing [" + formattedTalkgroup + "]", 0);
                }
                int lcn = Integer.parseInt(rawLcn);
                if (lcn < 1 || lcn > 20) {
                    throw new ParseException("LTR repeater must be in range 1-20.  Error parsing [" + formattedTalkgroup + "]", 0);
                }
                int group = Integer.parseInt(rawGroup);
                if (group < 0 || group > 255) {
                    throw new ParseException("LTR talkgroup must be in range 1-255.  Error parsing [" + formattedTalkgroup + "]", 0);
                }
                return (area << 13) + (lcn << 8) + group;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new ParseException("Error parsing LTR talkgroup [" + formattedTalkgroup + "]", 0);
    }

    @Override
    public String format(int value, IntegerFormat format) {
        switch (format) {
            default: 
        }
        return this.format(value);
    }

    @Override
    public String format(int talkgroup) {
        return LTRTalkgroupFormatter.getArea(talkgroup) + SEPARATOR + LTRTalkgroupFormatter.toDecimal(LTRTalkgroupFormatter.getLcn(talkgroup), 2) + SEPARATOR + LTRTalkgroupFormatter.toDecimal(LTRTalkgroupFormatter.getTalkgroup(talkgroup), 3);
    }

    public static int getArea(int value) {
        return value >> 13 & 1;
    }

    public static int getLcn(int value) {
        return value >> 8 & 0x1F;
    }

    public static int getTalkgroup(int value) {
        return value & 0xFF;
    }
}

