/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.preference.identifier.talkgroup;

import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import io.github.dsheirer.preference.identifier.IntegerFormat;
import io.github.dsheirer.preference.identifier.talkgroup.AbstractIntegerFormatter;

public class AnalogTalkgroupFormatter
extends AbstractIntegerFormatter {
    public static final int DECIMAL_WIDTH = 5;
    public static final int HEXADECIMAL_WIDTH = 4;

    public static String format(TalkgroupIdentifier identifier, IntegerFormat format, boolean fixedWidth) {
        if (fixedWidth) {
            switch (format) {
                case DECIMAL: 
                case FORMATTED: {
                    return AnalogTalkgroupFormatter.toDecimal((Integer)identifier.getValue(), 5);
                }
                case HEXADECIMAL: {
                    return AnalogTalkgroupFormatter.toHex((Integer)identifier.getValue(), 4);
                }
            }
            throw new IllegalArgumentException("Unrecognized integer format: " + String.valueOf((Object)format));
        }
        switch (format) {
            case DECIMAL: 
            case FORMATTED: {
                return ((Integer)identifier.getValue()).toString();
            }
            case HEXADECIMAL: {
                return AnalogTalkgroupFormatter.toHex((Integer)identifier.getValue());
            }
        }
        throw new IllegalArgumentException("Unrecognized integer format: " + String.valueOf((Object)format));
    }

    @Override
    public String format(int value, IntegerFormat integerFormat) {
        switch (integerFormat) {
            case DECIMAL: 
            case FORMATTED: {
                return this.format(value);
            }
            case HEXADECIMAL: {
                return AnalogTalkgroupFormatter.toHex(value);
            }
        }
        throw new IllegalArgumentException("Unrecognized integer format: " + String.valueOf((Object)integerFormat));
    }
}

