/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.preference.identifier.talkgroup;

import io.github.dsheirer.preference.identifier.IntegerFormat;
import java.text.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIntegerFormatter {
    private static final Logger mLog = LoggerFactory.getLogger(AbstractIntegerFormatter.class);

    public static String toHex(int value) {
        return Integer.toHexString(value).toUpperCase();
    }

    public static String toHex(int value, int width) {
        return String.format("%0" + width + "X", value);
    }

    public static String toDecimal(int value, int width) {
        return String.format("%0" + width + "d", value);
    }

    public String format(int value) {
        return String.valueOf(value);
    }

    public abstract String format(int var1, IntegerFormat var2);

    public int parse(String formattedValue) throws ParseException {
        try {
            return Integer.parseInt(formattedValue.trim());
        }
        catch (Exception exception) {
            mLog.error("Throwing a parse exception for value [" + formattedValue + "]");
            throw new ParseException("Error parsing integer value from [" + formattedValue + "]", 0);
        }
    }
}

