/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.preference.identifier;

import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.patch.PatchGroupIdentifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import io.github.dsheirer.preference.Preference;
import io.github.dsheirer.preference.PreferenceType;
import io.github.dsheirer.preference.identifier.IntegerFormat;
import io.github.dsheirer.preference.identifier.talkgroup.APCO25TalkgroupFormatter;
import io.github.dsheirer.preference.identifier.talkgroup.AnalogTalkgroupFormatter;
import io.github.dsheirer.preference.identifier.talkgroup.DMRTalkgroupFormatter;
import io.github.dsheirer.preference.identifier.talkgroup.FleetsyncTalkgroupFormatter;
import io.github.dsheirer.preference.identifier.talkgroup.LTRTalkgroupFormatter;
import io.github.dsheirer.preference.identifier.talkgroup.MDC1200TalkgroupFormatter;
import io.github.dsheirer.preference.identifier.talkgroup.MPT1327TalkgroupFormatter;
import io.github.dsheirer.preference.identifier.talkgroup.PassportTalkgroupFormatter;
import io.github.dsheirer.protocol.Protocol;
import io.github.dsheirer.sample.Listener;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TalkgroupFormatPreference
extends Preference {
    private static final Logger mLog = LoggerFactory.getLogger(TalkgroupFormatPreference.class);
    private Preferences mPreferences = Preferences.userNodeForPackage(TalkgroupFormatPreference.class);
    public static final String TALKGROUP_FORMAT_PROPERTY = "talkgroup.format.";
    public static final String TALKGROUP_FIXED_WIDTH_PROPERTY = "talkgroup.fixed.width.";
    private Map<Protocol, IntegerFormat> mTalkgroupFormatProtocolMap = new EnumMap<Protocol, IntegerFormat>(Protocol.class);
    private Map<Protocol, Boolean> mTalkgroupFixedWidthProtocolMap = new EnumMap<Protocol, Boolean>(Protocol.class);

    public TalkgroupFormatPreference(Listener<PreferenceType> updateListener) {
        super(updateListener);
        this.loadProperties();
    }

    public String format(Identifier identifier) {
        if (identifier == null) {
            return null;
        }
        switch (identifier.getForm()) {
            case TALKGROUP: {
                if (!(identifier instanceof TalkgroupIdentifier)) break;
                return this.formatTalkgroupIdentifier((TalkgroupIdentifier)identifier);
            }
            case PATCH_GROUP: {
                if (!(identifier instanceof PatchGroupIdentifier)) break;
                return this.formatPatchGroupIdentifier((PatchGroupIdentifier)identifier);
            }
            case RADIO: {
                if (!(identifier instanceof RadioIdentifier)) break;
                return this.formatRadioIdentifier((RadioIdentifier)identifier);
            }
        }
        return identifier.toString();
    }

    @Override
    public PreferenceType getPreferenceType() {
        return PreferenceType.TALKGROUP_FORMAT;
    }

    private void loadProperties() {
        for (Protocol protocol : Protocol.TALKGROUP_PROTOCOLS) {
            this.mTalkgroupFixedWidthProtocolMap.put(protocol, this.mPreferences.getBoolean(this.getTalkgroupFixedWidthProperty(protocol), this.getDefaultFixedWidth(protocol)));
            try {
                String format = this.mPreferences.get(this.getTalkgroupFormatProperty(protocol), TalkgroupFormatPreference.getDefaultFormat(protocol).name());
                this.mTalkgroupFormatProtocolMap.put(protocol, IntegerFormat.valueOf(format));
            }
            catch (Exception e) {
                this.mTalkgroupFormatProtocolMap.put(protocol, TalkgroupFormatPreference.getDefaultFormat(protocol));
            }
        }
    }

    public static IntegerFormat getDefaultFormat(Protocol protocol) {
        switch (protocol) {
            case FLEETSYNC: 
            case LTR: 
            case LTR_NET: 
            case MPT1327: {
                return IntegerFormat.FORMATTED;
            }
        }
        return IntegerFormat.DECIMAL;
    }

    public static Set<IntegerFormat> getFormats(Protocol protocol) {
        switch (protocol) {
            case FLEETSYNC: 
            case LTR: 
            case LTR_NET: 
            case MPT1327: {
                return IntegerFormat.DECIMAL_FORMATTED;
            }
        }
        return IntegerFormat.DECIMAL_HEXADECIMAL;
    }

    private boolean getDefaultFixedWidth(Protocol protocol) {
        switch (protocol) {
            case MDC1200: 
            case PASSPORT: {
                return false;
            }
        }
        return true;
    }

    private String getTalkgroupFixedWidthProperty(Protocol protocol) {
        return TALKGROUP_FIXED_WIDTH_PROPERTY + protocol.name();
    }

    private String getTalkgroupFormatProperty(Protocol protocol) {
        return TALKGROUP_FORMAT_PROPERTY + protocol.name();
    }

    public IntegerFormat getTalkgroupFormat(Protocol protocol) {
        IntegerFormat format = null;
        if (this.mTalkgroupFormatProtocolMap.containsKey((Object)protocol)) {
            format = this.mTalkgroupFormatProtocolMap.get((Object)protocol);
        }
        if (format == null || !TalkgroupFormatPreference.getFormats(protocol).contains((Object)format)) {
            format = TalkgroupFormatPreference.getDefaultFormat(protocol);
        }
        return format;
    }

    public void setTalkgroupFormat(Protocol protocol, IntegerFormat talkgroupFormat) {
        IntegerFormat existing = this.mTalkgroupFormatProtocolMap.get((Object)protocol);
        if (existing == null || existing != talkgroupFormat) {
            this.mTalkgroupFormatProtocolMap.put(protocol, talkgroupFormat);
            this.mPreferences.put(this.getTalkgroupFormatProperty(protocol), talkgroupFormat.name());
            this.notifyPreferenceUpdated();
        }
    }

    public void setTalkgroupFormat(Protocol protocol, boolean fixedWidth) {
        this.mTalkgroupFixedWidthProtocolMap.put(protocol, fixedWidth);
        this.mPreferences.putBoolean(this.getTalkgroupFixedWidthProperty(protocol), fixedWidth);
        this.notifyPreferenceUpdated();
    }

    public boolean isTalkgroupFixedWidth(Protocol protocol) {
        Boolean fixedWidth = this.mTalkgroupFixedWidthProtocolMap.get((Object)protocol);
        if (fixedWidth == null) {
            fixedWidth = false;
        }
        return fixedWidth;
    }

    public void setTalkgroupFixedWidth(Protocol protocol, boolean fixedWidth) {
        if (this.isTalkgroupFixedWidth(protocol) != fixedWidth) {
            this.mTalkgroupFixedWidthProtocolMap.put(protocol, fixedWidth);
            this.mPreferences.putBoolean(this.getTalkgroupFixedWidthProperty(protocol), fixedWidth);
            this.notifyPreferenceUpdated();
        }
    }

    private String formatTalkgroupIdentifier(TalkgroupIdentifier talkgroupIdentifier) {
        switch (talkgroupIdentifier.getProtocol()) {
            case AM: {
                return AnalogTalkgroupFormatter.format(talkgroupIdentifier, this.getTalkgroupFormat(Protocol.AM), this.isTalkgroupFixedWidth(Protocol.AM));
            }
            case APCO25: {
                return APCO25TalkgroupFormatter.format(talkgroupIdentifier, this.getTalkgroupFormat(Protocol.APCO25), this.isTalkgroupFixedWidth(Protocol.APCO25));
            }
            case DMR: {
                return DMRTalkgroupFormatter.format(talkgroupIdentifier, this.getTalkgroupFormat(Protocol.DMR), this.isTalkgroupFixedWidth(Protocol.DMR));
            }
            case FLEETSYNC: {
                return FleetsyncTalkgroupFormatter.format(talkgroupIdentifier, this.getTalkgroupFormat(Protocol.FLEETSYNC), this.isTalkgroupFixedWidth(Protocol.FLEETSYNC));
            }
            case LTR: {
                return LTRTalkgroupFormatter.format(talkgroupIdentifier, this.getTalkgroupFormat(Protocol.LTR), this.isTalkgroupFixedWidth(Protocol.LTR));
            }
            case MDC1200: {
                return MDC1200TalkgroupFormatter.format(talkgroupIdentifier, this.getTalkgroupFormat(Protocol.MDC1200), this.isTalkgroupFixedWidth(Protocol.MDC1200));
            }
            case MPT1327: {
                return MPT1327TalkgroupFormatter.format(talkgroupIdentifier, this.getTalkgroupFormat(Protocol.MPT1327), this.isTalkgroupFixedWidth(Protocol.MPT1327));
            }
            case NBFM: {
                return AnalogTalkgroupFormatter.format(talkgroupIdentifier, this.getTalkgroupFormat(Protocol.NBFM), this.isTalkgroupFixedWidth(Protocol.NBFM));
            }
            case PASSPORT: {
                return PassportTalkgroupFormatter.format(talkgroupIdentifier, this.getTalkgroupFormat(Protocol.PASSPORT), this.isTalkgroupFixedWidth(Protocol.PASSPORT));
            }
        }
        return talkgroupIdentifier.toString();
    }

    private String formatPatchGroupIdentifier(PatchGroupIdentifier patchGroupIdentifier) {
        switch (patchGroupIdentifier.getProtocol()) {
            case APCO25: {
                return APCO25TalkgroupFormatter.format(patchGroupIdentifier, this.getTalkgroupFormat(Protocol.APCO25), this.isTalkgroupFixedWidth(Protocol.APCO25));
            }
        }
        return patchGroupIdentifier.toString();
    }

    private String formatRadioIdentifier(RadioIdentifier radioIdentifier) {
        switch (radioIdentifier.getProtocol()) {
            case APCO25: {
                return APCO25TalkgroupFormatter.format(radioIdentifier, this.getTalkgroupFormat(Protocol.APCO25), this.isTalkgroupFixedWidth(Protocol.APCO25));
            }
            case DMR: {
                return DMRTalkgroupFormatter.format(radioIdentifier, this.getTalkgroupFormat(Protocol.DMR), this.isTalkgroupFixedWidth(Protocol.DMR));
            }
            case PASSPORT: {
                return PassportTalkgroupFormatter.format(radioIdentifier, this.getTalkgroupFormat(Protocol.PASSPORT), this.isTalkgroupFixedWidth(Protocol.PASSPORT));
            }
        }
        return radioIdentifier.toString();
    }
}

