/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.preference.directory;

import io.github.dsheirer.preference.Preference;
import io.github.dsheirer.preference.PreferenceType;
import io.github.dsheirer.sample.Listener;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryPreference
extends Preference {
    private static final Logger mLog = LoggerFactory.getLogger(DirectoryPreference.class);
    private Preferences mPreferences = Preferences.userNodeForPackage(DirectoryPreference.class);
    private static final int DEFAULT_USAGE_THRESHOLD_RECORDINGS_MB = 2000;
    private static final int DEFAULT_USAGE_THRESHOLD_EVENT_LOGS_MB = 200;
    private static final String DIRECTORY_APPLICATION_ROOT = "SDRTrunk";
    private static final String DIRECTORY_APPLICATION_LOG = "logs";
    private static final String DIRECTORY_CONFIGURATION = "configuration";
    private static final String DIRECTORY_EVENT_LOG = "event_logs";
    private static final String DIRECTORY_JMBE = "jmbe";
    private static final String DIRECTORY_PLAYLIST = "playlist";
    private static final String DIRECTORY_RECORDING = "recordings";
    private static final String DIRECTORY_SCREEN_CAPTURE = "screen_captures";
    private static final String DIRECTORY_STREAMING = "streaming";
    private static final String PREFERENCE_KEY_DIRECTORY_APPLICATION_ROOT = "directory.application.root";
    private static final String PREFERENCE_KEY_DIRECTORY_APPLICATION_LOGS = "directory.application.logs";
    private static final String PREFERENCE_KEY_DIRECTORY_CONFIGURATION = "directory.configuration";
    private static final String PREFERENCE_KEY_DIRECTORY_EVENT_LOGS = "directory.event.logs";
    private static final String PREFERENCE_KEY_DIRECTORY_JMBE = "directory.jmbe";
    private static final String PREFERENCE_KEY_DIRECTORY_PLAYLIST = "directory.playlist";
    private static final String PREFERENCE_KEY_DIRECTORY_RECORDING = "directory.recording";
    private static final String PREFERENCE_KEY_DIRECTORY_SCREEN_CAPTURE = "directory.screen.capture";
    private static final String PREFERENCE_KEY_DIRECTORY_STREAMING = "directory.streaming";
    private static final String PREFERENCE_KEY_DIRECTORY_MAX_USAGE_RECORDINGS = "directory.max.usage.recordings";
    private static final String PREFERENCE_KEY_DIRECTORY_MAX_USAGE_EVENT_LOGS = "directory.max.usage.event.logs";
    private Path mDirectoryApplicationRoot;
    private Path mDirectoryApplicationLogs;
    private Path mDirectoryConfiguration;
    private Path mDirectoryEventLogs;
    private Path mDirectoryJmbe;
    private Path mDirectoryPlaylist;
    private Path mDirectoryRecording;
    private Path mDirectoryScreenCapture;
    private Path mDirectoryStreaming;
    private Integer mDirectoryMaxUsageRecordings;
    private Integer mDirectoryMaxUsageEventLogs;

    public DirectoryPreference(Listener<PreferenceType> updateListener) {
        super(updateListener);
    }

    @Override
    public PreferenceType getPreferenceType() {
        return PreferenceType.DIRECTORY;
    }

    public Path getDirectoryApplicationRoot() {
        if (this.mDirectoryApplicationRoot == null) {
            this.mDirectoryApplicationRoot = this.getPath(PREFERENCE_KEY_DIRECTORY_APPLICATION_ROOT, this.getDefaultApplicationDirectory());
            this.createDirectory(this.mDirectoryApplicationRoot);
        }
        return this.mDirectoryApplicationRoot;
    }

    public void setDirectoryApplicationRoot(Path path) {
        this.mDirectoryApplicationRoot = path;
        this.mPreferences.put(PREFERENCE_KEY_DIRECTORY_APPLICATION_ROOT, path.toString());
        this.nullifyApplicationChildDirectories();
        this.notifyPreferenceUpdated();
    }

    private void nullifyApplicationChildDirectories() {
        this.mDirectoryApplicationLogs = null;
        this.mDirectoryEventLogs = null;
        this.mDirectoryJmbe = null;
        this.mDirectoryPlaylist = null;
        this.mDirectoryRecording = null;
        this.mDirectoryScreenCapture = null;
        this.mDirectoryStreaming = null;
    }

    public int getDirectoryMaxUsageRecordings() {
        if (this.mDirectoryMaxUsageRecordings == null) {
            this.mDirectoryMaxUsageRecordings = this.mPreferences.getInt(PREFERENCE_KEY_DIRECTORY_MAX_USAGE_RECORDINGS, 2000);
        }
        return this.mDirectoryMaxUsageRecordings;
    }

    public void setDirectoryMaxUsageRecordings(int thresholdMB) {
        this.mPreferences.putInt(PREFERENCE_KEY_DIRECTORY_MAX_USAGE_RECORDINGS, thresholdMB);
        this.mDirectoryMaxUsageRecordings = thresholdMB;
        this.notifyPreferenceUpdated();
    }

    public int getDirectoryMaxUsageEventLogs() {
        if (this.mDirectoryMaxUsageEventLogs == null) {
            this.mDirectoryMaxUsageEventLogs = this.mPreferences.getInt(PREFERENCE_KEY_DIRECTORY_MAX_USAGE_EVENT_LOGS, 200);
        }
        return this.mDirectoryMaxUsageEventLogs;
    }

    public void setDirectoryMaxUsageEventLogs(int thresholdMB) {
        this.mPreferences.putInt(PREFERENCE_KEY_DIRECTORY_MAX_USAGE_EVENT_LOGS, thresholdMB);
        this.mDirectoryMaxUsageEventLogs = thresholdMB;
        this.notifyPreferenceUpdated();
    }

    public void resetDirectoryApplicationRoot() {
        this.mDirectoryApplicationRoot = null;
        this.mPreferences.remove(PREFERENCE_KEY_DIRECTORY_APPLICATION_ROOT);
        this.nullifyApplicationChildDirectories();
        this.notifyPreferenceUpdated();
    }

    public Path getDirectoryApplicationLog() {
        if (this.mDirectoryApplicationLogs == null) {
            this.mDirectoryApplicationLogs = this.getPath(PREFERENCE_KEY_DIRECTORY_APPLICATION_LOGS, this.getDefaultApplicationLogsDirectory());
            this.createDirectory(this.mDirectoryApplicationLogs);
        }
        return this.mDirectoryApplicationLogs;
    }

    public void setDirectoryApplicationLogs(Path path) {
        this.mDirectoryApplicationLogs = path;
        this.mPreferences.put(PREFERENCE_KEY_DIRECTORY_APPLICATION_LOGS, path.toString());
        this.notifyPreferenceUpdated();
    }

    public void resetDirectoryApplicationLogs() {
        this.mPreferences.remove(PREFERENCE_KEY_DIRECTORY_APPLICATION_LOGS);
        this.mDirectoryApplicationLogs = null;
        this.notifyPreferenceUpdated();
    }

    public Path getDirectoryConfiguration() {
        if (this.mDirectoryConfiguration == null) {
            this.mDirectoryConfiguration = this.getPath(PREFERENCE_KEY_DIRECTORY_CONFIGURATION, this.getDefaultConfigurationDirectory());
            this.createDirectory(this.mDirectoryConfiguration);
        }
        return this.mDirectoryConfiguration;
    }

    public void setDirectoryConfiguration(Path path) {
        this.mDirectoryConfiguration = path;
        this.mPreferences.put(PREFERENCE_KEY_DIRECTORY_CONFIGURATION, path.toString());
        this.notifyPreferenceUpdated();
    }

    public void resetDirectoryConfiguration() {
        this.mPreferences.remove(PREFERENCE_KEY_DIRECTORY_CONFIGURATION);
        this.mDirectoryConfiguration = null;
        this.notifyPreferenceUpdated();
    }

    public Path getDirectoryEventLog() {
        if (this.mDirectoryEventLogs == null) {
            this.mDirectoryEventLogs = this.getPath(PREFERENCE_KEY_DIRECTORY_EVENT_LOGS, this.getDefaultEventLogsDirectory());
            this.createDirectory(this.mDirectoryEventLogs);
        }
        return this.mDirectoryEventLogs;
    }

    public void setDirectoryEventLogs(Path path) {
        this.mDirectoryEventLogs = path;
        this.mPreferences.put(PREFERENCE_KEY_DIRECTORY_EVENT_LOGS, path.toString());
        this.notifyPreferenceUpdated();
    }

    public void resetDirectoryEventLogs() {
        this.mPreferences.remove(PREFERENCE_KEY_DIRECTORY_EVENT_LOGS);
        this.mDirectoryEventLogs = null;
        this.notifyPreferenceUpdated();
    }

    public Path getDirectoryJmbe() {
        if (this.mDirectoryJmbe == null) {
            this.mDirectoryJmbe = this.getPath(PREFERENCE_KEY_DIRECTORY_JMBE, this.getDefaultJmbeDirectory());
            this.createDirectory(this.mDirectoryJmbe);
        }
        return this.mDirectoryJmbe;
    }

    public void setDirectoryJmbe(Path path) {
        this.mDirectoryJmbe = path;
        this.mPreferences.put(PREFERENCE_KEY_DIRECTORY_JMBE, path.toString());
        this.notifyPreferenceUpdated();
    }

    public void resetDirectoryJmbe() {
        this.mPreferences.remove(PREFERENCE_KEY_DIRECTORY_JMBE);
        this.mDirectoryJmbe = null;
        this.notifyPreferenceUpdated();
    }

    public Path getDirectoryPlaylist() {
        if (this.mDirectoryPlaylist == null) {
            this.mDirectoryPlaylist = this.getPath(PREFERENCE_KEY_DIRECTORY_PLAYLIST, this.getDefaultPlaylistDirectory());
            this.createDirectory(this.mDirectoryPlaylist);
        }
        return this.mDirectoryPlaylist;
    }

    public void setDirectoryPlaylist(Path path) {
        this.mDirectoryPlaylist = path;
        this.mPreferences.put(PREFERENCE_KEY_DIRECTORY_PLAYLIST, path.toString());
        this.notifyPreferenceUpdated();
    }

    public void resetDirectoryPlaylist() {
        this.mPreferences.remove(PREFERENCE_KEY_DIRECTORY_PLAYLIST);
        this.mDirectoryPlaylist = null;
        this.notifyPreferenceUpdated();
    }

    public Path getDirectoryRecording() {
        if (this.mDirectoryRecording == null) {
            this.mDirectoryRecording = this.getPath(PREFERENCE_KEY_DIRECTORY_RECORDING, this.getDefaultRecordingDirectory());
            this.createDirectory(this.mDirectoryRecording);
        }
        return this.mDirectoryRecording;
    }

    public void setDirectoryRecording(Path path) {
        this.mDirectoryRecording = path;
        this.mPreferences.put(PREFERENCE_KEY_DIRECTORY_RECORDING, path.toString());
        this.notifyPreferenceUpdated();
    }

    public void resetDirectoryRecording() {
        this.mPreferences.remove(PREFERENCE_KEY_DIRECTORY_RECORDING);
        this.mDirectoryRecording = null;
        this.notifyPreferenceUpdated();
    }

    public Path getDirectoryScreenCapture() {
        if (this.mDirectoryScreenCapture == null) {
            this.mDirectoryScreenCapture = this.getPath(PREFERENCE_KEY_DIRECTORY_SCREEN_CAPTURE, this.getDefaultScreenCaptureDirectory());
            this.createDirectory(this.mDirectoryScreenCapture);
        }
        return this.mDirectoryScreenCapture;
    }

    public void setDirectoryScreenCapture(Path path) {
        this.mDirectoryScreenCapture = path;
        this.mPreferences.put(PREFERENCE_KEY_DIRECTORY_SCREEN_CAPTURE, path.toString());
        this.notifyPreferenceUpdated();
    }

    public void resetDirectoryScreenCapture() {
        this.mPreferences.remove(PREFERENCE_KEY_DIRECTORY_SCREEN_CAPTURE);
        this.mDirectoryScreenCapture = null;
        this.notifyPreferenceUpdated();
    }

    public Path getDirectoryStreaming() {
        if (this.mDirectoryStreaming == null) {
            this.mDirectoryStreaming = this.getPath(PREFERENCE_KEY_DIRECTORY_STREAMING, this.getDefaultStreamingDirectory());
            this.createDirectory(this.mDirectoryStreaming);
        }
        return this.mDirectoryStreaming;
    }

    public void setDirectoryStreaming(Path path) {
        this.mDirectoryStreaming = path;
        this.mPreferences.put(PREFERENCE_KEY_DIRECTORY_STREAMING, path.toString());
        this.notifyPreferenceUpdated();
    }

    public void resetDirectoryStreaming() {
        this.mPreferences.remove(PREFERENCE_KEY_DIRECTORY_STREAMING);
        this.mDirectoryStreaming = null;
        this.notifyPreferenceUpdated();
    }

    private Path getDefaultApplicationDirectory() {
        return Paths.get(System.getProperty("user.home"), DIRECTORY_APPLICATION_ROOT);
    }

    public Path getDefaultApplicationLogsDirectory() {
        return this.getDirectoryApplicationRoot().resolve(DIRECTORY_APPLICATION_LOG);
    }

    public Path getDefaultConfigurationDirectory() {
        return this.getDirectoryApplicationRoot().resolve(DIRECTORY_CONFIGURATION);
    }

    public Path getDefaultEventLogsDirectory() {
        return this.getDirectoryApplicationRoot().resolve(DIRECTORY_EVENT_LOG);
    }

    public Path getDefaultJmbeDirectory() {
        return this.getDirectoryApplicationRoot().resolve(DIRECTORY_JMBE);
    }

    public Path getDefaultPlaylistDirectory() {
        return this.getDirectoryApplicationRoot().resolve(DIRECTORY_PLAYLIST);
    }

    public Path getDefaultRecordingDirectory() {
        return this.getDirectoryApplicationRoot().resolve(DIRECTORY_RECORDING);
    }

    public Path getDefaultScreenCaptureDirectory() {
        return this.getDirectoryApplicationRoot().resolve(DIRECTORY_SCREEN_CAPTURE);
    }

    public Path getDefaultStreamingDirectory() {
        return this.getDirectoryApplicationRoot().resolve(DIRECTORY_STREAMING);
    }

    private Path getPath(String key, Path defaultPath) {
        Path temp;
        String stringPath = this.mPreferences.get(key, defaultPath.toString());
        if (stringPath != null && !stringPath.isEmpty() && Files.exists(temp = Paths.get(stringPath, new String[0]), new LinkOption[0])) {
            return temp;
        }
        return defaultPath;
    }

    private void createDirectory(Path directory) {
        if (!Files.exists(directory, new LinkOption[0])) {
            try {
                Files.createDirectory(directory, new FileAttribute[0]);
                mLog.info("Created directory [" + directory.toString() + "]");
            }
            catch (Exception e) {
                mLog.error("Error creating directory [" + directory.toString() + "]");
            }
        }
    }
}

