/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.monitor;

import io.github.dsheirer.monitor.ResourceMonitor;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;

public class StatusBox
extends HBox {
    private ResourceMonitor mResourceMonitor;

    public StatusBox(ResourceMonitor resourceMonitor) {
        this.mResourceMonitor = resourceMonitor;
        this.setPadding(new Insets(1.0, 0.0, 1.0, 0.0));
        this.setSpacing(6.0);
        Label cpuLabel = new Label("CPU:");
        cpuLabel.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
        cpuLabel.setAlignment(Pos.CENTER_RIGHT);
        this.getChildren().add((Object)cpuLabel);
        ProgressBar cpuIndicator = new ProgressBar();
        cpuIndicator.progressProperty().bind((ObservableValue)this.mResourceMonitor.cpuPercentageProperty());
        cpuIndicator.disableProperty().bind((ObservableValue)this.mResourceMonitor.cpuAvailableProperty().not());
        cpuIndicator.setTooltip(new Tooltip("Java process CPU usage. Disabled if the CPU loading is not available from the OS"));
        this.getChildren().add((Object)cpuIndicator);
        Label memoryLabel = new Label("Allocated Memory:");
        memoryLabel.setAlignment(Pos.CENTER_RIGHT);
        this.getChildren().add((Object)memoryLabel);
        ProgressBar memoryBar = new ProgressBar();
        memoryBar.progressProperty().bind((ObservableValue)this.mResourceMonitor.systemMemoryUsedPercentageProperty());
        memoryBar.setTooltip(new Tooltip("Percentage of total system memory that Java has reserved from the Operating System."));
        this.getChildren().add((Object)memoryBar);
        Label javaMemoryLabel = new Label("Used Memory:");
        javaMemoryLabel.setAlignment(Pos.CENTER_RIGHT);
        this.getChildren().add((Object)javaMemoryLabel);
        ProgressBar javaMemoryBar = new ProgressBar();
        javaMemoryBar.progressProperty().bind((ObservableValue)this.mResourceMonitor.javaMemoryUsedPercentageProperty());
        javaMemoryBar.setTooltip(new Tooltip("Percentage of allocated memory that Java/sdrtrunk is currently using. This value fluctuates as Java manages memory and garbage collection"));
        this.getChildren().add((Object)javaMemoryBar);
        Label eventLogsLabel = new Label("Event Logs:");
        eventLogsLabel.setAlignment(Pos.CENTER_RIGHT);
        this.getChildren().add((Object)eventLogsLabel);
        ProgressBar eventLogsBar = new ProgressBar();
        eventLogsBar.progressProperty().bind((ObservableValue)this.mResourceMonitor.directoryUsePercentEventLogsProperty());
        eventLogsBar.setTooltip(new Tooltip("Percentage of drive space used for event logs based on user-specified max threshold in user preferences"));
        this.getChildren().add((Object)eventLogsBar);
        Label eventLogsSizeLabel = new Label();
        eventLogsSizeLabel.textProperty().bind((ObservableValue)this.mResourceMonitor.fileSizeEventLogsProperty());
        eventLogsSizeLabel.setAlignment(Pos.CENTER_RIGHT);
        this.getChildren().add((Object)eventLogsSizeLabel);
        Label recordingsLabel = new Label("Recordings:");
        recordingsLabel.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
        recordingsLabel.setAlignment(Pos.CENTER_RIGHT);
        this.getChildren().add((Object)recordingsLabel);
        ProgressBar recordingsBar = new ProgressBar();
        recordingsBar.progressProperty().bind((ObservableValue)this.mResourceMonitor.directoryUsePercentRecordingsProperty());
        recordingsBar.setTooltip(new Tooltip("Percentage of drive space used for recordings based on user-specified max threshold in user preferences"));
        this.getChildren().add((Object)recordingsBar);
        Label recordingsSizeLabel = new Label();
        recordingsSizeLabel.textProperty().bind((ObservableValue)this.mResourceMonitor.fileSizeRecordingsProperty());
        recordingsSizeLabel.setAlignment(Pos.CENTER_RIGHT);
        this.getChildren().add((Object)recordingsSizeLabel);
    }
}

