/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.tait;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.edac.CRC;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.message.Message;
import io.github.dsheirer.module.decode.tait.identifier.TaitIdentifier;
import io.github.dsheirer.protocol.Protocol;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tait1200GPSMessage
extends Message {
    private static final Logger mLog = LoggerFactory.getLogger(Tait1200GPSMessage.class);
    public static int[] REVS_1 = new int[]{0, 1, 2, 3};
    public static int[] SYNC = new int[]{4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19};
    public static int[] SIZE = new int[]{20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35};
    public static int[] FROM_DIGIT_1 = new int[]{36, 37, 38, 39, 40, 41, 42, 43};
    public static int[] FROM_DIGIT_2 = new int[]{44, 45, 46, 47, 48, 49, 50, 51};
    public static int[] FROM_DIGIT_3 = new int[]{52, 53, 54, 55, 56, 57, 58, 59};
    public static int[] FROM_DIGIT_4 = new int[]{60, 61, 62, 63, 64, 65, 66, 67};
    public static int[] FROM_DIGIT_5 = new int[]{68, 69, 70, 71, 72, 73, 74, 75};
    public static int[] FROM_DIGIT_6 = new int[]{76, 77, 78, 79, 80, 81, 82, 83};
    public static int[] FROM_DIGIT_7 = new int[]{84, 85, 86, 87, 88, 89, 90, 91};
    public static int[] FROM_DIGIT_8 = new int[]{92, 93, 94, 95, 96, 97, 98, 99};
    public static int[] CHECKSUM_1 = new int[]{100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115};
    public static int[] REVS_2 = new int[]{116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131};
    public static int[] SIZE_2 = new int[]{188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203};
    public static int[] TO_DIGIT_1 = new int[]{204, 205, 206, 207, 208, 209, 210, 211};
    public static int[] TO_DIGIT_2 = new int[]{212, 213, 214, 215, 216, 217, 218, 219};
    public static int[] TO_DIGIT_3 = new int[]{220, 221, 222, 223, 224, 225, 226, 227};
    public static int[] TO_DIGIT_4 = new int[]{228, 229, 230, 231, 232, 233, 234, 235};
    public static int[] TO_DIGIT_5 = new int[]{236, 237, 238, 239, 240, 241, 242, 243};
    public static int[] TO_DIGIT_6 = new int[]{244, 245, 246, 247, 248, 249, 250, 251};
    public static int[] TO_DIGIT_7 = new int[]{252, 253, 254, 255, 256, 257, 258, 259};
    public static int[] TO_DIGIT_8 = new int[]{260, 261, 262, 263, 264, 265, 266, 267};
    public static int[] UNKNOWN_1 = new int[]{268, 269, 270, 271, 272, 273, 274, 275};
    public static int[] CHECKSUM_2 = new int[]{276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291};
    public static int DIVIDER_1 = 292;
    public static int[] HOUR_TENS = new int[]{293, 294, 295};
    public static int[] HOUR_ONES = new int[]{296, 297, 298, 299};
    public static int DIVIDER_2 = 300;
    public static int[] MINUTES_TENS = new int[]{301, 302, 303};
    public static int[] MINUTES_ONES = new int[]{304, 305, 306, 307};
    public static int DIVIDER_3 = 308;
    public static int[] SECONDS_TENS = new int[]{309, 310, 311};
    public static int[] SECONDS_ONES = new int[]{312, 313, 314, 315};
    public static int DIVIDER_4 = 316;
    public static int[] LATITUDE_SIGN = new int[]{317, 318};
    public static int DIVIDER_5 = 319;
    public static int[] LATITUDE_DEGREES_TENS = new int[]{320, 321, 322, 323};
    public static int[] LATITUDE_DEGREES_ONES = new int[]{324, 325, 326, 327};
    public static int DIVIDER_6 = 328;
    public static int[] LATITUDE_MINUTES_TENS = new int[]{329, 330, 331};
    public static int[] LATITUDE_MINUTES_ONES = new int[]{332, 333, 334, 335};
    public static int[] LATITUDE_SECONDS_HUND = new int[]{336, 337, 338, 339};
    public static int[] LATITUDE_SECONDS_TENS = new int[]{340, 341, 342, 344};
    public static int[] LATITUDE_SECONDS_ONES = new int[]{344, 345, 346, 347};
    public static int DIVIDER_7 = 348;
    public static int[] LONGITUDE_SIGN = new int[]{349, 350};
    public static int LONGITUDE_DEGREES_HUNDREDS = 351;
    public static int[] LONGITUDE_DEGREES_TENS = new int[]{352, 353, 354, 355};
    public static int[] LONGITUDE_DEGREES_ONES = new int[]{356, 357, 358, 359};
    public static int DIVIDER_9 = 360;
    public static int[] LONGITUDE_MINUTES_TENS = new int[]{361, 362, 363};
    public static int[] LONGITUDE_MINUTES_ONES = new int[]{364, 365, 366, 367};
    public static int[] LONGITUDE_SECONDS_HUND = new int[]{368, 369, 370, 371};
    public static int[] LONGITUDE_SECONDS_TENS = new int[]{372, 373, 374, 375};
    public static int[] LONGITUDE_SECONDS_ONES = new int[]{376, 377, 378, 379};
    public static int DIVIDER_10 = 380;
    public static int[] DATE_DAY_TENS = new int[]{381, 382, 383};
    public static int[] DATE_DAY_ONES = new int[]{384, 385, 386, 387};
    public static int[] DATE_MONTH = new int[]{388, 389, 390, 391};
    public static int[] SPEED_HUNDREDS = new int[]{388, 389, 390, 391};
    public static int[] SPEED_TENS = new int[]{392, 393, 394, 395};
    public static int[] SPEED_ONES = new int[]{396, 397, 398, 399};
    public static int[] SPEED_TENTHS = new int[]{400, 401, 402, 403};
    private static SimpleDateFormat mSDF = new SimpleDateFormat("yyyyMMdd HHmmss");
    private BinaryMessage mMessage;
    private CRC mCRC;
    private TaitIdentifier mFromIdentifier;
    private TaitIdentifier mToIdentifier;
    private List<Identifier> mIdentifiers;

    public Tait1200GPSMessage(BinaryMessage message) {
        this.mMessage = message;
    }

    public TaitIdentifier getFromIdentifier() {
        if (this.mFromIdentifier == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getCharacter(FROM_DIGIT_1));
            sb.append(this.getCharacter(FROM_DIGIT_2));
            sb.append(this.getCharacter(FROM_DIGIT_3));
            sb.append(this.getCharacter(FROM_DIGIT_4));
            sb.append(this.getCharacter(FROM_DIGIT_5));
            sb.append(this.getCharacter(FROM_DIGIT_6));
            sb.append(this.getCharacter(FROM_DIGIT_7));
            sb.append(this.getCharacter(FROM_DIGIT_8));
            this.mFromIdentifier = TaitIdentifier.createFrom(sb.toString().trim());
        }
        return this.mFromIdentifier;
    }

    public TaitIdentifier getToIdentifier() {
        if (this.mToIdentifier == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getCharacter(TO_DIGIT_1));
            sb.append(this.getCharacter(TO_DIGIT_2));
            sb.append(this.getCharacter(TO_DIGIT_3));
            sb.append(this.getCharacter(TO_DIGIT_4));
            sb.append(this.getCharacter(TO_DIGIT_5));
            sb.append(this.getCharacter(TO_DIGIT_6));
            sb.append(this.getCharacter(TO_DIGIT_7));
            sb.append(this.getCharacter(TO_DIGIT_8));
            this.mToIdentifier = TaitIdentifier.createTo(sb.toString().trim());
        }
        return this.mToIdentifier;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getFromIdentifier());
            this.mIdentifiers.add(this.getToIdentifier());
        }
        return this.mIdentifiers;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public int getMessage1Size() {
        return this.mMessage.getInt(SIZE);
    }

    public int getMessage2Size() {
        return this.mMessage.getInt(SIZE_2);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GPS FROM:").append(this.getFromIdentifier());
        sb.append(" TO:").append(this.getToIdentifier());
        sb.append(" LOCATION:");
        GeoPosition location = this.getGPSLocation();
        sb.append(location.getLatitude());
        sb.append(" ");
        sb.append(location.getLongitude());
        sb.append(" SPEED:").append(this.getSpeed()).append("KPH");
        sb.append(" GPS TIME:");
        sb.append(mSDF.format(new Date(this.getGPSTime())));
        sb.append(" ");
        sb.append(this.mMessage.toString());
        return sb.toString();
    }

    public GeoPosition getGPSLocation() {
        double latitude = (double)this.mMessage.getInt(LATITUDE_DEGREES_TENS) * 10.0;
        latitude += (double)this.mMessage.getInt(LATITUDE_DEGREES_ONES);
        latitude += (double)this.mMessage.getInt(LATITUDE_MINUTES_TENS) / 6.0;
        latitude += (double)this.mMessage.getInt(LATITUDE_MINUTES_ONES) / 60.0;
        latitude += (double)this.mMessage.getInt(LATITUDE_SECONDS_HUND) / 600.0;
        latitude += (double)this.mMessage.getInt(LATITUDE_SECONDS_TENS) / 6000.0;
        latitude += (double)this.mMessage.getInt(LATITUDE_SECONDS_ONES) / 60000.0;
        if (this.mMessage.getInt(LATITUDE_SIGN) == 0) {
            latitude *= -1.0;
        }
        double longitude = this.mMessage.get(LONGITUDE_DEGREES_HUNDREDS) ? 100.0 : 0.0;
        longitude += (double)this.mMessage.getInt(LONGITUDE_DEGREES_TENS) * 10.0;
        longitude += (double)this.mMessage.getInt(LONGITUDE_DEGREES_ONES);
        longitude += (double)this.mMessage.getInt(LONGITUDE_MINUTES_TENS) / 6.0;
        longitude += (double)this.mMessage.getInt(LONGITUDE_MINUTES_ONES) / 60.0;
        longitude += (double)this.mMessage.getInt(LONGITUDE_SECONDS_HUND) / 600.0;
        longitude += (double)this.mMessage.getInt(LONGITUDE_SECONDS_TENS) / 6000.0;
        longitude += (double)this.mMessage.getInt(LONGITUDE_SECONDS_ONES) / 60000.0;
        if (this.mMessage.getInt(LONGITUDE_SIGN) == 0) {
            longitude = -1.0;
        }
        return new GeoPosition(latitude, longitude);
    }

    public long getGPSTime() {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.clear();
        cal.setTimeInMillis(System.currentTimeMillis());
        cal.set(2, this.mMessage.getInt(DATE_MONTH));
        int day = this.mMessage.getInt(DATE_DAY_TENS) * 10 + this.mMessage.getInt(DATE_DAY_ONES);
        cal.set(5, day);
        cal.set(11, this.mMessage.getInt(HOUR_TENS) * 10 + this.mMessage.getInt(HOUR_ONES));
        cal.set(12, this.mMessage.getInt(MINUTES_TENS) * 10 + this.mMessage.getInt(MINUTES_ONES));
        cal.set(13, this.mMessage.getInt(SECONDS_TENS) * 10 + this.mMessage.getInt(SECONDS_ONES));
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public double getSpeed() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDigit(SPEED_HUNDREDS));
        sb.append(this.getDigit(SPEED_TENS));
        sb.append(this.getDigit(SPEED_ONES));
        sb.append(".");
        sb.append(this.getDigit(SPEED_TENTHS));
        try {
            return Double.parseDouble(sb.toString());
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    private String getDigit(int[] field) {
        int value = this.mMessage.getInt(field);
        return 0 <= value && value <= 9 ? String.valueOf(value) : "?";
    }

    public char getCharacter(int[] bits) {
        int value = this.mMessage.getInt(bits);
        return (char)value;
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.TAIT1200;
    }
}

