/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.tait;

import io.github.dsheirer.channel.state.DecoderState;
import io.github.dsheirer.channel.state.DecoderStateEvent;
import io.github.dsheirer.channel.state.State;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.MutableIdentifierCollection;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.event.DecodeEvent;
import io.github.dsheirer.module.decode.event.DecodeEventType;
import io.github.dsheirer.module.decode.event.PlottableDecodeEvent;
import io.github.dsheirer.module.decode.tait.Tait1200ANIMessage;
import io.github.dsheirer.module.decode.tait.Tait1200GPSMessage;
import io.github.dsheirer.module.decode.tait.identifier.TaitIdentifier;
import io.github.dsheirer.protocol.Protocol;
import java.util.TreeSet;
import org.jdesktop.swingx.mapviewer.GeoPosition;

public class Tait1200DecoderState
extends DecoderState {
    public static final Protocol PROTOCOL_TAIT_1200 = Protocol.TAIT1200;
    private TreeSet<TaitIdentifier> mIdents = new TreeSet();

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.TAIT_1200;
    }

    @Override
    public void reset() {
        super.reset();
        this.mIdents.clear();
        this.resetState();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void init() {
    }

    @Override
    public void receive(IMessage message) {
        if (message instanceof Tait1200GPSMessage) {
            Tait1200GPSMessage gps = (Tait1200GPSMessage)message;
            this.mIdents.add(gps.getFromIdentifier());
            this.mIdents.add(gps.getToIdentifier());
            GeoPosition position = gps.getGPSLocation();
            if (position != null) {
                MutableIdentifierCollection ic = new MutableIdentifierCollection(this.getIdentifierCollection().getIdentifiers());
                ic.remove(IdentifierClass.USER);
                ic.update(message.getIdentifiers());
                PlottableDecodeEvent event = PlottableDecodeEvent.plottableBuilder(DecodeEventType.GPS, gps.getTimestamp()).protocol(PROTOCOL_TAIT_1200).identifiers(ic).location(position).speed(gps.getSpeed()).build();
                this.broadcast(event);
            }
            this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.DECODE, State.DATA));
        } else if (message instanceof Tait1200ANIMessage) {
            Tait1200ANIMessage ani = (Tait1200ANIMessage)message;
            this.mIdents.add(ani.getFromIdentifier());
            this.mIdents.add(ani.getToIdentifier());
            MutableIdentifierCollection ic = new MutableIdentifierCollection(this.getIdentifierCollection().getIdentifiers());
            ic.remove(IdentifierClass.USER);
            ic.update(message.getIdentifiers());
            this.broadcast(DecodeEvent.builder(DecodeEventType.ID_ANI, ani.getTimestamp()).protocol(PROTOCOL_TAIT_1200).identifiers(ic).details("Automatic Number Identification").build());
            this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.DECODE, State.CALL));
        }
    }

    @Override
    public String getActivitySummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("=============================\n");
        sb.append("Decoder:\tTait-1200I\n\n");
        if (!this.mIdents.isEmpty()) {
            sb.append("Radio Identifiers:\n");
            for (TaitIdentifier taitIdentifier : this.mIdents) {
                sb.append("\t").append(taitIdentifier).append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public void receiveDecoderStateEvent(DecoderStateEvent event) {
        switch (event.getEvent()) {
            case REQUEST_RESET: {
                this.resetState();
                break;
            }
        }
    }
}

