/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.passport;

import io.github.dsheirer.bits.MessageFramer;
import io.github.dsheirer.bits.SyncPattern;
import io.github.dsheirer.dsp.fsk.LTRDecoder;
import io.github.dsheirer.module.decode.Decoder;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.config.DecodeConfiguration;
import io.github.dsheirer.module.decode.passport.PassportMessageProcessor;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.real.IRealBufferListener;

public class PassportDecoder
extends Decoder
implements IRealBufferListener,
Listener<float[]> {
    public static final int PASSPORT_MESSAGE_LENGTH = 68;
    private LTRDecoder mLTRDecoder = new LTRDecoder();
    private MessageFramer mPassportMessageFramer = new MessageFramer(SyncPattern.PASSPORT.getPattern(), 68);
    private PassportMessageProcessor mPassportMessageProcessor;

    public PassportDecoder(DecodeConfiguration config) {
        this.mLTRDecoder.setListener(bits -> {
            for (boolean bit : bits) {
                this.mPassportMessageFramer.process(bit);
            }
        });
        this.mPassportMessageProcessor = new PassportMessageProcessor();
        this.mPassportMessageFramer.addMessageListener(this.mPassportMessageProcessor);
        this.mPassportMessageProcessor.setMessageListener(this.getMessageListener());
    }

    @Override
    public Listener<float[]> getBufferListener() {
        return this.mLTRDecoder;
    }

    @Override
    public void receive(float[] realBuffer) {
        this.mLTRDecoder.receive(realBuffer);
    }

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.PASSPORT;
    }

    @Override
    public void reset() {
        this.mPassportMessageFramer.reset();
    }
}

