/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.reference;

public class RegroupOptions {
    private static final int MASK_REGROUP_TYPE = 128;
    private static final int MASK_GROUP_INDIVIDUAL = 64;
    private static final int MASK_ACTIVATE = 32;
    private static final int MASK_SUPERGROUP_SEQUENCE_NUMBER = 31;
    private int mValue;

    public RegroupOptions(int value) {
        this.mValue = value;
    }

    public RegroupType getRegroupType() {
        return (this.mValue & 0x80) == 128 ? RegroupType.SIMULSELECT_ONE_WAY_REGROUP : RegroupType.PATCH_TWO_WAY_REGROUP;
    }

    public boolean isPatch() {
        return this.getRegroupType() == RegroupType.PATCH_TWO_WAY_REGROUP;
    }

    public boolean isTalkgroupAddress() {
        return (this.mValue & 0x40) == 64;
    }

    public boolean isActivate() {
        return (this.mValue & 0x20) == 32;
    }

    public int getSupergroupSequenceNumber() {
        return this.mValue & 0x1F;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.isActivate() ? "ACTIVATE" : "DEACTIVATE");
        sb.append(this.isTalkgroupAddress() ? " TALKGROUP" : " INDIVIDUAL");
        sb.append(this.isPatch() ? " PATCH" : " SIMUL-SELECT");
        return sb.toString();
    }

    public static enum RegroupType {
        PATCH_TWO_WAY_REGROUP,
        SIMULSELECT_ONE_WAY_REGROUP;

    }
}

